/*
	Copyright 1993-1997 by Ryuuji Oomoto (oomoto@tpp.epson.co.jp)
					All Rights Reserved
*/


/*
	Do not ask me about this source code.
	Mr Oomoto is the only person who know this source code.

	The Image
		SOI
		Frame 1
		Frame 2
		.......
		EOI

	A Frame
		SOF
		Frame Header
		Scan 1
		Scan 2
		Scan 3
		......

	A Scan
		SOS
		Scan Header
		Data
*/


#include "xslideshow.h"

#if defined(__STDC__) || defined(__cplusplus)
# define P_(s) s
#else
# define P_(s) ()
#endif

extern void goodbyekiss P_(());
extern void myevent P_(());
static ErrStatus get_image P_(());
static void out_image P_(());
static void set_add P_(());

static word table[4][4096],*tablet;
static short mul179[256];
static short muln44[256];
static short mul91[256];
static short mul227[256];
static byte limit[256+256+256];

static dword *buffer;
static byte cmp[256][3],col[4],jfif[16];
static byte *hufdct,*hufact;
static int dcsum[4],s_start,s_end,bit_h,bit_l,progress,wd4,width;
static short mm[8][8],*mm0;
static int bit,xmax,ymax,cmax,dri_n,cl_num,mcu,xnum0,ynum0,comp,pp,eof;
static int x,y,xx2[4],ycount,xx,yy,eobrun,xnum,ynum,pq,xmax154;
static int num_dc,num_ac,hufac13[4];
static dword sft[33],msk[33],*zhdct,*zhact;
static dword zcd,lbyte,address;
static short *fin[3],ex_file[3];
static byte zig[64] = {
	 0, 1, 8,16, 9, 2, 3,10,
	17,24,32,25,18,11, 4, 5,
	12,19,26,33,40,48,41,34,
	27,20,13, 6, 7,14,21,28,
	35,42,49,56,57,50,43,36,
	29,22,15,23,30,37,44,51,
	58,59,52,45,38,31,39,46,
	53,60,61,54,47,55,62,63
};
static int qt[4][64],*qtp,*qtp0;
static byte leng[16],prog_cl[256];
static byte ndc[4],nac[4],tdc[4],tac[4],xnm[4],ynm[4],qtn[4];
static byte hufdc[4][2][16],hufac[4][2][256],numac[4],numdc[4];
static dword zhdc[4][16],zhac[4][256];

static SUBGIMAGE *subImageList;

/*
*
*/
static ErrStatus Do_jpg2gimage()
{
ErrStatus err;
int a,b,d,i,j,k,l,n,p,t;
long offs;
int tmp[12];

	/* Search the JPEG header */
	while(!feof(fp)){
		if((tmp[0] = getc(fp)) == 0xff){
			offs = ftell(fp);
			for(i=1; i<11; i++){ tmp[i] = getc(fp); }
			if(feof(fp)) break;
			if(	(tmp[0] == 0xff)
				&& (tmp[1] == 0xd8) /* SOI (Start Of Image) */
				&& (tmp[2] == 0xff)
				/* APP0 */
				&& ((tmp[ 3] == 0xe0) || (tmp[ 3] == 0xe1))
				&& (
	   ((tmp[6]&0x5f)=='J' && (tmp[7]&0x5f)=='F' && (tmp[8]&0x5f)=='I' && (tmp[9]&0x5f)=='F')
	|| ((tmp[6]&0x5f)=='J' && (tmp[7]&0x5f)=='F' && (tmp[8]&0x5f)=='X' && (tmp[9]&0x5f)=='X')
	|| ((tmp[6]&0x5f)=='E' && (tmp[7]&0x5f)=='X' && (tmp[8]&0x5f)=='I' && (tmp[9]&0x5f)=='F')
					)
				&& (tmp[10] == 0x00)
				){ (void)fseek(fp,offs,SEEK_SET); break; }
			else { (void)fseek(fp,offs+1,SEEK_SET); }
		}
	}
	if(feof(fp)) return ERR_JPG_DATA;

	zcd=1;
	for(i=0;i<33;i++) {sft[i]=zcd;msk[i]=zcd-1;zcd<<=1;}
	for(i=0;i<4;i++) {numdc[0]=0;numac[0]=0;}
	j= -128*179;for(i=0;i<256;i++) {mul179[i]=(64+j)>>7;j +=179;}
	j= -128* 44;for(i=0;i<256;i++) {muln44[i]=64-j;j +=44;}
	j= -128* 91;for(i=0;i<256;i++) {mul91[i]=j;j +=91;}
	j= -128*227;for(i=0;i<256;i++) {mul227[i]=(64+j)>>7;j +=227;}
	for(i=0;i<768;i++) {
		j=i-256;
		if(j>255) j=255; else if(j<0) j=0;
		limit[i]=j;
	}
	dri_n=0;
	eof=0;
	progress=0;

/*
*  main loop
*/
loop0:

	if((a = getc(fp)) == EOF) {
		if(app_data.verbose && app_data.debug) fprintf(stderr,"EOF\n");
		goto allend;
	}
	if(a != 0xff) goto loop0;

	a = getc(fp); if(feof(fp)) goto allend;
	if(app_data.verbose && app_data.debug) fprintf(stderr,"FF+%02x:",a);

	/* parse JPEG code */
	switch(a) {

	case 0xd8: /* SOI (Start Of Image) */
		if(app_data.verbose && app_data.debug) fprintf(stderr,"SOI\n");
		goto loop0;

	case 0xdb: /* DQT (Define Quantization Table) */
		n = getc(fp); n = (n << 8) + getc(fp); if(feof(fp)) goto allend;
		while(n != 2) {
			a = getc(fp); if(feof(fp)) goto allend;
			pq = a & 0xf0;
			t  = a & 0x0f;
			if(app_data.verbose && app_data.debug) fprintf(stderr,"define Q table(%d)\n",t);
			for(i=0;i<64;i++) {
				d=getc(fp);
				if(pq) d=(d<<8) | getc(fp);
				if(app_data.verbose && app_data.debug) fprintf(stderr,"%d,",d);
				qt[t][zig[i]] = d;
			}
			if(app_data.verbose && app_data.debug) fprintf(stderr,"\n");
			n = n - 65;
			if(pq) n -= 64;
		}
		goto loop0;

	case 0xc2: /* SOF (Start Of Frame) progressive DCT */
		progress = 1;
	case 0xc1: /* SOF (Start Of Frame) extended function sequential DCT */
	case 0xc0: /* SOF (Start Of Frame) basical function DCT */

		b = a;
		if(gim.subImageList->image == (byte *)NULL){
			subImageList = gim.subImageList;
			subImageList->next = (SUBGIMAGE *)NULL;
			subImageList->isTop = True;
		}
		else {
			fprintf(stderr,"xslideshow: Error: not support multi frame.\n");
			return ERR_NO_ERR;
		}

		n = getc(fp); n = (n << 8) + getc(fp);
		a = getc(fp); if(feof(fp)) return ERR_JPG_DATA;
		if(a != 8) {
			fprintf(stderr,"xslideshow: Error: not support dct <> 8 bit.\n");
			return ERR_JPG_DATA;
		}

		ymax = getc(fp); ymax = (ymax << 8) + getc(fp);
		xmax = getc(fp); xmax = (xmax << 8) + getc(fp);
		cmax = getc(fp); if(feof(fp)) return ERR_JPG_DATA;
		if(app_data.verbose && app_data.debug) fprintf(stderr,"ymax,xmax,cmax=%d,%d,%d\n",ymax,xmax,cmax);

		subImageList->width	= ((xmax+3)/4) * 4;
		subImageList->height = ymax;
		subImageList->bits_per_pixel = 24;
		if((subImageList->image = (byte *)XtCalloc(subImageList->width * 3 * ymax, sizeof(byte))) == NULL){
			fprintf(stderr,"xslideshow: jpg2gimage() memory allocation error\n");
			goodbyekiss();
		}

		xmax154 = (xmax+15)>>4;
		wd4 = ((xmax+15) & (-16)) >> 2;
		width = wd4*4;
		address = wd4*48;
		if(buffer != (dword *)NULL){
			XtFree((char *)buffer);
		}
		if((buffer = (dword *)XtCalloc(address,4)) == NULL) {
			fprintf(stderr,"xslideshow: jpg2gimage() memory allocation error\n");
			goodbyekiss();
		}

		for(i = 0;i < cmax;i++) {
			a = getc(fp); if(feof(fp)) return ERR_JPG_DATA;
			col[i] = a;
			cmp[a][0] = getc(fp);
			cmp[a][1] = getc(fp);
			ex_file[i]=0;
			if(app_data.verbose && app_data.debug)
				fprintf(stderr,"(%x)%02x:%02x:",a,cmp[a][0],cmp[a][1]);
		}
		if(app_data.verbose && app_data.debug) fprintf(stderr,"\n");
		goto loop0;

	case 0xdd: /* DRI (Define Restart Interval) */
		n = getc(fp); n = (n << 8) + getc(fp);
		dri_n = getc(fp); dri_n = (dri_n << 8) + getc(fp);
		if(app_data.verbose && app_data.debug) fprintf(stderr,"dri.n=%d\n",dri_n);
		goto loop0;

	case 0xc4: /* DHT (Define Huffman Table) */
		n = getc(fp); n = (n << 8) + getc(fp);
		n = n - 2;
dht2:
		t = getc(fp); if(feof(fp)) goto allend;
		n--;
		if(app_data.verbose && app_data.debug) fprintf(stderr,"huffman(%x)\n",t);
		if(t > 15) goto dht_ac;
dht_dc:
		for(i = 0;i<16;i++) { leng[i] = getc(fp); } if(feof(fp)) goto allend;
		n = n - 16;
		p = 0;zcd = 0;l = 0;
		for(i = 0;i<16;i++) {
			k = leng[i];
			for(j = 0;j < k;j++) {
				a = getc(fp);
				n--;
				hufdc[t][0][p] = i + 1;
				hufdc[t][1][p] = a;
				zcd = zcd << (i - l);
				zhdc[t][p] = zcd++;
				p++;l = i;
			}
			if(feof(fp)) goto allend;
		}
		numdc[t] = p;
		if(n != 0) goto dht2;
		goto loop0;
dht_ac:
		n = n - 16;
		t = t - 16;
		for(i = 0;i<16;i++) { leng[i] = getc(fp); } if(feof(fp)) goto allend;
		p = 0;zcd = 0;l = 0;
		for(i = 0;i<16;i++) {
			k = leng[i];
			for(j = 0;j < k;j++) {
				a = getc(fp);
				n--;
				hufac[t][0][p] = i + 1;
				hufac[t][1][p] = a;
				zcd = zcd << (i - l);
				zhac[t][p] = zcd++;
				p++;l = i;
			}
			if(feof(fp)) goto allend;
		}
		numac[t] = p;
		if(n != 0) goto dht2;
		goto loop0;

	case 0xda: /* SOS (Start Of Scan) */

		if(progress) progress++;
		n = getc(fp); n = (n << 8) + getc(fp);
		n = n - 2;
		cl_num = getc(fp); if(feof(fp)) goto allend;
		if(app_data.verbose && app_data.debug) fprintf(stderr,"cl_num=%d,",cl_num);

		for(i=0;i<256;i++) prog_cl[i]=0;
		for(i = 0;i < cl_num;i++) {
			k = getc(fp); if(feof(fp)) goto allend;
			prog_cl[k]=1;
			cmp[k][2] = getc(fp);
			if(app_data.verbose && app_data.debug) fprintf(stderr,"(%d)%02x:",k,cmp[k][2]);
		}

		if(app_data.verbose && app_data.debug) fprintf(stderr,",sos=");
		s_start=getc(fp);
		s_end  =getc(fp);
		d      =getc(fp); if(feof(fp)) goto allend;
		if(b == 0xc0) {
			s_start= 0x00;
			s_end  = 0x3f;
			d      = 0x00;
		}

		bit_h = d>>4;
		bit_l = d & 0xf;
		if(progress == 0) {
			if((cl_num != cmax)
				||(s_start != 0)
				||(s_end   != 0x3f)
				||(d != 0)) progress = 2;
		}

		if(app_data.verbose && app_data.debug) {
			fprintf(stderr,"%02x,%02x,%02x ",s_start,s_end,d);
			if(progress) {
				fprintf(stderr,"<%d,%d,%d>",
					prog_cl[col[0]],
					prog_cl[col[1]],
					prog_cl[col[2]]);
			}
			fprintf(stderr,"\n");
		}

/*-----------------------------
		start image data
  -----------------------------*/
		if(app_data.verbose && app_data.debug) fprintf(stderr,"start image data(%d) ",progress);
		for(comp = 0;comp<cmax;comp++) {
			xnm[comp] = cmp[col[comp]][0] >> 4;
			ynm[comp] = cmp[col[comp]][0] & 0xf;
			if(prog_cl[col[comp]]) {
				tdc[comp] = cmp[col[comp]][2] >> 4;
				tac[comp] = cmp[col[comp]][2] & 0xf;
				qtn[comp] = cmp[col[comp]][1];
				ndc[comp] = numdc[tdc[comp]];
				nac[comp] = numac[tac[comp]];
			}
		}

		if(progress) {
			for(comp=0;comp<cmax;comp++) {
				if(prog_cl[col[comp]] == 0) continue;
				if(ex_file[comp] == 0) {
					address=(long)((xmax+15)&(-16))*(long)((ymax+15)&(-16));
					if(xnm[0] != xnm[comp]) address >>= 1;
					if(ynm[0] != ynm[comp]) address >>= 1;
					if(fin[comp] != (short *)NULL)
						XtFree((char *)fin[i]);
					if((fin[comp] = (short *)XtCalloc(address,2)) == NULL) {
						fprintf(stderr,"xslideshow: jpg2gimage() memory allocation error\n");
						goodbyekiss();
					}
					ex_file[comp] = 1;
				}
			}
		}

/* set table */
		for(comp = 0;comp<cmax;comp++) {
			if(prog_cl[col[comp]]) {
				t = cmp[col[comp]][2] & 0xf;
				for(p=0;p<4096;p++) table[t][p]=0;
				for(p=0;p<(int)nac[comp];p++) {
					l = hufac[t][0][p];
					a = hufac[t][1][p];
					zcd = zhac[t][p];
					if(l <= 12) {
						n = sft[12 - l];
						a = a | (l << 8);
						for(i = 0;i<n;i++) {
							table[t][(zcd << (12 - l)) | i] = a;
						}
					}
				}
			}
		}

/* end of set table */
		for(comp = 0;comp<cmax;comp++) {
			hufac13[comp] = 0;
			if(prog_cl[col[comp]]) {
				for(i=0;i<(int)nac[comp];i++) {
					if(hufac[tac[comp]][0][i] >= 13) {
						hufac13[comp] = i;
						break;
					}
				}
			}
		}
		err = get_image();

		if(app_data.verbose && app_data.debug) fprintf(stderr,"/\n");
		if(eof) goto allend;
		goto loop0;

	case 0xd9: /* EOI (End Of Image) */
		if(app_data.verbose && app_data.debug) fprintf(stderr,"end\n");
		goto allend;

	case 0xe0: /* APP0 */
		n = getc(fp); n = (n << 8) + getc(fp); if(feof(fp)) goto allend;
		for(i = 2;i<n;i++) {
			a = getc(fp);
			if(i < 16) jfif[i] = a;
		}
		if(feof(fp)) goto allend;
		if(n >= 16) {
/*
	* Length of APP0 block   (2 bytes)
	* Block ID	   (4 bytes - ASCII "JFIF")
	* Zero byte	  (1 byte to terminate the ID string)
	* Version Major, Minor   (2 bytes - 0x01, 0x01)
	* Units	  (1 byte - 0x00 = none, 0x01 = inch, 0x02 = cm)
	* Xdpu	   (2 bytes - dots per unit horizontal)
	* Ydpu	   (2 bytes - dots per unit vertical)
	* Thumbnail X size       (1 byte)
	* Thumbnail Y size       (1 byte)
*/
			do {
				if(jfif[2] != 'J') break;
				if(jfif[3] != 'F') break;
				if(jfif[4] != 'I') break;
				if(jfif[5] != 'F') break;
				if(app_data.verbose && app_data.debug) {
					fprintf(stderr,"JFIF:Ver %d.%02x,",jfif[7],jfif[8]);
					fprintf(stderr,"x=%d dot/",((int)jfif[10] << 8) |jfif[11]);
					if(jfif[9] == 1) fprintf(stderr,"inch");
					if(jfif[9] == 2) fprintf(stderr,"cm");
					fprintf(stderr,",y=%d dot/",((int)jfif[12] << 8) |jfif[13]);
					if(jfif[9] == 1) fprintf(stderr,"inch");
					if(jfif[9] == 2) fprintf(stderr,"cm");
					fprintf(stderr,"\n");
				}
				jfif[0] = 1;
			} while(0);
		}
		goto loop0;

	default:
		n = getc(fp); n = (n << 8) + getc(fp); if(feof(fp)) goto allend;
		for(i = 2;i<n;i++) {
			a = getc(fp); if(feof(fp)) goto allend;
			if(app_data.verbose && app_data.debug) {
				if(a < 32) a = 32;
				if(a >= 127) a = 32;
				fprintf(stderr,"%c",a);
			}
		}
		if(app_data.verbose && app_data.debug) fprintf(stderr,"\n");
		goto loop0;
	}

allend:
	if(progress) out_image();
	if(app_data.verbose && app_data.debug) fprintf(stderr,"end\n");
	return ERR_NO_ERR;
}

/*
*
*/
static void yuv_rgb()
{
int a,i,j,wd,y8;
int di1,di10,di11,dj1,di2,di20,di21,dj2,j1,j2;
int mulb,mulc,mulbc,di1020;
byte *limita,*limit256;
dword *rgbp,dl,dl0,dl1,dl2,dl3,dl4,dl5;
byte *bufp0,*bufp1,*bufp2,*bf0,*bf1,*bf2;

	limit256 = &limit[0] + 256;
	di1=cmp[col[1]][0] >> 4;
	di2=cmp[col[2]][0] >> 4;
	dj1=cmp[col[1]][0] & 0xf;
	dj2=cmp[col[2]][0] & 0xf;
	di11=di21=1;
	if(xnum0 == di1) di10 = 1; else di10 = 0;
	if(xnum0 == di2) di20 = 1; else di20 = 0;
	if(ynum0 == dj1) dj1 = 2; else dj1 = 1;
	if(ynum0 == dj2) dj2 = 2; else dj2 = 1;
	di1020 = di10 | di20;
	y8 = ynum0*8;
    wd = subImageList->width*3;
	bf0 = (byte *)&buffer[0];
	bf1 = (byte *)&buffer[wd4 << 4];
	bf2 = (byte *)&buffer[wd4 << 5];
	if(cmax == 1) {
		for(j=0;j<y8;j++) {
			if(ycount==ymax) break;
			rgbp  = (dword *)&subImageList->image[ycount*wd];
			bufp0 = bf0;bf0 += width;
			for(i=0;i<xmax;i += 4) {

				if(Endean == IS_LITTLE_ENDEAN) {
					dl = *bufp0;
					dl0 = (dl) | (dl<<8) | (dl<<16);
					dl= *(bufp0+1);
					*rgbp=dl0 | (dl<<24);
					dl0 = (dl) | (dl<<8);
					dl= *(bufp0+2);
					*(rgbp+1) = dl0 | (dl<<16) | (dl<<24);
					dl0 = (dl);
					dl= *(bufp0+3);
					*(rgbp+2) = dl0 | (dl<<8) | (dl<<16) | (dl<<24);
				}
				else {
					dl = *bufp0;
					dl0 = (dl<<24) | (dl<<16) | (dl<<8);
					dl= *(bufp0+1);
					*rgbp=dl0 | dl;
					dl0 = (dl<<24) | (dl<<16);
					dl= *(bufp0+2);
					*(rgbp+1) = dl0 | (dl<<8) | dl;
					dl0 = (dl<<24);
					dl= *(bufp0+3);
					*(rgbp+2) = dl0 | (dl<<16) | (dl<<8) | dl;
				}

				bufp0 += 4;
				rgbp  += 3;
			} /* next i */
			ycount++;
			myevent();
		} /* next j */

	}

	else {

		j1=j2=0;
		for(j=0;j<y8;j++) {
			if(ycount==ymax) break;
			rgbp  = (dword *)&subImageList->image[ycount*wd];
			bufp0 = bf0;bf0 += width;
			bufp1 = bf1 + (j1>>1)*width;
			bufp2 = bf2 + (j2>>1)*width;
			j1 += dj1;j2 += dj2;
			for(i=0;i<xmax;i += 4) {
				a   = *bufp0;
				mulb= *bufp1;
				mulc= *bufp2;
				bufp1 += di10;bufp2 += di20;
				mulbc = muln44[mulb];
				mulb = mul227[mulb];
				mulbc = (mulbc - mul91[mulc])>>7;
				mulc = mul179[mulc];
				limita = limit256 + a;
				a = *(bufp0+1);
				dl2 = limita[mulb ];
				dl1 = limita[mulbc];
				dl0 = limita[mulc ];

				if(di1020) {
					mulb= *bufp1;
					mulc= *bufp2;
					mulbc = muln44[mulb];
					mulb = mul227[mulb];
					mulbc = (mulbc - mul91[mulc])>>7;
					mulc = mul179[mulc];
				}
				bufp1 += di11;bufp2 += di21;
				limita = limit256 + a;
				a = *(bufp0+2);
				dl5 = limita[mulb ];
				dl4 = limita[mulbc];
				dl3 = limita[mulc ];

				mulb= *bufp1;
				mulc= *bufp2;
				bufp1 += di10;bufp2 += di20;
				mulbc = muln44[mulb];
				mulb = mul227[mulb];
				mulbc = (mulbc - mul91[mulc])>>7;
				mulc = mul179[mulc];

				if(Endean == IS_LITTLE_ENDEAN) {
					*rgbp = ((dl0)|(dl1<<8)|(dl2<<16)|(dl3<<24));
					limita = limit256 + a;
					a = *(bufp0+3);
					dl2 = limita[mulb ];
					dl1 = limita[mulbc];
					dl0 = limita[mulc ];

					if(di1020) {
						mulb= *bufp1;
						mulc= *bufp2;
						mulbc = muln44[mulb];
						mulb = mul227[mulb];
						mulbc = (mulbc - mul91[mulc])>>7;
						mulc = mul179[mulc];
					}
					bufp1 += di11;bufp2 += di21;
					*(rgbp+1) = ((dl4)|(dl5<<8)|(dl0<<16)|(dl1<<24));
					limita = limit256 + a;
					dl5 = limita[mulb ];
					dl4 = limita[mulbc];
					dl3 = limita[mulc ];

					bufp0 += 4;
					rgbp  += 3;
					*(rgbp-1) = ((dl2)|(dl3<<8)|(dl4<<16)|(dl5<<24));
				}
				else {
					*rgbp = ((dl0<<24)|(dl1<<16)|(dl2<<8)|(dl3));
					limita = limit256 + a;
					a = *(bufp0+3);
					dl2 = limita[mulb ];
					dl1 = limita[mulbc];
					dl0 = limita[mulc ];

					if(di1020) {
						mulb= *bufp1;
						mulc= *bufp2;
						mulbc = muln44[mulb];
						mulb = mul227[mulb];
						mulbc = (mulbc - mul91[mulc])>>7;
						mulc = mul179[mulc];
					}
					bufp1 += di11;bufp2 += di21;
					*(rgbp+1) = ((dl4<<24)|(dl5<<16)|(dl0<<8)|(dl1));
					limita = limit256 + a;
					dl5 = limita[mulb ];
					dl4 = limita[mulbc];
					dl3 = limita[mulc ];

					bufp0 += 4;
					rgbp  += 3;
					*(rgbp-1) = ((dl2<<24)|(dl3<<16)|(dl4<<8)|(dl5));
				}

			} /* next i */
			ycount++;
			myevent();
		} /* next j */
	}
}

/*
*
*/
static void func_idct()
{
	int ff0,ff1,ff2,ff3,ff4,ff5,ff6,ff7;
	int gg0,gg1,gg2,gg3,gg4,gg5,gg6,gg7,tmp;
	unsigned long j0,j1,j2,j3,j4,j5,j6,j7,*bufp4;
	int i,j;
	int tt[8][8],*ttp;
	short int *mmptr;

	qtp = qtp0;
	mmptr = mm0;
	if(pp == 1) {
		bufp4 = &buffer[((comp<<4)+(y<<3))*wd4 + ((xx2[comp]+(x<<3))>>2)];
		j = (mmptr[0]*qtp0[0]+4)>>3;
		j0 = limit[j + 384];
		j0 = (j0<<24)|(j0<<16)|(j0<<8)|j0;
		for(i=8;i>0;i--) {
			bufp4[0] = j0;
			bufp4[1] = j0;
			bufp4 += wd4;
		}
		return;
	}
	if(progress == 0) if(pp < 10) {
		ttp = &tt[0][0];
		for(i=4;i>0;i--) {
			ff0 = mmptr[ 0]*qtp[ 0] << 4;
			if(mmptr[16]) {
				ff1 = mmptr[16]*qtp[16];
				ff3 = ff1*9;
				ff1 = ff1*21;
				gg0 = ff0+ff1;
				gg1 = ff0-ff1;
				gg2 = ff0+ff3;
				gg3 = ff0-ff3;
			} else gg0=gg1=gg2=gg3=ff0;
			if(mmptr[24]) {
				ff5 = mmptr[24]*qtp[24]*11;
				ff4 = (mmptr[ 8]*qtp[ 8]) << 4;
				gg4 = (ff4+ff5) >> 4;
				gg6 = (ff4-ff5) >> 4;
				gg5 = ff5 >> 4;
				tmp = (gg4-gg5)*4;
				ff4 = gg4*27-tmp;
				ff5 = tmp-gg5*27;
				tmp = (gg6-gg5)*13;
				ff6 = gg6*31-tmp;
				ff7 = tmp-gg5*6;
			} else {
				if(mmptr[8]) {
					gg4 = mmptr[ 8]*qtp[ 8];
					ff4 = gg4*23;
					ff5 = gg4* 4;
					ff6 = gg4*18;
					ff7 = gg4*13;
				} else ff4=ff5=ff6=ff7=0;
			}
			ttp[0] = (gg0+ff4);
			ttp[7] = (gg0-ff4);
			ttp[1] = (gg2+ff6);
			ttp[6] = (gg2-ff6);
			ttp[3] = (gg1+ff5);
			ttp[4] = (gg1-ff5);
			ttp[2] = (gg3+ff7);
			ttp[5] = (gg3-ff7);
			mmptr++;qtp++;
			ttp += 8;
		}
		bufp4 = &buffer[((comp<<4)+(y<<3))*wd4 + ((xx2[comp]+(x<<3))>>2)];
		ttp = &tt[0][0];
		for(i=8;i>0;i--) {
			ff0 = ttp[ 0];
			ff1 = ttp[16]>>4;
			if(ff1) {
				ff3 = ff1*9;
				ff1 = ff1*21;
				gg0 = (ff0+ff1)>>4;
				gg1 = (ff0-ff1)>>4;
				gg2 = (ff0+ff3)>>4;
				gg3 = (ff0-ff3)>>4;
			} else gg0=gg1=gg2=gg3=ff0>>4;
			ff5 = (ttp[24]>>4);
			if(ff5) {
				ff5 = ff5*11;
				ff4 = ttp[8];
				gg4 = (ff4+ff5)>>4;
				gg6 = (ff4-ff5)>>4;
				gg5 = ff5>>4;
				tmp = (gg4-gg5)*4;
				ff4 = (gg4*27-tmp)>>4;
				ff5 = (tmp-gg5*27)>>4;
				tmp = (gg6-gg5)*13;
				ff6 = (gg6*31-tmp)>>4;
				ff7 = (tmp-gg5*6)>>4;
			} else {
				gg4 = ttp[8] >> 4;
				if(gg4) {
					ff4 = (gg4*23)>>4;
					ff5 = (gg4* 4)>>4;
					ff6 = (gg4*18)>>4;
					ff7 = (gg4*13)>>4;
				} else ff4=ff5=ff6=ff7=0;
			}
			j0 = limit[(((gg0+ff4)+3076) >> 3)];
			j1 = limit[(((gg2+ff6)+3076) >> 3)];
			j2 = limit[(((gg3+ff7)+3076) >> 3)];
			j3 = limit[(((gg1+ff5)+3076) >> 3)];
			j4 = limit[(((gg1-ff5)+3076) >> 3)];
			j5 = limit[(((gg3-ff7)+3076) >> 3)];
			j6 = limit[(((gg2-ff6)+3076) >> 3)];
			j7 = limit[(((gg0-ff4)+3076) >> 3)];
			if(Endean == IS_LITTLE_ENDEAN) {
				bufp4[0] = (j0)|(j1<<8)|(j2<<16)|(j3<<24);
				bufp4[1] = (j4)|(j5<<8)|(j6<<16)|(j7<<24);
			}
			else {
				bufp4[0] = (j0<<24)|(j1<<16)|(j2<<8)|(j3);
				bufp4[1] = (j4<<24)|(j5<<16)|(j6<<8)|(j7);
			}
			bufp4 += wd4;
			ttp++;
		}
		return;
	}
	ttp = &tt[0][0];
	for(i=8;i>0;i--) {
		if((mmptr[32]|mmptr[40]|mmptr[48]|mmptr[56]) == 0) {
			ff0 = mmptr[ 0]*qtp[ 0] << 4;
			if(mmptr[16]) {
				ff1 = mmptr[16]*qtp[16];
				ff3 = ff1*9;
				ff1 = ff1*21;
				gg0 = ff0+ff1;
				gg1 = ff0-ff1;
				gg2 = ff0+ff3;
				gg3 = ff0-ff3;
			} else gg0=gg1=gg2=gg3=ff0;
			if(mmptr[24]) {
				ff5 = mmptr[24]*qtp[24]*11;
				ff4 = (mmptr[ 8]*qtp[ 8]) << 4;
				gg4 = (ff4+ff5) >> 4;
				gg6 = (ff4-ff5) >> 4;
				gg5 = ff5 >> 4;
				tmp = (gg4-gg5)*4;
				ff4 = gg4*27-tmp;
				ff5 = tmp-gg5*27;
				tmp = (gg6-gg5)*13;
				ff6 = gg6*31-tmp;
				ff7 = tmp-gg5*6;
			} else {
				if(mmptr[8]) {
					gg4 = mmptr[ 8]*qtp[ 8];
					ff4 = gg4*23;
					ff5 = gg4* 4;
					ff6 = gg4*18;
					ff7 = gg4*13;
				} else ff4=ff5=ff6=ff7=0;
			}
		} else {
			gg0 = mmptr[ 0]*qtp[ 0];
			gg1 = mmptr[16]*qtp[16];
			gg2 = mmptr[32]*qtp[32];
			gg3 = mmptr[48]*qtp[48];
			ff0 = (gg0+gg2) << 4;
			ff2 = (gg0-gg2) << 4;
			tmp = (gg1-gg3)*9;  /* 2217 */
			ff1 = gg1*30-tmp;   /* 7569 */
			ff3 = tmp-gg3*12;   /* 3135 */
			gg0 = ff0+ff1;
			gg1 = ff0-ff1;
			gg2 = ff2+ff3;
			gg3 = ff2-ff3;
			gg4 = mmptr[ 8]*qtp[ 8];
			gg5 = mmptr[24]*qtp[24];
			gg6 = mmptr[40]*qtp[40];
			gg7 = mmptr[56]*qtp[56];
			ff5 = (gg5+gg6)*11; /* 2896 */
			ff6 = (gg5-gg6)*11;
			ff4 = gg4 << 4;
			ff7 = gg7 << 4;
			gg4 = (ff4+ff5) >> 4;
			gg6 = (ff4-ff5) >> 4;
			gg5 = (ff6+ff7) >> 4;
			gg7 = (ff6-ff7) >> 4;
			tmp = (gg4-gg5)<<2; /* 1130 */
			ff4 = gg4*27-tmp;   /* 6811 */
			ff5 = tmp-gg5*27;   /* 4551 */
			tmp = (gg6-gg7)*13; /* 3218 */
			ff6 = gg6*31-tmp;   /* 8034 */
			ff7 = tmp-gg7*6;    /* 1598 */
		}
		ttp[0] = (gg0+ff4);
		ttp[7] = (gg0-ff4);
		ttp[1] = (gg2+ff6);
		ttp[6] = (gg2-ff6);
		ttp[3] = (gg1+ff5);
		ttp[4] = (gg1-ff5);
		ttp[2] = (gg3+ff7);
		ttp[5] = (gg3-ff7);
		mmptr++;qtp++;
		ttp += 8;
	}
	bufp4 = &buffer[((comp<<4)+(y<<3))*wd4 + ((xx2[comp]+(x<<3))>>2)];
	ttp = &tt[0][0];
	for(i=8;i>0;i--) {
		if((ttp[32]|ttp[40]|ttp[48]|ttp[56]) == 0) {
			ff0 = ttp[ 0];
			ff1 = (ttp[16]>>4);
			if(ff1) {
				ff3 = ff1*9;
				ff1 = ff1*21;
				gg0 = (ff0+ff1)>>4;
				gg1 = (ff0-ff1)>>4;
				gg2 = (ff0+ff3)>>4;
				gg3 = (ff0-ff3)>>4;
			} else gg0=gg1=gg2=gg3=ff0>>4;
			ff5 = (ttp[24]>>4);
			if(ff5) {
				ff5 = ff5*11;
				ff4 = ttp[8];
				gg4 = (ff4+ff5)>>4;
				gg6 = (ff4-ff5)>>4;
				gg5 = (ff5)>>4;
				tmp = (gg4-gg5)*4;      /* 1130 */
				ff4 = (gg4*27-tmp)>>4;  /* 6811 */
				ff5 = (tmp-gg5*27)>>4;  /* 4551 */
				tmp = (gg6-gg5)*13;     /* 3218 */
				ff6 = (gg6*31-tmp)>>4;  /* 8034 */
				ff7 = (tmp-gg5*6)>>4;   /* 1598 */
			} else {
				gg4 = ttp[8]>>4;
				if(gg4) {
					ff4 = (gg4*23)>>4;  /* 6811 */
					ff5 =  gg4>>2;      /* 4551 */
					ff6 = (gg4*18)>>4;  /* 8034 */
					ff7 = (gg4*13)>>4;  /* 1598 */
				} else ff4=ff5=ff6=ff7=0;
			}
		} else {
			ff0 = ttp[ 0]+ttp[32];
			ff2 = ttp[ 0]-ttp[32];
			tmp = ((ttp[16]-ttp[48])>>4)*9; /* 2217 */
			ff1 = (ttp[16]>>4)*30-tmp;      /* 7569 */
			ff3 = tmp-(ttp[48]>>4)*12;      /*3135 */
			gg0 = (ff0+ff1)>>4;
			gg1 = (ff0-ff1)>>4;
			gg2 = (ff2+ff3)>>4;
			gg3 = (ff2-ff3)>>4;
			ff5 = ((ttp[24]+ttp[40])>>4)*11; /* 2896 */
			ff6 = ((ttp[24]-ttp[40])>>4)*11;
			ff4 = ttp[8];
			ff7 = ttp[56];
			gg4 = (ff4+ff5)>>4;
			gg6 = (ff4-ff5)>>4;
			gg5 = (ff6+ff7)>>4;
			gg7 = (ff6-ff7)>>4;
			tmp = (gg4-gg5)*4;      /* 1130 */
			ff4 = (gg4*27-tmp)>>4;  /* 6811 */
			ff5 = (tmp-gg5*27)>>4;  /* 4551 */
			tmp = (gg6-gg7)*13;     /* 3218 */
			ff6 = (gg6*31-tmp)>>4;  /* 8034 */
			ff7 = (tmp-gg7*6)>>4;   /* 1598 */
		}
		j0 = limit[(((gg0+ff4)+3076) >> 3)];
		j1 = limit[(((gg2+ff6)+3076) >> 3)];
		j2 = limit[(((gg3+ff7)+3076) >> 3)];
		j3 = limit[(((gg1+ff5)+3076) >> 3)];
		j4 = limit[(((gg1-ff5)+3076) >> 3)];
		j5 = limit[(((gg3-ff7)+3076) >> 3)];
		j6 = limit[(((gg2-ff6)+3076) >> 3)];
		j7 = limit[(((gg0-ff4)+3076) >> 3)];
		if(Endean == IS_LITTLE_ENDEAN) {
			bufp4[0] = (j0)|(j1<<8)|(j2<<16)|(j3<<24);
			bufp4[1] = (j4)|(j5<<8)|(j6<<16)|(j7<<24);
		}
		else {
			bufp4[0] = (j0<<24)|(j1<<16)|(j2<<8)|(j3);
			bufp4[1] = (j4<<24)|(j5<<16)|(j6<<8)|(j7);
		}
		bufp4 += wd4;
		ttp++;
	}
}
/*
* get huffman code for non-progressive mode
*/
static ErrStatus get_huff()
{
int i,j,cd,ln,d;
short *mmptr;

/* ----------------
	get dc code
   ----------------*/
	pp = 1;
	if(eof) return ERR_NO_ERR;
	mmptr = mm0;
	for(i=8;i>0;i--) {
		*(mmptr  ) = 0;*(mmptr+1) = 0;
		*(mmptr+2) = 0;*(mmptr+3) = 0;
		*(mmptr+4) = 0;*(mmptr+5) = 0;
		*(mmptr+6) = 0;*(mmptr+7) = 0;
		mmptr += 8;
	}
	mmptr = mm0;
get_dc:
	for(i = 0;i<num_dc;i++) {
		ln = hufdct[i];
		while(bit < ln) {
			if((j = getc(fp)) == 0xff) getc(fp);
			if(feof(fp)) return ERR_NO_ERR;
			lbyte = (lbyte << 8) | j; bit += 8;
		}
		if((lbyte >> (bit - ln)) == zhdct[i]) {
			cd = hufdct[i+16];
			goto find_dc;
		}
	}
	if(app_data.verbose)
		fprintf(stderr,"huffman dc code error\n");
	(void)fseek(fp,0,SEEK_END); getc(fp);
	eof=1; return ERR_NO_ERR;
find_dc:
	bit  -= ln;
	lbyte &= msk[bit];
	if(cd == 0) goto end_dc;
	ln = cd;
	bit -= ln;
	while(bit < 0) {
		if((j = getc(fp)) == 0xff) getc(fp);
		if(feof(fp)) return ERR_NO_ERR;
		lbyte = (lbyte << 8) | j; bit += 8;
	}
	d = (lbyte >> bit);
	lbyte &= msk[bit];
	if((d>>(ln-1)) == 0) d = d - msk[ln];
	dcsum[comp] += d;
end_dc:
	mmptr[0] = dcsum[comp];
/* ----------------
	get ac code
   ----------------*/
	while(pp < 64) {
/* search table */
search_t:
		if(bit >= 12)   i = tablet[lbyte >> (bit - 12)];
		else	    i = tablet[lbyte << (12 - bit)];
		ln = i >> 8;
		if(bit < ln) {
			do {
				if((j = getc(fp)) == 0xff) getc(fp);
				if(feof(fp)) return ERR_NO_ERR;
				lbyte = (lbyte << 8) | j; bit += 8;
			} while(bit < ln);
			goto search_t;
		}
		if(ln != 0) {
			cd = i & 0xff;
			goto find_ac;
		}
/*search table end*/
		for(i = hufac13[comp];i<num_ac;i++) {
			ln = hufact[i];
			while(bit < ln) {
				if((j = getc(fp)) == 0xff) getc(fp);
				if(feof(fp)) return ERR_NO_ERR;
				lbyte = (lbyte << 8) | j; bit += 8;
			}
			if((lbyte >> (bit - ln)) == zhact[i]) {
				cd = hufact[i+256];
				goto find_ac;
			}
		}
		if(app_data.verbose)
			fprintf(stderr,"huffman ac code error\n");
		(void)fseek(fp,0,SEEK_END); getc(fp);
		eof=1; return ERR_NO_ERR;
find_ac:
		bit  -= ln;
		lbyte &= msk[bit];
		if(cd == 0) return ERR_NO_ERR;
		if(cd == 0xf0) {
			pp += 16;
			continue;
		}
		pp += cd >> 4;
		ln = cd & 0x0f;
		if(ln == 0) d = 0; else {
			bit -= ln;
			while(bit < 0) {
				if((j = getc(fp)) == 0xff) getc(fp);
				if(feof(fp)) return ERR_NO_ERR;
				lbyte = (lbyte << 8) | j; bit += 8;
			}
			d = (lbyte >> bit);
			lbyte &= msk[bit];
			if((d>>(ln-1)) == 0) d = d - msk[ln];
		}
		mmptr[zig[pp]] = d;
		pp++;
	}
	return ERR_NO_ERR;
}

/*
* get huffman code for spectral mode
* bit_h == 0
*/
static ErrStatus get_huff_p0()
{
int i,j,rrrr,ssss,rrrrssss,ln,d;
short *mmptr;

/* ----------------
	get dc code
   ----------------*/
	pp = s_start;
	if(eof) return ERR_NO_ERR;
	mmptr = mm0;
	if(s_start != 0) goto end_dc;
	{
		for(i = 0;i<num_dc;i++) {
			ln = hufdct[i];
			while(bit < ln) {
				if((j = getc(fp)) == 0xff) getc(fp);
				if(feof(fp)) return ERR_NO_ERR;
				lbyte = (lbyte << 8) | j; bit += 8;
			}
			if((lbyte >> (bit - ln)) == zhdct[i]) {
				ssss = hufdct[i+16];
				goto find_dc;
			}
		}
		if(app_data.verbose)
			fprintf(stderr,"huffman dc code error\n");
		(void)fseek(fp,0,SEEK_END); getc(fp);
		eof=1; return ERR_NO_ERR;
find_dc:
		bit  -= ln;lbyte &= msk[bit];
		if(ssss == 0) {
			d = dcsum[comp];
		} else {
			bit -= ssss;
			while(bit < 0) {
				if((j = getc(fp)) == 0xff) getc(fp);
				if(feof(fp)) return ERR_NO_ERR;
				lbyte = (lbyte << 8) | j; bit += 8;
			}
			d = (lbyte >> bit);lbyte &= msk[bit];
			if((d >> (ssss-1)) == 0) d = d - msk[ssss];
			dcsum[comp] += d;
			d = dcsum[comp];
		}
		mmptr[0] = d << bit_l;
	}
	pp++;
end_dc:
/* ----------------
	get ac code
   ----------------*/
	while(pp <= s_end) {
		if(eobrun) {
			break;
		}
/* search table */
search_t:
		if(bit >= 12)   i = tablet[lbyte >> (bit - 12)];
		else	    i = tablet[lbyte << (12 - bit)];
		ln = i >> 8;
		if(bit < ln) {
			do {
				if((j = getc(fp)) == 0xff) getc(fp);
				if(feof(fp)) return ERR_NO_ERR;
				lbyte = (lbyte << 8) | j; bit += 8;
			} while(bit < ln);
			goto search_t;
		}
		if(ln != 0) {
			rrrrssss = i & 0xff;
			goto find_ac;
		}
/*search table end*/
		for(i = hufac13[comp];i<num_ac;i++) {
			ln = hufact[i];
			while(bit < ln) {
				if((j = getc(fp)) == 0xff) getc(fp);
				if(feof(fp)) return ERR_NO_ERR;
				lbyte = (lbyte << 8) | j; bit += 8;
			}
			if((lbyte >> (bit - ln)) == zhact[i]) {
				rrrrssss = hufact[i+256];
				goto find_ac;
			}
		}
		if(app_data.verbose)
			fprintf(stderr,"huffman ac code error\n");
		(void)fseek(fp,0,SEEK_END); getc(fp);
		eof=1; return ERR_NO_ERR;
find_ac:
		bit -= ln;lbyte &= msk[bit];
		if(rrrrssss == 0xf0) {
/* ZRL */
			pp += 16;
			continue;
		}
		rrrr = rrrrssss >> 4;
		ssss = rrrrssss & 0xf;
		if(ssss == 0) {
/* eobrun */
			eobrun = 1 << rrrr;
			if(rrrr) {
				bit -= rrrr;
				while(bit < 0) {
					if((j = getc(fp)) == 0xff) getc(fp);
					if(feof(fp)) return ERR_NO_ERR;
					lbyte = (lbyte << 8) | j; bit += 8;
				}
				d = (lbyte >> bit);
				lbyte &= msk[bit];
				eobrun += d;
			}
			break;
		}
/* get AC coefficients */
		bit -= ssss;
		while(bit < 0) {
			if((j = getc(fp)) == 0xff) getc(fp);
			if(feof(fp)) return ERR_NO_ERR;
			lbyte = (lbyte << 8) | j; bit += 8;
		}
		d = (lbyte >> bit);
		lbyte &= msk[bit];
		if((d >> (ssss - 1)) == 0) d = d - msk[ssss];
/* skip RRRR */
		pp += rrrr;
		mmptr[zig[pp]] = d << bit_l;
		pp++;
	}
	if(eobrun) eobrun--;
	return ERR_NO_ERR;
}

/*
* get huffman code for progressive mode
* bit_h != 0
*/
static ErrStatus get_huff_p1()
{
int i,j,rrrr,ssss,rrrrssss,ln,d;
short *mmptr,*zz;

/* ----------------
	get dc code
   ----------------*/
	pp = s_start;
	if(eof) return ERR_NO_ERR;
	if(s_start != 0) goto end_dc;
	{
		bit--;
		if(bit < 0) {
			if((j = getc(fp)) == 0xff) getc(fp);
			if(feof(fp)) return ERR_NO_ERR;
			lbyte = (lbyte << 8) | j; bit += 8;
		}
		d = (lbyte >> bit);lbyte &= msk[bit];
		if(d) mm0[0] += d << bit_l;
	}
	if(s_end == 0) return ERR_NO_ERR;
	pp++;
end_dc:
	mmptr = mm0;
/* ----------------
	get ac code
   ----------------*/
	while(pp <= s_end) {
		if(eobrun) {
			do {
				zz = &mmptr[zig[pp]];
				if(*zz) {
					bit--;
					if(bit < 0) {
						if((j = getc(fp)) == 0xff) getc(fp);
						if(feof(fp)) return ERR_NO_ERR;
						lbyte = (lbyte << 8) | j; bit += 8;
					}
					d = (lbyte >> bit) & 0x1;
					if(d) {
						d <<= bit_l;
						if(*zz < 0) *zz -= d; else *zz += d;
					}
				}
				pp++;
			} while(pp <= s_end);
			lbyte &= msk[bit];
			break;
		}
/* search table */
search_t:
		if(bit >= 12)   i = tablet[lbyte >> (bit - 12)];
		else	    i = tablet[lbyte << (12 - bit)];
		ln = i >> 8;
		if(bit < ln) {
			do {
				if((j = getc(fp)) == 0xff) getc(fp);
				if(feof(fp)) return ERR_NO_ERR;
				lbyte = (lbyte << 8) | j; bit += 8;
			} while(bit < ln);
			goto search_t;
		}
		if(ln != 0) {
			rrrrssss = i & 0xff;
			goto find_ac;
		}
/*search table end*/
		for(i = hufac13[comp];i<num_ac;i++) {
			ln = hufact[i];
			while(bit < ln) {
				if((j = getc(fp)) == 0xff) getc(fp);
				if(feof(fp)) return ERR_NO_ERR;
				lbyte = (lbyte << 8) | j; bit += 8;
			}
			if((lbyte >> (bit - ln)) == zhact[i]) {
				rrrrssss = hufact[i+256];
				goto find_ac;
			}
		}
		if(app_data.verbose)
			fprintf(stderr,"huffman ac code error\n");
		(void)fseek(fp,0,SEEK_END); getc(fp);
		eof=1; return ERR_NO_ERR;
find_ac:
		bit -= ln;lbyte &= msk[bit];
		if(rrrrssss == 0xf0) {
/* ZRL */
			rrrr=16;
			while(1) {
				zz = &mmptr[zig[pp]];
				if(*zz == 0) {
					pp++;
					rrrr--;
					if(rrrr == 0) break;
				} else {
					bit--;
					while(bit < 0) {
						if((j = getc(fp)) == 0xff) getc(fp);
						if(feof(fp)) return ERR_NO_ERR;
						lbyte = (lbyte << 8) | j; bit += 8;
					}
					j = (lbyte >> bit) & 0x1;
					if(j) {
						j <<= bit_l;
						if(*zz < 0) *zz -= j; else *zz += j;
					}
					pp++;
				}
			}
			lbyte &= msk[bit];
			continue;
		}
		rrrr = rrrrssss >> 4;
		ssss = rrrrssss & 0xf;
		if(ssss == 0) {
/* eobrun */
			eobrun = 1 << rrrr;
			if(rrrr) {
				bit -= rrrr;
				while(bit < 0) {
					if((j = getc(fp)) == 0xff) getc(fp);
					if(feof(fp)) return ERR_NO_ERR;
					lbyte = (lbyte << 8) | j; bit += 8;
				}
				d = (lbyte >> bit);
				lbyte &= msk[bit];
				eobrun += d;
			}
			continue;
		}
/* get AC coefficients */
		bit -= ssss;
		while(bit < 0) {
			if((j = getc(fp)) == 0xff) getc(fp);
			if(feof(fp)) return ERR_NO_ERR;
			lbyte = (lbyte << 8) | j; bit += 8;
		}
		d = (lbyte >> bit);
		lbyte &= msk[bit];
		if((d >> (ssss - 1)) == 0) d = d - msk[ssss];
/* skip RRRR */
		while(1) {
			zz = &mmptr[zig[pp]];
			if(*zz == 0) {
				if(rrrr == 0) break;
				rrrr--;
			} else {
				bit--;
				while(bit < 0) {
					if((j = getc(fp)) == 0xff) getc(fp);
					if(feof(fp)) return ERR_NO_ERR;
					lbyte = (lbyte << 8) | j; bit += 8;
				}
				j = (lbyte >> bit) & 0x1;
				if(j) {
					j <<= bit_l;
					if(*zz < 0) *zz -= j; else *zz += j;
				}
			}
			pp++;
		}
		lbyte &= msk[bit];
		mmptr[zig[pp]] = d << bit_l;
		pp++;
	}
	if(eobrun) eobrun--;
	return ERR_NO_ERR;
}

/*
*
*/
static ErrStatus get_image()
{
ErrStatus err;
int i;

	xx     = 0;
	yy     = 0;
	mcu    = 0;
	eobrun = 0;
	ycount = 0;
	lbyte  = 0;
	bit    = 0;
	mm0 = &mm[0][0];
	for(i = 0;i<4;i++) dcsum[i] = 0;
	xx2[0]=xx2[1]=xx2[2]=xx2[3]=0;
	while(1) {
		for(comp = 0;comp < cmax;comp++) {
			if(prog_cl[col[comp]] == 0) continue;
			xnum = xnm[comp];
			ynum = ynm[comp];
			xnum0 = xnm[0];
			ynum0 = ynm[0];
			if(cl_num == 1) if(comp == 0) {
				xnum=ynum=1;xnum0=ynum0=1;
			}
			if((s_end != 0) || (bit_h == 0)) {
				num_dc = ndc[comp];
				num_ac = nac[comp];
				hufdct = &hufdc[tdc[comp]][0][0];
				zhdct  = &zhdc[tdc[comp]][0];
				tablet = &table[tac[comp]][0];
				hufact = &hufac[tac[comp]][0][0];
				zhact  = &zhac[tac[comp]][0];
				qtp0 = &qt[cmp[col[comp]][1]][0];
			}
			if(progress == 0) {
				for(y = 0;y<ynum;y++) {
					for(x = 0;x<xnum;x++) {
						err = get_huff();
						if(feof(fp)) return ERR_NO_ERR;
						func_idct();
					} /* next x */
				} /* next y */
			} else {
				for(y = 0;y<ynum;y++) {
					for(x = 0;x<xnum;x++) {
						set_add();
						mm0 = fin[comp]+(address<<6);
						if(bit_h == 0) err = get_huff_p0(); else err = get_huff_p1();
						if(feof(fp)) return ERR_NO_ERR;
					} /* next x */
				} /* next y */
			}
			xx2[comp] += xnum << 3;
		} /* next comp */
		xx += xnum0;
		if((xx << 3) < xmax) goto mcu_count;
		else {
			if(progress == 0) yuv_rgb();
			xx = 0;
			xx2[0]=xx2[1]=xx2[2]=xx2[3]=0;
			yy += ynum0;
			if(eof == 0) if((yy << 3) < ymax) goto mcu_count;
		}
		return ERR_NO_ERR;
mcu_count:
		mcu++;
		if(dri_n) {
			if(dri_n == mcu) {
				lbyte = 0;bit = 0;
wait_ffd0:
				i = getc(fp); if(feof(fp)) {eof=1;continue;}
				if(i != 255) goto wait_ffd0;
				i = getc(fp); if(feof(fp)) {eof=1;continue;}
				i = (i & 0xf8);
				if(i != 0xd0) goto wait_ffd0;
				mcu = 0;
				for(i = 0;i<4;i++) dcsum[i] = 0;
			}
		}
	}
}

/*
*
*/
static void out_image()
{
int i,d;

	xx     = 0;
	yy     = 0;
	ycount = 0;
	xx2[0]=xx2[1]=xx2[2]=xx2[3]=0;
	while(1) {
		for(comp = 0;comp < cmax;comp++) {
			xnum = xnm[comp];
			ynum = ynm[comp];
			xnum0 = xnm[0];
			ynum0 = ynm[0];
			qtp0 = &qt[cmp[col[comp]][1]][0];

			for(y = 0;y<ynum;y++) {
				for(x = 0;x<xnum;x++) {
					set_add();
					mm0 = fin[comp]+(address<<6);
					pp=1;
					for(i=0;i<64;) {
						d = mm0[zig[i++]];
						if(d) pp=i;
					}
					func_idct();
				} /* next x */
			} /* next y */
			xx2[comp] += xnum << 3;

		} /* next comp */

		xx += xnum0;
		if((xx << 3) < xmax) continue;
		else {
			yuv_rgb();
			xx = 0;
			xx2[0]=xx2[1]=xx2[2]=xx2[3]=0;
			yy += ynum0;
			if((yy << 3) < ymax) continue;
		}
		return;
	}
}

/*
*
*/
static void set_add()
{
	if(ynum0 == ynum) {
		if(xnum0 == xnum) {
			address=(yy+y )*(xmax154<<1) + (xx+x );
		} else {
			address=(yy+y )*(xmax154   ) + (xx>>1);
		}
	} else {
		if(xnum0 == xnum) {
			address=(yy>>1)*(xmax154<<1) + (xx+x );
		} else {
			address=(yy>>1)*(xmax154   ) + (xx>>1);
		}
	}
}

#if defined(__STDC__) || defined(__cplusplus)
ErrStatus jpg2gimage(char *fname)
#else
ErrStatus jpg2gimage(fname)
char *fname;
#endif
{
ErrStatus status;
int i;

	xmax = ymax = 0;
	gim.subImageList->width = xmax;
	gim.subImageList->height = ymax;
	gim.subImageList->isTop = True;
	gim.subImageList->image = (byte *)NULL;
	gim.subImageList->next = (SUBGIMAGE *)NULL;

	buffer = (dword *)NULL;
	for(i=0;i<3;i++)
		fin[i] = (short *)NULL;

	if((fp = fopen(fname,"r")) == NULL) {
		if(app_data.verbose)
			fprintf(stderr,"xslideshow: jpg2gimage() Error: can't open %s\n",fname);
		return ERR_FILE_RW;
	}


	if(app_data.verbose)
		fprintf(stderr,"xslideshow: jpg2gimage() reading %s\n",fname);

	status=Do_jpg2gimage();

	fclose(fp);

	for(i=0;i<3;i++){
		if(fin[i] != (short *)NULL)
			XtFree((char *)fin[i]);
	}
	if(buffer != (dword *)NULL){
		XtFree((char *)buffer);
	}

	if(app_data.verbose && app_data.debug)
		fprintf(stderr,"xslideshow: jpg2gimage() done.\n");

	if(status != ERR_NO_ERR){
		if(gim.subImageList->image != (byte *)NULL)
			status = ERR_NO_ERR;
	}

	return(status);
}

