- Convert an extglob string to a regex-compatible string. 
- More complete (and correct) support than [minimatch](https://github.com/isaacs/minimatch) (minimatch fails a large percentage of the extglob tests)
- Handles [negation patterns](#extglob-patterns)
- Handles [nested patterns](#extglob-patterns)
- Organized code base, easy to maintain and make changes when edge cases arise
- As you can see by the [benchmarks](#benchmarks), extglob doesn't pay with speed for it's completeness, accuracy and quality.

**Heads up!**: This library only supports extglobs, to handle full glob patterns and other extended globbing features use [micromatch][] instead.

## Usage

The main export is a function that takes a string and options, and returns an object with the parsed AST and the compiled `.output`, which is a regex-compatible string that can be used for matching.

```js
var extglob = require('{%= name %}');
console.log(extglob('!(xyz)*.js'));
```

## Extglob cheatsheet

Extended globbing patterns can be defined as follows (as described by the [bash man page][bash]):

| **pattern** | **regex equivalent** | **description** |
| --- | --- | --- |
| `?(pattern-list)` | `(...|...)?` |  Matches zero or one occurrence of the given pattern(s) |
| `*(pattern-list)` | `(...|...)*` |  Matches zero or more occurrences of the given pattern(s) |
| `+(pattern-list)` | `(...|...)+` |  Matches one or more occurrences of the given pattern(s) |
| `@(pattern-list)` | `(...|...)` [^1] |  Matches one of the given pattern(s) |
| `!(pattern-list)` | N/A |  Matches anything except one of the given pattern(s) |

[^1]: `@` isn't a RegEx character.

## API
{%= apidocs("index.js") %}

## Options

Available options are based on the options from Bash (and the option names used in bash).

### options.nullglob 

**Type**: `boolean`

**Default**: `undefined`

When enabled, the pattern itself will be returned when no matches are found.

### options.nonull 

Alias for [options.nullglob](#optionsnullglob), included for parity with minimatch.

### options.cache 

**Type**: `boolean`

**Default**: `undefined`

Functions are memoized based on the given glob patterns and options. Disable memoization by setting `options.cache` to false.

### options.failglob 

**Type**: `boolean`

**Default**: `undefined`

Throw an error is no matches are found.

## Benchmarks

Last run on {%= date() %}

```sh
{%= include("benchmark/stats.md") %}
```

## Differences from Bash

This library has complete parity with Bash 4.3 with only a couple of minor differences. 

- In some cases Bash returns true if the given string "contains" the pattern, whereas this library returns true if the string is an exact match for the pattern. You can relax this by setting `options.contains` to true.
- This library is more accurate than Bash and thus does not fail some of the tests that Bash 4.3 still lists as failing in their unit tests

[bash]: https://www.gnu.org/software/bash/manual/html_node/Pattern-Matching.html
[micromatch]: https://github.com/jonschlinkert/micromatch
