//------------------------------------------------------------------------------
// GB_Matrix_free: free a GrB_Matrix or GrB_Vector
//------------------------------------------------------------------------------

// SuiteSparse:GraphBLAS, Timothy A. Davis, (c) 2017-2020, All Rights Reserved.
// http://suitesparse.com   See GraphBLAS/Doc/License.txt for license.

//------------------------------------------------------------------------------

// Free all the content of a matrix.  After GB_Matrix_free (&A), A is set to
// NULL.

#include "GB.h"
#include "GB_mkl.h"

GB_PUBLIC   // accessed by the MATLAB tests in GraphBLAS/Test only
GrB_Info GB_Matrix_free         // free a matrix
(
    GrB_Matrix *matrix          // handle of matrix to free
)
{

    if (matrix != NULL)
    {
        GrB_Matrix A = *matrix ;
        if (A != NULL && (A->magic == GB_MAGIC || A->magic == GB_MAGIC2))
        { 
            // free all content of A
            GB_PHIX_FREE (A) ;
            // free the MKL optimization, if it exists
            #if GB_HAS_MKL
            GB_MKL_GRAPH_MATRIX_DESTROY (A->mkl) ;
            #endif
            // free the header of A itself
            A->magic = GB_FREED ;      // to help detect dangling pointers
            GB_FREE (*matrix) ;
        }
        (*matrix) = NULL ;
    }

    return (GrB_SUCCESS) ;
}

