// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gio_sys;
use glib;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;
use std::ptr;
use Cancellable;

glib_wrapper! {
    pub struct Seekable(Interface<gio_sys::GSeekable>);

    match fn {
        get_type => || gio_sys::g_seekable_get_type(),
    }
}

pub const NONE_SEEKABLE: Option<&Seekable> = None;

pub trait SeekableExt: 'static {
    fn can_seek(&self) -> bool;

    fn can_truncate(&self) -> bool;

    fn seek<P: IsA<Cancellable>>(
        &self,
        offset: i64,
        type_: glib::SeekType,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error>;

    fn tell(&self) -> i64;

    fn truncate<P: IsA<Cancellable>>(
        &self,
        offset: i64,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error>;
}

impl<O: IsA<Seekable>> SeekableExt for O {
    fn can_seek(&self) -> bool {
        unsafe { from_glib(gio_sys::g_seekable_can_seek(self.as_ref().to_glib_none().0)) }
    }

    fn can_truncate(&self) -> bool {
        unsafe {
            from_glib(gio_sys::g_seekable_can_truncate(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn seek<P: IsA<Cancellable>>(
        &self,
        offset: i64,
        type_: glib::SeekType,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = gio_sys::g_seekable_seek(
                self.as_ref().to_glib_none().0,
                offset,
                type_.to_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn tell(&self) -> i64 {
        unsafe { gio_sys::g_seekable_tell(self.as_ref().to_glib_none().0) }
    }

    fn truncate<P: IsA<Cancellable>>(
        &self,
        offset: i64,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = gio_sys::g_seekable_truncate(
                self.as_ref().to_glib_none().0,
                offset,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }
}

impl fmt::Display for Seekable {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Seekable")
    }
}
