/*
 * Copyright (C) 2015 ~ 2018 Deepin Technology Co., Ltd.
 *
 * Author:     kirigaya <kirigaya@mkacg.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * This file was generated by qdbusxml2cpp version 0.8
 * Command line was: qdbusxml2cpp -c DCalendarDBus -p dcalendardbus com.deepin.api.LunarCalendar.xml
 *
 * qdbusxml2cpp is Copyright (C) 2015 Digia Plc and/or its subsidiary(-ies).
 *
 * This is an auto-generated file.
 * Do not edit! All changes made to it will be lost.
 */

#ifndef CALENDARDBUS_H
#define CALENDARDBUS_H

#include <QtCore/QObject>
#include <QtCore/QByteArray>
#include <QtCore/QDebug>
#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtDBus/QtDBus>
#include <QJsonDocument>
#include <QJsonParseError>
#include <QJsonObject>
#include <QJsonArray>
class CaYearInfo
{
public:
    CaYearInfo() {}

    inline static void registerMetaType();

    friend QDebug operator<<(QDebug argument, const CaYearInfo &what);
    friend QDBusArgument &operator<<(QDBusArgument &argument, const CaYearInfo &what);
    friend const QDBusArgument &operator>>(const QDBusArgument &argument, CaYearInfo &what);

public:
    qint32 mYear;
    qint32 mMonth;
    qint32 mDay;
};

class CaLunarDayInfo
{
public:
    CaLunarDayInfo() {}

    inline static void registerMetaType();

    friend QDebug operator<<(QDebug argument, const CaLunarDayInfo &what);
    friend QDBusArgument &operator<<(QDBusArgument &argument, const CaLunarDayInfo &what);
    friend const QDBusArgument &operator>>(const QDBusArgument &argument, CaLunarDayInfo &what);

public:
    QString mGanZhiYear;
    QString mGanZhiMonth;
    QString mGanZhiDay;
    QString mLunarMonthName;
    QString mLunarDayName;
    qint32 mLunarLeapMonth;
    QString mZodiac;
    QString mTerm;
    QString mSolarFestival;
    QString mLunarFestival;
    qint32 mWorktime;
};

class CaLunarMonthInfo
{
public:
    CaLunarMonthInfo() {}

    inline static void registerMetaType();

    friend QDebug operator<<(QDebug argument, const CaLunarMonthInfo &what);
    friend QDBusArgument &operator<<(QDBusArgument &argument, const CaLunarMonthInfo &what);
    friend const QDBusArgument &operator>>(const QDBusArgument &argument, CaLunarMonthInfo &what);

public:
    qint32 mFirstDayWeek;
    qint32 mDays;
    QList<CaLunarDayInfo> mCaLunarDayInfo;
};

class CaSolarMonthInfo
{
public:
    CaSolarMonthInfo() {}

    inline static void registerMetaType();

    friend QDebug operator<<(QDebug argument, const CaSolarMonthInfo &what);
    friend QDBusArgument &operator<<(QDBusArgument &argument, const CaSolarMonthInfo &what);
    friend const QDBusArgument &operator>>(const QDBusArgument &argument, CaSolarMonthInfo &what);


public:
    qint32 mFirstDayWeek;
    qint32 mDays;
    QList<CaYearInfo> mCaYearInfo;
};

class CaHuangLiDayInfo
{
public:
    CaHuangLiDayInfo() {}
    inline static void registerMetaType();
    friend QDebug operator<<(QDebug argument, const CaHuangLiDayInfo &what);
    friend QDBusArgument &operator<<(QDBusArgument &argument, const CaHuangLiDayInfo &what);
    friend const QDBusArgument &operator>>(const QDBusArgument &argument, CaHuangLiDayInfo &what);
public:
    QString mGanZhiYear;
    QString mGanZhiMonth;
    QString mGanZhiDay;
    QString mLunarMonthName;
    QString mLunarDayName;
    qint32 mLunarLeapMonth;
    QString mZodiac;
    QString mTerm;
    QString mSolarFestival;
    QString mLunarFestival;
    qint32 mWorktime;
    QString mSuit;
    QString mAvoid;
};

class CaHuangLiMonthInfo
{
public:
    CaHuangLiMonthInfo() {}
    inline static void registerMetaType();

    friend QDebug operator<<(QDebug argument, const CaHuangLiMonthInfo &what);
    friend QDBusArgument &operator<<(QDBusArgument &argument, const CaHuangLiMonthInfo &what);
    friend const QDBusArgument &operator>>(const QDBusArgument &argument, CaHuangLiMonthInfo &what);
public:
    qint32 mFirstDayWeek;
    qint32 mDays;
    QList<CaHuangLiDayInfo> mCaLunarDayInfo;
};
typedef struct _tagHolidayInfo {

    QDate  date;
    char   status;
} HolidayInfo;

typedef struct _tagFestivalInfo {
    QString ID;
    QString FestivalName;
    QString description;
    QString Rest;
    int   month;
    int   year;
    QVector<HolidayInfo> listHoliday;
} FestivalInfo;


/*
 * Proxy class for interface com.deepin.api.LunarCalendar
 */
class CalendarDBus: public QDBusAbstractInterface
{
    Q_OBJECT

    Q_SLOT void __propertyChanged__(const QDBusMessage &msg)
    {
        QList<QVariant> arguments = msg.arguments();
        if (3 != arguments.count())
            return;
        QString interfaceName = msg.arguments().at(0).toString();
        if (interfaceName != "com.deepin.api.LunarCalendar")
            return;
        QVariantMap changedProps = qdbus_cast<QVariantMap>(arguments.at(1).value<QDBusArgument>());
        foreach (const QString &prop, changedProps.keys()) {
            const QMetaObject *self = metaObject();
            for (int i = self->propertyOffset(); i < self->propertyCount(); ++i) {
                QMetaProperty p = self->property(i);
                if (p.name() == prop) {
                    Q_EMIT p.notifySignal().invoke(this);
                }
            }
        }
    }
public:
    static inline const char *staticInterfaceName()
    {
        return "com.deepin.api.LunarCalendar";
    }

public:
    CalendarDBus(const QString &service, const QString &path, const QDBusConnection &connection, QObject *parent = 0);

    ~CalendarDBus();

public Q_SLOTS: // METHODS
    inline QDBusPendingReply<CaYearInfo, bool, bool> GetLunarDateBySolar(int in0, int in1, int in2)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(in0) << QVariant::fromValue(in1) << QVariant::fromValue(in2);
        return asyncCallWithArgumentList(QStringLiteral("GetLunarDateBySolar"), argumentList);
    }
    inline QDBusReply<CaYearInfo> GetLunarDateBySolar(int in0, int in1, int in2, bool &out1, bool &out2)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(in0) << QVariant::fromValue(in1) << QVariant::fromValue(in2);
        QDBusMessage reply = callWithArgumentList(QDBus::Block, QStringLiteral("GetLunarDateBySolar"), argumentList);
        if (reply.type() == QDBusMessage::ReplyMessage && reply.arguments().count() == 3) {
            out1 = qdbus_cast<bool>(reply.arguments().at(1));
            out2 = qdbus_cast<bool>(reply.arguments().at(2));
        }
        return reply;
    }

    inline QDBusPendingReply<CaLunarDayInfo, bool> GetLunarInfoBySolar(int in0, int in1, int in2)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(in0) << QVariant::fromValue(in1) << QVariant::fromValue(in2);
        return asyncCallWithArgumentList(QStringLiteral("GetLunarInfoBySolar"), argumentList);
    }
    inline QDBusReply<CaLunarDayInfo> GetLunarInfoBySolar(qint32 in0, qint32 in1, qint32 in2, bool &out1)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(in0) << QVariant::fromValue(in1) << QVariant::fromValue(in2);
        QDBusMessage reply = callWithArgumentList(QDBus::Block, QStringLiteral("GetLunarInfoBySolar"), argumentList);
        if (reply.type() == QDBusMessage::ReplyMessage && reply.arguments().count() == 2) {
            out1 = qdbus_cast<bool>(reply.arguments().at(1));
        }
        return reply;
    }

    inline QDBusPendingReply<CaLunarMonthInfo, bool> GetLunarMonthCalendar(int in0, int in1, bool in2)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(in0) << QVariant::fromValue(in1) << QVariant::fromValue(in2);
        return asyncCallWithArgumentList(QStringLiteral("GetLunarMonthCalendar"), argumentList);
    }
    inline QDBusReply<CaLunarMonthInfo> GetLunarMonthCalendar(int in0, int in1, bool in2, bool &out1)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(in0) << QVariant::fromValue(in1) << QVariant::fromValue(in2);
        QDBusMessage reply = callWithArgumentList(QDBus::Block, QStringLiteral("GetLunarMonthCalendar"), argumentList);
        if (reply.type() == QDBusMessage::ReplyMessage && reply.arguments().count() == 2) {
            out1 = qdbus_cast<bool>(reply.arguments().at(1));
        }
        return reply;
    }

    inline QDBusPendingReply<CaYearInfo, bool> GetSolarDateByLunar(int in0, int in1, int in2, bool in3)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(in0) << QVariant::fromValue(in1) << QVariant::fromValue(in2) << QVariant::fromValue(in3);
        return asyncCallWithArgumentList(QStringLiteral("GetSolarDateByLunar"), argumentList);
    }
    inline QDBusReply<CaYearInfo> GetSolarDateByLunar(int in0, int in1, int in2, bool in3, bool &out1)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(in0) << QVariant::fromValue(in1) << QVariant::fromValue(in2) << QVariant::fromValue(in3);
        QDBusMessage reply = callWithArgumentList(QDBus::Block, QStringLiteral("GetSolarDateByLunar"), argumentList);
        if (reply.type() == QDBusMessage::ReplyMessage && reply.arguments().count() == 2) {
            out1 = qdbus_cast<bool>(reply.arguments().at(1));
        }
        return reply;
    }

    inline QDBusPendingReply<CaSolarMonthInfo, bool> GetSolarMonthCalendar(int in0, int in1, bool in2)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(in0) << QVariant::fromValue(in1) << QVariant::fromValue(in2);
        return asyncCallWithArgumentList(QStringLiteral("GetSolarMonthCalendar"), argumentList);
    }
    inline QDBusReply<CaSolarMonthInfo> GetSolarMonthCalendar(int in0, int in1, bool in2, bool &out1)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(in0) << QVariant::fromValue(in1) << QVariant::fromValue(in2);
        QDBusMessage reply = callWithArgumentList(QDBus::Block, QStringLiteral("GetSolarMonthCalendar"), argumentList);
        if (reply.type() == QDBusMessage::ReplyMessage && reply.arguments().count() == 2) {
            out1 = qdbus_cast<bool>(reply.arguments().at(1));
        }
        return reply;
    }
    inline bool GetHuangLiMonthCalendar(int in0, int in1, bool in2, CaHuangLiMonthInfo &out)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(in0) << QVariant::fromValue(in1) << QVariant::fromValue(in2);
        QDBusMessage reply = callWithArgumentList(QDBus::Block, QStringLiteral("GetHuangLiMonth"), argumentList);
        if (reply.type() != QDBusMessage::ReplyMessage ) {
            return false;
        }
        QDBusReply<QString> huanglimonth =  reply;
        if (!huanglimonth.isValid()) return false;
        QJsonParseError json_error;
        QJsonDocument jsonDoc(QJsonDocument::fromJson(huanglimonth.value().toLocal8Bit(), &json_error));

        if (json_error.error != QJsonParseError::NoError) {
            return false;
        }

        QJsonObject rootObj = jsonDoc.object();

        //因为是预先定义好的JSON数据格式，所以这里可以这样读取
        if (rootObj.contains("Days")) {
            out.mDays = rootObj.value("Days").toInt();
        }
        if (rootObj.contains("FirstDayWeek")) {
            out.mFirstDayWeek = rootObj.value("FirstDayWeek").toInt();
        }
        if (rootObj.contains("Datas")) {
            QJsonArray subArray = rootObj.value("Datas").toArray();
            for (int i = 0; i < subArray.size(); i++) {

                QJsonObject subObj = subArray.at(i).toObject();

                CaHuangLiDayInfo huangliday;

                //因为是预先定义好的JSON数据格式，所以这里可以这样读取
                if (subObj.contains("Suit")) {
                    huangliday.mSuit = subObj.value("Suit").toString();
                }
                if (subObj.contains("Avoid")) {
                    huangliday.mAvoid = subObj.value("Avoid").toString();
                }
                if (subObj.contains("Worktime")) {
                    huangliday.mWorktime = subObj.value("Worktime").toInt();
                }
                if (subObj.contains("LunarFestival")) {
                    huangliday.mLunarFestival = subObj.value("LunarFestival").toString();
                }
                if (subObj.contains("SolarFestival")) {
                    huangliday.mSolarFestival = subObj.value("SolarFestival").toString();
                }
                if (subObj.contains("Term")) {
                    huangliday.mTerm = subObj.value("Term").toString();
                }
                if (subObj.contains("Zodiac")) {
                    huangliday.mZodiac = subObj.value("Zodiac").toString();
                }
                if (subObj.contains("LunarLeapMonth")) {
                    huangliday.mLunarLeapMonth = subObj.value("LunarLeapMonth").toInt();
                }
                if (subObj.contains("LunarDayName")) {
                    huangliday.mLunarDayName = subObj.value("LunarDayName").toString();
                }
                if (subObj.contains("LunarMonthName")) {
                    huangliday.mLunarMonthName = subObj.value("LunarMonthName").toString();
                }
                if (subObj.contains("GanZhiDay")) {
                    huangliday.mGanZhiDay = subObj.value("GanZhiDay").toString();
                }
                if (subObj.contains("GanZhiMonth")) {
                    huangliday.mGanZhiMonth = subObj.value("GanZhiMonth").toString();
                }
                if (subObj.contains("GanZhiYear")) {
                    huangliday.mGanZhiYear = subObj.value("GanZhiYear").toString();
                }
                out.mCaLunarDayInfo.append(huangliday);
            }
        }

        return true;
    }

    inline bool GetHuangLiDayCalendar(qint32 in0, qint32 in1, qint32 in2, CaHuangLiDayInfo &out)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(in0) << QVariant::fromValue(in1) << QVariant::fromValue(in2);
        QDBusMessage reply = callWithArgumentList(QDBus::Block, QStringLiteral("GetHuangLiDay"), argumentList);
        if (reply.type() != QDBusMessage::ReplyMessage ) {
            return  false;
        }
        QDBusReply<QString> huangliday =  reply;
        if (!huangliday.isValid()) return false;
        QJsonParseError json_error;
        QJsonDocument jsonDoc(QJsonDocument::fromJson(huangliday.value().toLocal8Bit(), &json_error));

        if (json_error.error != QJsonParseError::NoError) {
            return false;
        }

        QJsonObject rootObj = jsonDoc.object();

        //因为是预先定义好的JSON数据格式，所以这里可以这样读取
        if (rootObj.contains("Suit")) {
            out.mSuit = rootObj.value("Suit").toString();
        }
        if (rootObj.contains("Avoid")) {
            out.mAvoid = rootObj.value("Avoid").toString();
        }
        if (rootObj.contains("Worktime")) {
            out.mWorktime = rootObj.value("Worktime").toInt();
        }
        if (rootObj.contains("LunarFestival")) {
            out.mLunarFestival = rootObj.value("LunarFestival").toString();
        }
        if (rootObj.contains("SolarFestival")) {
            out.mSolarFestival = rootObj.value("SolarFestival").toString();
        }
        if (rootObj.contains("Term")) {
            out.mTerm = rootObj.value("Term").toString();
        }
        if (rootObj.contains("Zodiac")) {
            out.mZodiac = rootObj.value("Zodiac").toString();
        }
        if (rootObj.contains("LunarLeapMonth")) {
            out.mLunarLeapMonth = rootObj.value("LunarLeapMonth").toInt();
        }
        if (rootObj.contains("LunarDayName")) {
            out.mLunarDayName = rootObj.value("LunarDayName").toString();
        }
        if (rootObj.contains("LunarMonthName")) {
            out.mLunarMonthName = rootObj.value("LunarMonthName").toString();
        }
        if (rootObj.contains("GanZhiDay")) {
            out.mGanZhiDay = rootObj.value("GanZhiDay").toString();
        }
        if (rootObj.contains("GanZhiMonth")) {
            out.mGanZhiMonth = rootObj.value("GanZhiMonth").toString();
        }
        if (rootObj.contains("GanZhiYear")) {
            out.mGanZhiYear = rootObj.value("GanZhiYear").toString();
        }
        return true;
    }
    inline bool GetFestivalMonth(int in0, int in1, QVector<FestivalInfo> &out)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(in0) << QVariant::fromValue(in1);
        QDBusMessage reply = callWithArgumentList(QDBus::Block, QStringLiteral("GetFestivalMonth"), argumentList);
        if (reply.type() != QDBusMessage::ReplyMessage ) {
            return false;
        }
        QDBusReply<QString> festivalMonthinfo =  reply;
        if (!festivalMonthinfo.isValid()) return false;
        QJsonParseError json_error;
        QJsonDocument jsonDoc(QJsonDocument::fromJson(festivalMonthinfo.value().toLocal8Bit(), &json_error));

        if (json_error.error != QJsonParseError::NoError) {
            return false;
        }
        QJsonArray rootarry = jsonDoc.array();

        for (int i = 0; i < rootarry.size(); i++) {

            QJsonObject subObj = rootarry.at(i).toObject();

            FestivalInfo festivalInfoday;

            //因为是预先定义好的JSON数据格式，所以这里可以这样读取
            if (subObj.contains("id")) {
                festivalInfoday.ID = subObj.value("id").toString();
            }
            if (subObj.contains("name")) {
                festivalInfoday.FestivalName = subObj.value("name").toString();
            }
            if (subObj.contains("description")) {
                festivalInfoday.description = subObj.value("description").toString();
            }
            if (subObj.contains("rest")) {
                festivalInfoday.Rest = subObj.value("rest").toString();
            }
            if (subObj.contains("month")) {
                festivalInfoday.month = subObj.value("month").toInt();
            }
            if (subObj.contains("list")) {
                QJsonArray sublistArray = subObj.value("list").toArray();

                for (int j = 0; j < sublistArray.size(); j++) {

                    QJsonObject hsubObj = sublistArray.at(j).toObject();
                    HolidayInfo dayinfo;
                    if (hsubObj.contains("status")) {
                        dayinfo.status = hsubObj.value("status").toInt();
                    }
                    if (hsubObj.contains("date")) {
                        dayinfo.date = QDate::fromString(hsubObj.value("date").toString(), "yyyy-M-d");
                    }
                    festivalInfoday.listHoliday.append(dayinfo);
                }
            }
            festivalInfoday.year = in0;
            out.append(festivalInfoday);
        }

        return true;
    }


Q_SIGNALS: // SIGNALS
// begin property changed signals
};

namespace com {
namespace deepin {
namespace api {
typedef ::CalendarDBus LunarCalendar;
}
}
}

Q_DECLARE_METATYPE(CaYearInfo)
Q_DECLARE_METATYPE(CaLunarDayInfo)
Q_DECLARE_METATYPE(CaLunarMonthInfo)
Q_DECLARE_METATYPE(CaSolarMonthInfo)
Q_DECLARE_METATYPE(CaHuangLiDayInfo)
Q_DECLARE_METATYPE(CaHuangLiMonthInfo)
#endif
