# Announce: Rakudo Perl 6 compiler, Release #113 (2017.07)

On behalf of the Rakudo development team, I’m very happy to announce the
July 2017 release of Rakudo Perl 6 #113. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo, but no new features.

Upcoming releases in 2017 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2017.07:
 + Deprecations:
    + Deprecate `(<+)` ≼ `(>+)` ≽ in favor of `(<=)` ⊆ `(>=)` ⊇ [35cc7c0e]
 + Fixes:
    + Fixed perl6-debug-m debugger [6d4691fb]
    + Fixed finding proper %?RESOURCES for non-lib CURFS [71ffb164]
    + Fixed Mixy (-) Mixy behaviour for missing keys [4a37de7b]
    + Fixed Mixy.Setty coercion [b31b159c]
    + Fixed .perl of empty Bag and Mix [f72c97cb]
    + Fixed crash on dotless version literals given to `use` [fe7ea124]
    + Fixed various coercion related issues with (-) [19a1caa3]
    + Fixed Baggy/Mixy (-) Any/Iterable [a2133dbc]
    + Made sure we catch lazy lists on right of (-) and (|) [62d54c75][c16334e5]
    + Fixed mix() (-) `<a b c>.Mix` [c727462c]
    + Fixed multi-dispatch with numeric literals and native types [1c0ed61a]
    + Fixed enum.Real coercion [ad9ed1cb][c226b71a]
    + Fixed (:e).Bag|Mix coercion using a Bool as a weight instead of just Int [d765f186]
    + Fixed outstanding issues with coercions done by (+) [c7922f14]
    + Fixed a data race in Proc::Async [2a8d1e7c]
    + Fixed `(&)`'s handling of lazy lists [cb06ebac]
    + Made set ops properly handle lazy lists [04746490][3058ba0d]
    + Made sure unhandled failures don't coerce QuantHashy [43fc751b]
    + Fixed sprintf octal format with precision [d7e10466]
    + Fixed 'is export' on constants assigned to routines [d067abf4]
    + Fixed Deprecation.report case where "removed" is set and "from" isn't [1b6d048b][e20817fb]
    + Fixed crash in coercers used with sigilless vars [c76d9324]
    + Made sure IO::Socket passes a list to set-line-separators [a2090821]
    + Prioritized .pm6 extension over .pm when files with both extensions exist [e1e9091f]
    + Fixed SEGV in Proc::Async.new [f6d4fbd2]
    + Fixed a few edge cases of (^) wrt QuantHash type permutations [b3916926]
    + Fixed regression in Map intialized with `<...>` having writable containers [4894a75d]
    + Fixed overflow in uniprop lookups [4f5a1e20]
    + Made improvements to segmentation of Emoji w/ GCB=Other [4f5a1e20]
    + Fixed break after ZWJ for Emoji=True + GCB=Other [4f5a1e20]
    + Removed faulty Iterable (^) Iterable candidate [4c91b522]
    + Fixed faulty Map (^) Map candidate [8afbfe6f]
    + Fixed inconsistent semantics in `<a b>.Bag (<) <a b b>.Bag` [4b8bc617]
    + Fixed unwanted de-Bool during optimization of some constructs [83e15701]
    + Fixed handling of actions in .refine_slang [c40a2122]
    + Fixed baggy semantics of Mix `(<)` Mix [a526d839]
    + Fixed semantics of `mix() (^) (a=>-42).Mix` [8d5f3324]
    + Fixed precomp deps left open when up-to-date check failed [37250ed5]
    + Properly implemented Baggy semantics for `(<=)` and `(<)` [4101581d][c6cc1a7a]
    + Fixed handling of `[(^)]` with absentee keys and Mixies correctly [0c02f93e]
    + Fixed faulty dynamic cache invalidation in continuations [d74ebd82]
    + Fixed issues with calling `infix:<⊖>` with more than 2 params [aee4a46c]
    + Fixed Proc :merge [c86090e3]
    + Made sure we call done/quit on all taps [32b72cda]
    + Ensured empty string PERL6LIB var does not get interpreted as `.` [075ddefa]
    + Fixed floating point noise in denominator of Rat literals [f6e25b54]
    + Fixed .getc and .readchars reading too much at EOF [80bbfcdd][49f555a2][f6279c34]
    + Fixed SEGV and memory leak in MoarVM that impacted parameter destructuring [f6279c34]
    + Made `exit()` coerce its argument to Int [caa9ef81]
    + Made IO::Handle.new coerce `:path` to IO [fec90956]
    + Various improvements to warnings and error reporting [bde28209][06379113][d5d3bd27]
        [d39f7b9a][1dda8622][d74ebd82][88acdbb7]
 + Additions:
    + Added full Unicode 9.0 and Emoji 4.0 text segmentation support [c40a2122]
    + Implemented tentative API for custom user encoder support [d0995f68][5ab4036e]
    + Implemented experimental buffering support in IO::Handle [86e7b2bd]
    + Collation object updated to work with new unicmp_s semantics [4da85879][47678077]
    + Allow getting native descriptor in Proc::Async [82301128]
    + Re-worked Proc so :in($p1.out) will plumb file descriptors [6dae179a][abfd7d95]
    + Added plumbing stdout/stderr to stdin in Proc::Async [11b02d2c]
    + Allow for "does Rational" and "does Rational[foo]" [41ed2c03]
    + Added `%*SUB-MAIN-OPTS` [40b0169d][da6c6584]
    + Implemented baggy semantics of `(<)` and `(<=)` [75797af3]
    + Added perl6-lldb-m for debugging MoarVM on the LLVM debugger [00dc4947]
 + Efficiency:
    + Made Baggy (-) Baggy about 100x faster [2a88c20c]
    + Made [(^)] Set, Set, Set about 35x times faster [0cdd6c25]
    + Made Setty (-) Setty at least 20x faster [10f840fc]
    + Made .BUILD/.TWEAK calls 15x faster when ther are no args to .new [43c1767b]
    + Made (Bag|Mix).WHICH about 8x faster [b2d2bf59][c585f370][d8c94353]
    + Made Map (+) Map between 3x and 6x faster [495fb5f8]
    + Made Baggy eqv Baggy upto 3.5x faster [49b1b03b]
    + Made Setty.ACCEPTS(Setty) about 3.5x faster [93d81d61][48c18f58][1ab4fd80]
    + Made Map.(Bag|Mix) 2.5x to 5x faster [72e5d614]
    + Made Setty eqv Setty between 2x and 3.5x faster [25047984]
    + Made Setty (-) Map between 2x and 3x faster [9936a3be]
    + Made Setty (-) Iterable about 3.5x faster [b66d8783]
    + Made Str.subst(Str,Str) upto 3x faster [327c8409]
    + Made Setty (+) Map about 2.5x faster [201a0bfb]
    + Made Any (-) Map|Iterable about 2x faster [e4f3358f]
    + Made Mix (+) Mix about 1.5x faster [d1838461]
    + Made Baggy (-) Baggy about 1.5x faster [36823ab1]
    + Made starting of installed scripts 46% faster [92f8abe0][4693ec86]
    + Made Baggy.keys about 40% faster [c65652d8]
    + Made Iterable (+) Iterable about 20% faster [38509227]
    + Made Setty (-) Setty about 20% faster [bacaa051]
    + Made internal nqp::index op used by many string operations 16% faster [4f5a1e20]
    + Made Setty.(Bag|Mix) about 5% faster [ae4c04ce]
    + Made Str:D (elem) Map 3%-10% faster [099a84b4]
    + Made Stash.AT-KEY a few percent faster [2ce5b678]
    + Gave Nil methods a much more efficient "take any args" signature [9a2127f2]
    + Made Exception messages created only when gisting [1a4d9493]
    + Made Any.tail() use iterator's .count-only if available [9c04dfc4]
    + Reduced cases when string concatenation needs renormalization [c40a2122]
    + Improve the speed of Unicode normalization [c40a2122]
    + Made all non-Texas set operators aliases where possible [f6025eb9]
    + Simplified `infix:<(|)>(**@)` candidate [46e009bf]
    + Fixed various VM errors in CallFrame. [e2ec7bdf]
    + Improved speed of `try` when exceptions are caught [1a4d9493]
    + Assorted internal improvements to CPU/memory use [3d2a521c][5a80412c][c4e14731][19be8722]
        [f03a176c][fff43337][f71cbed4][79ce1a99][640404fc][b4561229][30619e8d][9d14a724][a2a0d5c6]
        [66aef589][a95c70bd][d7e10466][73c3bcc6][7f109ed7][80b3e89b][05c255c1][2fb109f1][c0eeebde]


The following people contributed to this release:

Elizabeth Mattijsen, Zoffix Znet, Jonathan Worthington, Jan-Olof Hendig,
Will "Coke" Coleda, Pawel Murias, Samantha McVey, Nick Logan,
Stefan Seifert, Timo Paulssen, Altai-man, Larry Wall, Daniel Green,
karl yerkes, seatek, Moritz Lenz, Brad Gilbert, LLFourn, Tom Browder,
Lloyd Fournier, ven, Gabor Szabo, Vynce Montgomery, Greg Donald,
Brian Duggan, Steve Mynott, Aleks-Daniel Jakimenko-Aleksejev

as well as

Bart Wiegmans, Douglas Schrag, Gerd Pokorra, Lucas Buchala, Paweł Murias, gerd

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put "Perl 6 Core Development Fund" in the 'Purpose' text field)

The next release of Rakudo (#114), is tentatively scheduled for 2017-08-19.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory documentation,
and other software that can be used with the Rakudo compiler to enhance its utility.
