% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplotTAP.R
\name{autoplotTableAndPlot}
\alias{autoplotTableAndPlot}
\alias{autoplot.tableAndPlot}
\title{Arrange a survival plot with corresponding table and legend.}
\usage{
\method{autoplot}{tableAndPlot}(object, ..., hideTabLeg = TRUE,
  tabHeight = 0.25)
}
\arguments{
\item{object}{An object of class \code{"tableAndPlot"}, as returned by
\code{ggplot.Ten}.}

\item{...}{Additional arguments (not implemented).}

\item{hideTabLeg}{Hide table legend.
\cr
If \code{hideTabLeg = TRUE} (the default), the table legend will not appear.}

\item{tabHeight}{Table height, as a fraction/ proportion of the whole.
 \cr
\code{tabHeight=0.25} (the default) makes the table 
\eqn{0.25 = 25\%} of the whole plot height.}
}
\value{
A graph, plotted with \code{gridExtra::grid.arrange}.
}
\description{
Arrange a survival plot with corresponding table and legend.
}
\details{
Arguments to \code{plotHeigth} and \code{tabHeight} are
best specified as fractions adding to \eqn{1},
\cr
}
\note{
This method is called by \code{\link{print.tableAndPlot}}
and by \code{print.stratTableAndPlot}.
}
\examples{
\dontrun{
data("kidney", package="KMsurv")
autoplot(survfit(Surv(time, delta) ~ type, data=kidney), type="fill")
autoplot(ten(survfit(Surv(time, delta) ~ type, data=kidney)), type="fill")
data("bmt", package="KMsurv")
s2 <- survfit(Surv(time=t2, event=d3) ~ group, data=bmt)
autoplot(s2)
}
}
\author{
Chris Dardis. Based on existing work by
R. Saccilotto, Abhijit Dasgupta, Gil Tomas and Mark Cowley.
}
\keyword{graphics}
