# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, overload
from urllib.parse import parse_qs, urljoin, urlparse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._threat_intelligence_indicator_operations import (
    build_append_tags_request,
    build_create_indicator_request,
    build_create_request,
    build_delete_request,
    build_get_request,
    build_query_indicators_request,
    build_replace_tags_request,
)

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ThreatIntelligenceIndicatorOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.securityinsight.aio.SecurityInsights`'s
        :attr:`threat_intelligence_indicator` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def create_indicator(
        self,
        resource_group_name: str,
        workspace_name: str,
        threat_intelligence_properties: _models.ThreatIntelligenceIndicatorModel,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ThreatIntelligenceInformation:
        """Create a new threat intelligence indicator.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param threat_intelligence_properties: Properties of threat intelligence indicators to create
         and update. Required.
        :type threat_intelligence_properties:
         ~azure.mgmt.securityinsight.models.ThreatIntelligenceIndicatorModel
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ThreatIntelligenceInformation or the result of cls(response)
        :rtype: ~azure.mgmt.securityinsight.models.ThreatIntelligenceInformation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_indicator(
        self,
        resource_group_name: str,
        workspace_name: str,
        threat_intelligence_properties: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ThreatIntelligenceInformation:
        """Create a new threat intelligence indicator.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param threat_intelligence_properties: Properties of threat intelligence indicators to create
         and update. Required.
        :type threat_intelligence_properties: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ThreatIntelligenceInformation or the result of cls(response)
        :rtype: ~azure.mgmt.securityinsight.models.ThreatIntelligenceInformation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_indicator(
        self,
        resource_group_name: str,
        workspace_name: str,
        threat_intelligence_properties: Union[_models.ThreatIntelligenceIndicatorModel, IO],
        **kwargs: Any
    ) -> _models.ThreatIntelligenceInformation:
        """Create a new threat intelligence indicator.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param threat_intelligence_properties: Properties of threat intelligence indicators to create
         and update. Is either a model type or a IO type. Required.
        :type threat_intelligence_properties:
         ~azure.mgmt.securityinsight.models.ThreatIntelligenceIndicatorModel or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ThreatIntelligenceInformation or the result of cls(response)
        :rtype: ~azure.mgmt.securityinsight.models.ThreatIntelligenceInformation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ThreatIntelligenceInformation]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(threat_intelligence_properties, (IO, bytes)):
            _content = threat_intelligence_properties
        else:
            _json = self._serialize.body(threat_intelligence_properties, "ThreatIntelligenceIndicatorModel")

        request = build_create_indicator_request(
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_indicator.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("ThreatIntelligenceInformation", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("ThreatIntelligenceInformation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_indicator.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/threatIntelligence/main/createIndicator"}  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, workspace_name: str, name: str, **kwargs: Any
    ) -> _models.ThreatIntelligenceInformation:
        """View a threat intelligence indicator by name.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param name: Threat intelligence indicator name field. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ThreatIntelligenceInformation or the result of cls(response)
        :rtype: ~azure.mgmt.securityinsight.models.ThreatIntelligenceInformation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ThreatIntelligenceInformation]

        request = build_get_request(
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ThreatIntelligenceInformation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/threatIntelligence/main/indicators/{name}"}  # type: ignore

    @overload
    async def create(
        self,
        resource_group_name: str,
        workspace_name: str,
        name: str,
        threat_intelligence_properties: _models.ThreatIntelligenceIndicatorModel,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ThreatIntelligenceInformation:
        """Update a threat Intelligence indicator.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param name: Threat intelligence indicator name field. Required.
        :type name: str
        :param threat_intelligence_properties: Properties of threat intelligence indicators to create
         and update. Required.
        :type threat_intelligence_properties:
         ~azure.mgmt.securityinsight.models.ThreatIntelligenceIndicatorModel
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ThreatIntelligenceInformation or the result of cls(response)
        :rtype: ~azure.mgmt.securityinsight.models.ThreatIntelligenceInformation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        resource_group_name: str,
        workspace_name: str,
        name: str,
        threat_intelligence_properties: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ThreatIntelligenceInformation:
        """Update a threat Intelligence indicator.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param name: Threat intelligence indicator name field. Required.
        :type name: str
        :param threat_intelligence_properties: Properties of threat intelligence indicators to create
         and update. Required.
        :type threat_intelligence_properties: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ThreatIntelligenceInformation or the result of cls(response)
        :rtype: ~azure.mgmt.securityinsight.models.ThreatIntelligenceInformation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self,
        resource_group_name: str,
        workspace_name: str,
        name: str,
        threat_intelligence_properties: Union[_models.ThreatIntelligenceIndicatorModel, IO],
        **kwargs: Any
    ) -> _models.ThreatIntelligenceInformation:
        """Update a threat Intelligence indicator.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param name: Threat intelligence indicator name field. Required.
        :type name: str
        :param threat_intelligence_properties: Properties of threat intelligence indicators to create
         and update. Is either a model type or a IO type. Required.
        :type threat_intelligence_properties:
         ~azure.mgmt.securityinsight.models.ThreatIntelligenceIndicatorModel or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ThreatIntelligenceInformation or the result of cls(response)
        :rtype: ~azure.mgmt.securityinsight.models.ThreatIntelligenceInformation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ThreatIntelligenceInformation]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(threat_intelligence_properties, (IO, bytes)):
            _content = threat_intelligence_properties
        else:
            _json = self._serialize.body(threat_intelligence_properties, "ThreatIntelligenceIndicatorModel")

        request = build_create_request(
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("ThreatIntelligenceInformation", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("ThreatIntelligenceInformation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/threatIntelligence/main/indicators/{name}"}  # type: ignore

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, workspace_name: str, name: str, **kwargs: Any
    ) -> None:
        """Delete a threat intelligence indicator.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param name: Threat intelligence indicator name field. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_request(
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/threatIntelligence/main/indicators/{name}"}  # type: ignore

    @overload
    def query_indicators(
        self,
        resource_group_name: str,
        workspace_name: str,
        threat_intelligence_filtering_criteria: _models.ThreatIntelligenceFilteringCriteria,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterable["_models.ThreatIntelligenceInformation"]:
        """Query threat intelligence indicators as per filtering criteria.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param threat_intelligence_filtering_criteria: Filtering criteria for querying threat
         intelligence indicators. Required.
        :type threat_intelligence_filtering_criteria:
         ~azure.mgmt.securityinsight.models.ThreatIntelligenceFilteringCriteria
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ThreatIntelligenceInformation or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.securityinsight.models.ThreatIntelligenceInformation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def query_indicators(
        self,
        resource_group_name: str,
        workspace_name: str,
        threat_intelligence_filtering_criteria: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterable["_models.ThreatIntelligenceInformation"]:
        """Query threat intelligence indicators as per filtering criteria.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param threat_intelligence_filtering_criteria: Filtering criteria for querying threat
         intelligence indicators. Required.
        :type threat_intelligence_filtering_criteria: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ThreatIntelligenceInformation or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.securityinsight.models.ThreatIntelligenceInformation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def query_indicators(
        self,
        resource_group_name: str,
        workspace_name: str,
        threat_intelligence_filtering_criteria: Union[_models.ThreatIntelligenceFilteringCriteria, IO],
        **kwargs: Any
    ) -> AsyncIterable["_models.ThreatIntelligenceInformation"]:
        """Query threat intelligence indicators as per filtering criteria.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param threat_intelligence_filtering_criteria: Filtering criteria for querying threat
         intelligence indicators. Is either a model type or a IO type. Required.
        :type threat_intelligence_filtering_criteria:
         ~azure.mgmt.securityinsight.models.ThreatIntelligenceFilteringCriteria or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ThreatIntelligenceInformation or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.securityinsight.models.ThreatIntelligenceInformation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ThreatIntelligenceInformationList]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})
        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(threat_intelligence_filtering_criteria, (IO, bytes)):
            _content = threat_intelligence_filtering_criteria
        else:
            _json = self._serialize.body(threat_intelligence_filtering_criteria, "ThreatIntelligenceFilteringCriteria")

        def prepare_request(next_link=None):
            if not next_link:

                request = build_query_indicators_request(
                    resource_group_name=resource_group_name,
                    workspace_name=workspace_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    content_type=content_type,
                    json=_json,
                    content=_content,
                    template_url=self.query_indicators.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ThreatIntelligenceInformationList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    query_indicators.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/threatIntelligence/main/queryIndicators"}  # type: ignore

    @overload
    async def append_tags(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        workspace_name: str,
        name: str,
        threat_intelligence_append_tags: _models.ThreatIntelligenceAppendTags,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Append tags to a threat intelligence indicator.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param name: Threat intelligence indicator name field. Required.
        :type name: str
        :param threat_intelligence_append_tags: The threat intelligence append tags request body.
         Required.
        :type threat_intelligence_append_tags:
         ~azure.mgmt.securityinsight.models.ThreatIntelligenceAppendTags
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def append_tags(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        workspace_name: str,
        name: str,
        threat_intelligence_append_tags: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Append tags to a threat intelligence indicator.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param name: Threat intelligence indicator name field. Required.
        :type name: str
        :param threat_intelligence_append_tags: The threat intelligence append tags request body.
         Required.
        :type threat_intelligence_append_tags: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def append_tags(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        workspace_name: str,
        name: str,
        threat_intelligence_append_tags: Union[_models.ThreatIntelligenceAppendTags, IO],
        **kwargs: Any
    ) -> None:
        """Append tags to a threat intelligence indicator.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param name: Threat intelligence indicator name field. Required.
        :type name: str
        :param threat_intelligence_append_tags: The threat intelligence append tags request body. Is
         either a model type or a IO type. Required.
        :type threat_intelligence_append_tags:
         ~azure.mgmt.securityinsight.models.ThreatIntelligenceAppendTags or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(threat_intelligence_append_tags, (IO, bytes)):
            _content = threat_intelligence_append_tags
        else:
            _json = self._serialize.body(threat_intelligence_append_tags, "ThreatIntelligenceAppendTags")

        request = build_append_tags_request(
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.append_tags.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    append_tags.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/threatIntelligence/main/indicators/{name}/appendTags"}  # type: ignore

    @overload
    async def replace_tags(
        self,
        resource_group_name: str,
        workspace_name: str,
        name: str,
        threat_intelligence_replace_tags: _models.ThreatIntelligenceIndicatorModel,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ThreatIntelligenceInformation:
        """Replace tags added to a threat intelligence indicator.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param name: Threat intelligence indicator name field. Required.
        :type name: str
        :param threat_intelligence_replace_tags: Tags in the threat intelligence indicator to be
         replaced. Required.
        :type threat_intelligence_replace_tags:
         ~azure.mgmt.securityinsight.models.ThreatIntelligenceIndicatorModel
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ThreatIntelligenceInformation or the result of cls(response)
        :rtype: ~azure.mgmt.securityinsight.models.ThreatIntelligenceInformation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def replace_tags(
        self,
        resource_group_name: str,
        workspace_name: str,
        name: str,
        threat_intelligence_replace_tags: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ThreatIntelligenceInformation:
        """Replace tags added to a threat intelligence indicator.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param name: Threat intelligence indicator name field. Required.
        :type name: str
        :param threat_intelligence_replace_tags: Tags in the threat intelligence indicator to be
         replaced. Required.
        :type threat_intelligence_replace_tags: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ThreatIntelligenceInformation or the result of cls(response)
        :rtype: ~azure.mgmt.securityinsight.models.ThreatIntelligenceInformation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def replace_tags(
        self,
        resource_group_name: str,
        workspace_name: str,
        name: str,
        threat_intelligence_replace_tags: Union[_models.ThreatIntelligenceIndicatorModel, IO],
        **kwargs: Any
    ) -> _models.ThreatIntelligenceInformation:
        """Replace tags added to a threat intelligence indicator.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param name: Threat intelligence indicator name field. Required.
        :type name: str
        :param threat_intelligence_replace_tags: Tags in the threat intelligence indicator to be
         replaced. Is either a model type or a IO type. Required.
        :type threat_intelligence_replace_tags:
         ~azure.mgmt.securityinsight.models.ThreatIntelligenceIndicatorModel or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ThreatIntelligenceInformation or the result of cls(response)
        :rtype: ~azure.mgmt.securityinsight.models.ThreatIntelligenceInformation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ThreatIntelligenceInformation]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(threat_intelligence_replace_tags, (IO, bytes)):
            _content = threat_intelligence_replace_tags
        else:
            _json = self._serialize.body(threat_intelligence_replace_tags, "ThreatIntelligenceIndicatorModel")

        request = build_replace_tags_request(
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.replace_tags.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ThreatIntelligenceInformation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    replace_tags.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/threatIntelligence/main/indicators/{name}/replaceTags"}  # type: ignore
