/* Copyright 2019 IBM Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __LIBCRONUS_INSTRUCTION_H__
#define __LIBCRONUS_INSTRUCTION_H__

/* Instruction types */
#define INSTRUCTION_TYPE_NOINSTRUCTION	0
#define INSTRUCTION_TYPE_FSI		1
#define INSTRUCTION_TYPE_JTAG		2
#define INSTRUCTION_TYPE_MULTIPLEJTAG	3
#define INSTRUCTION_TYPE_PSI		4
#define INSTRUCTION_TYPE_GPIO		5
#define INSTRUCTION_TYPE_I2C		6
#define INSTRUCTION_TYPE_VPD		7
#define INSTRUCTION_TYPE_DMA		8
#define INSTRUCTION_TYPE_CONTORL	9
#define INSTRUCTION_TYPE_DMAEXER	10
#define INSTRUCTION_TYPE_POWR		11
#define INSTRUCTION_TYPE_FSISTREAM	12
#define INSTRUCTION_TYPE_SBEFIFO	13
#define INSTRUCTION_TYPE_GSD2PIB	14
#define INSTRUCTION_TYPE_FSIMEMPROC	15
#define INSTRUCTION_TYPE_PNOR		16
#define INSTRUCTION_TYPE_D2C		17

/* Instruction commands */
#define INSTRUCTION_CMD_NOCOMMAND		0
#define INSTRUCTION_CMD_SENDCMD			1
#define INSTRUCTION_CMD_READ			2
#define INSTRUCTION_CMD_WRITE			3
#define INSTRUCTION_CMD_LONGIN			4
#define INSTRUCTION_CMD_LONGOUT			5
#define INSTRUCTION_CMD_READ_WRITE		6
#define INSTRUCTION_CMD_SHIFTOUT		7
#define INSTRUCTION_CMD_DMAIN			8
#define INSTRUCTION_CMD_DMAOUT			9
#define INSTRUCTION_CMD_MISC			10
#define INSTRUCTION_CMD_TOTAP			11
#define INSTRUCTION_CMD_READVPD			12
#define INSTRUCTION_CMD_READSPMEM		13
#define INSTRUCTION_CMD_WRITESPMEM		14
#define INSTRUCTION_CMD_SCOMIN			15
#define INSTRUCTION_CMD_SCOMOUT			16
#define INSTRUCTION_CMD_WRITEVPD		17
#define INSTRUCTION_CMD_PSI_RESET		18
#define INSTRUCTION_CMD_PSI_LINK_CALIB		19
#define INSTRUCTION_CMD_PSI_EI_REG_READ		20
#define INSTRUCTION_CMD_PSI_EI_REG_WRITE	21
#define INSTRUCTION_CMD_PSI_VERIFY		22
#define INSTRUCTION_CMD_PSI_SCOM_READ		23
#define INSTRUCTION_CMD_PSI_SCOM_WRITE		24
#define INSTRUCTION_CMD_PSI_READ		25
#define INSTRUCTION_CMD_PSI_WRITE		26
#define INSTRUCTION_CMD_PSI_INIT		27
#define INSTRUCTION_CMD_PSI_LINK_ENABLE		28
#define INSTRUCTION_CMD_PSI_SET_SPEED		29
#define INSTRUCTION_CMD_PSI_LINK_VERIFY		30
#define INSTRUCTION_CMD_I2CWRITE		31
#define INSTRUCTION_CMD_I2READ			32
#define INSTRUCTION_CMD_GPIO_CONFIGPIN		33
#define INSTRUCTION_CMD_GPIO_READPIN		34
#define INSTRUCTION_CMD_GPIO_READPINS		35
#define INSTRUCTION_CMD_GPIO_READLATCH		36
#define INSTRUCTION_CMD_GPIO_WRITELATCH		37
#define INSTRUCTION_CMD_GPIO_WRITELATCHES	38
#define INSTRUCTION_CMD_GPIO_READCONFIG		39
#define INSTRUCTION_CMD_GPIO_WRITECONFIG	40
#define INSTRUCTION_CMD_GPIO_WRITECNFGSET	41
#define INSTRUCTION_CMD_GPIO_WRITECNFGCLR	42
#define INSTRUCTION_CMD_DMAEXER_START		43
#define INSTRUCTION_CMD_DMAEXER_REPORT		44
#define INSTRUCTION_CMD_DMAEXER_STOP		45
#define INSTRUCTION_CMD_INFO			46
#define INSTRUCTION_CMD_RUN_CMD			47
#define INSTRUCTION_CMD_MULTI_ENALBE		48
#define INSTRUCTION_CMD_AUTH			49
#define INSTRUCTION_CMD_ADDAUTH			50
#define INSTRUCTION_CMD_CLEARAUTH		51
#define INSTRUCTION_CMD_VERSION			52
#define INSTRUCTION_CMD_FLIGHTRECORDER		53
#define INSTRUCTION_CMD_EXIT			54
#define INSTRUCTION_CMD_SCOMIN_MASK		55
#define INSTRUCTION_CMD_MASK_PERSISTENT		56
#define INSTRUCTION_CMD_SET_PERSISTENT		57
#define INSTRUCTION_CMD_GET_PERSISTENT		58
#define INSTRUCTION_CMD_READKEYWORD		59
#define INSTRUCTION_CMD_WRITEKEYWORD		60
#define INSTRUCTION_CMD_FRUSTATUS		61
#define INSTRUCTION_CMD_CHICDOIPL		62
#define INSTRUCTION_CMD_ENABLE_MEM_VOLTAGES	63
#define INSTRUCTION_CMD_DISABLE_MEM_VOLTAGES	64
#define INSTRUCTION_CMD_SNDISTEPMSG		65
#define INSTRUCTION_CMD_MBXTRACEENABLE		66
#define INSTRUCTION_CMD_MBXTRACEDISABLE		67
#define INSTRUCTION_CMD_MBXTRACEREAD		68
#define INSTRUCTION_CMD_PUTMEMPBA		69
#define INSTRUCTION_CMD_GETMEMPBA		70
#define INSTRUCTION_CMD_BULK_SCOMOUT		71
#define INSTRUCTION_CMD_BULK_SCOMIN		72
#define INSTRUCTION_CMD_STREAM_SETUP		73
#define INSTRUCTION_CMD_STREAM_FINISH		74
#define INSTRUCTION_CMD_FSPDMAIN		75
#define INSTRUCTION_CMD_FSPDMAOUT		76
#define INSTRUCTION_CMD_SUBMIT			77
#define INSTRUCTION_CMD_REQUEST_RESET		78
#define INSTRUCTION_CMD_SEND_TAPI_CMD		79
#define INSTRUCTION_CMD_PUTMEMPROC		80
#define INSTRUCTION_CMD_GETMEMPROC		81
#define INSTRUCTION_CMD_PNORGETLIST		82
#define INSTRUCTION_CMD_PNORGET			83
#define INSTRUCTION_CMD_PNORPUT			84
#define INSTRUCTION_CMD_QUERYSP			85
#define INSTRUCTION_CMD_ADJUST_PROC_VOLTAGES	86
#define INSTRUCTION_CMD_I2CRESETLIGHT		87
#define INSTRUCTION_CMD_I2CRESETFULL		88
#define INSTRUCTION_CMD_PSI_CMU_REG_READ	89
#define INSTRUCTION_CMD_PSI_CMU_REG_WRITE	90
#define INSTRUCTION_CMD_GETFILE			91

/* Instruction flags */
#define INSTRUCTION_FLAG_DEBUG                  0x80000000
#define INSTRUCTION_FLAG_NOEXECUTE              0x40000000
#define INSTRUCTION_FLAG_SERVER_DEBUG           0x20000000
#define INSTRUCTION_FLAG_PERFORMANCE            0x10000000
#define INSTRUCTION_FLAG_CRC_ENABLE             0x08000000
#define INSTRUCTION_FLAG_32BIT_CRC              0x04000000
#define INSTRUCTION_FLAG_16BIT_CRC              0x02000000
#define INSTRUCTION_FLAG_PERSISTENT_DATA        0x01000000
#define INSTRUCTION_FLAG_FSI_SCANHEADERCHECK    0x00800000
#define INSTRUCTION_FLAG_FSI_SCANSETPULSE       0x00400000
#define INSTRUCTION_FLAG_FSI_USE_DRA            0x00200000
#define INSTRUCTION_FLAG_FSI_SCANEXTRABCLOCK    0x00100000
#define INSTRUCTION_FLAG_FSI_SCANVIAPIB         0x00080000
#define INSTRUCTION_FLAG_FSI_CFAM2_0            0x00040000
#define INSTRUCTION_FLAG_64BIT_ADDRESS          0x00008000
#define INSTRUCTION_FLAG_DEVSTR                 0x00004000
#define INSTRUCTION_FLAG_CFAM_MAILBOX           0x00002000
#define INSTRUCTION_FLAG_CACHE_INHIBITED        0x00001000
#define INSTRUCTION_FLAG_SBEFIFO_RESET_ENABLE   0x00000800
#define INSTRUCTION_FLAG_POWR_DDR4              0x00000400
#define INSTRUCTION_FLAG_NO_PIB_RESET           0x00000200

/* Result types */
#define RESULT_TYPE_ECMD_DBUF		0
#define RESULT_TYPE_INSTRUCTION_STATUS	1

/* Error codes */
#define ECMD_ERR_CRONUS                         0x02000000 ///< Error came from Cronus

#define SERVER_COMMAND_COMPLETE                 (ECMD_ERR_CRONUS | 0x402000)


#endif /* __LIBCRONUS_INSTRUCTION_H__ */
