// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ProteinDataBankPluginInfo.C
// ****************************************************************************

#include <ProteinDataBankPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(ProteinDataBank,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(ProteinDataBank,General)

// ****************************************************************************
//  Method: ProteinDataBankGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ProteinDataBankGeneralPluginInfo::GetName() const
{
    return "ProteinDataBank";
}

// ****************************************************************************
//  Method: ProteinDataBankGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ProteinDataBankGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: ProteinDataBankGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ProteinDataBankGeneralPluginInfo::GetID() const
{
    return "ProteinDataBank_1.0";
}
// ****************************************************************************
//  Method: ProteinDataBankGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ProteinDataBankGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: ProteinDataBankGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ProteinDataBankGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  ProteinDataBankGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a ProteinDataBank database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
ProteinDataBankGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.ent");
    defaultPatterns.push_back("*.pdb");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  ProteinDataBankGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a ProteinDataBank database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
ProteinDataBankGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  ProteinDataBankGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the ProteinDataBank plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
ProteinDataBankGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
