/***************************** LICENSE START ***********************************

 Copyright 2013 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQEditor_H
#define MvQEditor_H

#include <QDialog>
#include <QLabel>
#include <QSettings>

#include "Editor.h"

class QAbstractButton;
class QAction;
class QActionGroup;
class QDialogButtonBox;
class QDrag;
class QHBoxLayout;
class QLabel;
class QLineEdit;
class QPlainTextEdit;
class QPushButton;
class QStackedLayout;
class QStackedWidget;
class QToolBar;
class QToolButton;
class QVBoxLayout;

class MvQDrawerPanel;
class MvQFolderModel;
class MvQIconTemplateView;

class MvQEditor;

class MvQEditorDragLabel : public QLabel
{
     Q_OBJECT
public:
    MvQEditorDragLabel(QPixmap, int, QWidget* parent=nullptr);
    void setIconObject(IconObject*);

signals:
    void dragStarted();

protected:
    void enterEvent(QEvent*);
    void leaveEvent(QEvent*);
    void mousePressEvent(QMouseEvent*);
    void mouseMoveEvent(QMouseEvent*);
    void performDrag(Qt::DropAction, QPoint);
    QDrag* buildDrag(IconObject* dragObj, QPoint dragPos);

    IconObject *obj_;
    bool canDrag_;
    QPoint startPos_;
    QPixmap oriPix_;
    QPixmap highlightPix_;
};

class MvQEditorHeader : public QWidget
{
    Q_OBJECT

public:
    MvQEditorHeader(MvQEditor*, QPixmap);
    void updateLabel(IconObject*);
    void lock(bool);

public slots:
    void slotStartEdit(bool);
    void slotAcceptEdit(bool);
    void slotCancelEdit(bool);

protected:
    void paintEvent(QPaintEvent*);

    MvQEditor* owner_;
    QStackedLayout* stackLayout_;
    QLabel* label_;
    QToolButton* renameTb_;
    QLineEdit* edit_;
    IconObject* obj_;
    MvQEditorDragLabel* pixLabel_;
};

class MvQEditorTextPanel : public QWidget
{
    Q_OBJECT

public:
    MvQEditorTextPanel(const IconClass&, Editor*, QWidget*);
    bool check(bool fromSave = true);
    void setObject(IconObject*);
    void save();
    void load();

public slots:
    void slotTextChanged();

protected:
    void loadRequestFile();

    const IconClass& class_;
    Editor* owner_;
    IconObject* current_;
    QPlainTextEdit* te_;
    QLabel* warnLabel_;
    QLabel* msgLabel_;
    bool correct_;
    bool beingLoaded_;
};

class MvQEditor : public QDialog, public Editor
{
    Q_OBJECT

public:
    MvQEditor(const IconClass& name, const string& kind, QWidget* parent = 0);
    ~MvQEditor();

    void changed();
    virtual void merge(IconObjectH)   = 0;
    virtual void replace(IconObjectH) = 0;
    void rename(QString);

    //Observer method
    void iconChanged(IconObject*);

public slots:
    void slotChangeView(QAction*);
    void slotButtonClicked(QAbstractButton*);
    void accept();
    void reject();
    void slotTextChanged();

protected slots:
    virtual void slotFilterItems(QString) = 0;
    virtual void slotShowDisabled(bool) = 0;
    void save();

protected:
    enum ViewMode
    {
        LineViewMode = 0,
        TextViewMode = 1
    };

    bool eventFilter(QObject *obj, QEvent * event);
    void setupShowDisabledActions();
    void setupLineFilter();
    void updateFilterCountLabel();
    virtual int filterNonMatchCount() {return 0;}
    bool showDisabled() const;

    void addToToolBar(QList<QAction*>);
    void raiseIt();
    void showIt();
    void closeIt();
    virtual void apply() = 0;
    virtual void reset() = 0;
    virtual void close() = 0;
    virtual void edit();
    virtual void temporary();
    void closeEvent(QCloseEvent*);
    void readSettings();
    void writeSettings();
    virtual void readSettings(QSettings&)  = 0;
    virtual void writeSettings(QSettings&) = 0;

    bool isTextMode();

    QLabel* headerLabel_;
    QLineEdit* headerEdit_;
    MvQEditorHeader* headerPanel_;
    //QToolButton* viewTb_;
    QAction* showDisabledAc_;
    QLineEdit* filterLe_{nullptr};
    QLabel* filterCountLabel_{nullptr};
    QAction* sepAc_;
    QAction* guiAc_;
    QAction* textAc_;
    QActionGroup* viewAg_;

    QVBoxLayout* centralLayout_;

    QDialogButtonBox* buttonBox_;
    QPushButton* savePb_;
    QPushButton* okPb_;
    QPushButton* cancelPb_;
    QPushButton* resetPb_;

    QStackedWidget* viewSw_;
    MvQDrawerPanel* drawerPanel_;
    bool drawerFilled_;
    QToolBar* toolbarLeft_;
    QToolBar* toolbarRight_;
    MvQEditorTextPanel* textPanel_;

private:
    void updateWindowTitle();

    QHBoxLayout* toolBarLayout_;
    bool ignoreChange_;
};

#endif
