/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.java.hints.bugs;

import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.java.hints.test.api.HintTest;

/**
 *
 * @author lahvac
 */
public class AnnotationsNotRuntimeTest extends NbTestCase {

    public AnnotationsNotRuntimeTest(String name) {
        super(name);
    }

    public void testSimple1() throws Exception {
        HintTest
                .create()
                .input("package test;\n" +
                       "public class Test {\n" +
                       "    private void test() {\n" +
                       "        Test.class.isAnnotationPresent(SuppressWarnings.class);\n" +
                       "    }\n" +
                       "}")
                .run(AnnotationsNotRuntime.class)
                .assertWarnings("3:39-3:55:verifier:java.lang.SuppressWarnings isAnnotationPresent");
    }

    public void testSimple2() throws Exception {
        HintTest
                .create()
                .input("package test;\n" +
                       "public class Test {\n" +
                       "    private void test() {\n" +
                       "        Test.class.isAnnotationPresent(AA.class);\n" +
                       "    }\n" +
                       "}\n" +
                       "@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.RUNTIME)" +
                       "@interface AA{}\n")
                .run(AnnotationsNotRuntime.class)
                .assertWarnings();
    }

    public void testSimple3() throws Exception {
        HintTest
                .create()
                .input("package test;\n" +
                       "public class Test {\n" +
                       "    private void test() {\n" +
                       "        Test.class.getAnnotation(SuppressWarnings.class);\n" +
                       "    }\n" +
                       "}")
                .run(AnnotationsNotRuntime.class)
                .assertWarnings("3:33-3:49:verifier:java.lang.SuppressWarnings getAnnotation");
    }

    public void testSimple4() throws Exception {
        HintTest
                .create()
                .input("package test;\n" +
                       "public class Test {\n" +
                       "    private void test() {\n" +
                       "        Test.class.getAnnotation(AA.class);\n" +
                       "    }\n" +
                       "}\n" +
                       "@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.RUNTIME)" +
                       "@interface AA{}\n")
                .run(AnnotationsNotRuntime.class)
                .assertWarnings();
    }

    public void testSimple5() throws Exception {
        HintTest
                .create()
                .input("package test;\n" +
                       "public class Test {\n" +
                       "    private void test(java.lang.annotation.Annotation ann) {\n" +
                       "        if (ann instanceof SuppressWarnings);\n" +
                       "    }\n" +
                       "}\n")
                .run(AnnotationsNotRuntime.class)
                .assertWarnings("3:27-3:43:verifier:java.lang.SuppressWarnings instanceof");
    }
}