; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -O1 -S < %s | FileCheck %s
; RUN: opt -O2 -S < %s | FileCheck %s
; RUN: opt -O3 -S < %s | FileCheck %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

; int two_shifts_by_sext(int val, char len) {
;   return (val << len) >> len;
; }
;
; int two_shifts_by_same_sext(int val, char len) {
;   int wide_len = len;
;   return (val << wide_len) >> wide_len;
; }
;
; void use_int32(int);
; int two_shifts_by_sext_with_extra_use(int val, char len) {
;   use_int32(len);
;   return (val << len) >> len;
; }
;
; int two_shifts_by_same_sext_with_extra_use(int val, char len) {
;   int wide_len = len;
;   use_int32(wide_len);
;   return (val << wide_len) >> wide_len;
; }

define i32 @two_shifts_by_sext(i32 %val, i8 signext %len) {
; CHECK-LABEL: @two_shifts_by_sext(
; CHECK-NEXT:    [[CONV:%.*]] = sext i8 [[LEN:%.*]] to i32
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[VAL:%.*]], [[CONV]]
; CHECK-NEXT:    [[SHR:%.*]] = ashr i32 [[SHL]], [[CONV]]
; CHECK-NEXT:    ret i32 [[SHR]]
;
  %val.addr = alloca i32, align 4
  %len.addr = alloca i8, align 1
  store i32 %val, ptr %val.addr, align 4
  store i8 %len, ptr %len.addr, align 1
  %val.reloaded = load i32, ptr %val.addr, align 4
  %len.reloaded.0 = load i8, ptr %len.addr, align 1
  %conv = sext i8 %len.reloaded.0 to i32
  %shl = shl i32 %val.reloaded, %conv
  %len.reloaded.1 = load i8, ptr %len.addr, align 1
  %conv1 = sext i8 %len.reloaded.1 to i32
  %shr = ashr i32 %shl, %conv1
  ret i32 %shr
}

define i32 @two_shifts_by_same_sext(i32 %val, i8 signext %len) {
; CHECK-LABEL: @two_shifts_by_same_sext(
; CHECK-NEXT:    [[CONV:%.*]] = sext i8 [[LEN:%.*]] to i32
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[VAL:%.*]], [[CONV]]
; CHECK-NEXT:    [[SHR:%.*]] = ashr i32 [[SHL]], [[CONV]]
; CHECK-NEXT:    ret i32 [[SHR]]
;
  %val.addr = alloca i32, align 4
  %len.addr = alloca i8, align 1
  %wide_len = alloca i32, align 4
  store i32 %val, ptr %val.addr, align 4
  store i8 %len, ptr %len.addr, align 1
  %len.reloaded.0 = load i8, ptr %len.addr, align 1
  %conv = sext i8 %len.reloaded.0 to i32
  store i32 %conv, ptr %wide_len, align 4
  %val.reloaded = load i32, ptr %val.addr, align 4
  %len.reloaded.1 = load i32, ptr %wide_len, align 4
  %shl = shl i32 %val.reloaded, %len.reloaded.1
  %len.reloaded.2 = load i32, ptr %wide_len, align 4
  %shr = ashr i32 %shl, %len.reloaded.2
  ret i32 %shr
}

define i32 @two_shifts_by_sext_with_extra_use(i32 %val, i8 signext %len) {
; CHECK-LABEL: @two_shifts_by_sext_with_extra_use(
; CHECK-NEXT:    [[CONV:%.*]] = sext i8 [[LEN:%.*]] to i32
; CHECK-NEXT:    call void @use_int32(i32 [[CONV]])
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[VAL:%.*]], [[CONV]]
; CHECK-NEXT:    [[SHR:%.*]] = ashr i32 [[SHL]], [[CONV]]
; CHECK-NEXT:    ret i32 [[SHR]]
;
  %val.addr = alloca i32, align 4
  %len.addr = alloca i8, align 1
  store i32 %val, ptr %val.addr, align 4
  store i8 %len, ptr %len.addr, align 1
  %len.reloaded.0 = load i8, ptr %len.addr, align 1
  %conv = sext i8 %len.reloaded.0 to i32
  call void @use_int32(i32 %conv)
  %val.reloaded = load i32, ptr %val.addr, align 4
  %len.reloaded.1 = load i8, ptr %len.addr, align 1
  %conv1 = sext i8 %len.reloaded.1 to i32
  %shl = shl i32 %val.reloaded, %conv1
  %len.reloaded.2 = load i8, ptr %len.addr, align 1
  %conv2 = sext i8 %len.reloaded.2 to i32
  %shr = ashr i32 %shl, %conv2
  ret i32 %shr
}

declare void @use_int32(i32)

define i32 @two_shifts_by_same_sext_with_extra_use(i32 %val, i8 signext %len) {
; CHECK-LABEL: @two_shifts_by_same_sext_with_extra_use(
; CHECK-NEXT:    [[CONV:%.*]] = sext i8 [[LEN:%.*]] to i32
; CHECK-NEXT:    call void @use_int32(i32 [[CONV]])
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[VAL:%.*]], [[CONV]]
; CHECK-NEXT:    [[SHR:%.*]] = ashr i32 [[SHL]], [[CONV]]
; CHECK-NEXT:    ret i32 [[SHR]]
;
  %val.addr = alloca i32, align 4
  %len.addr = alloca i8, align 1
  %wide_len = alloca i32, align 4
  store i32 %val, ptr %val.addr, align 4
  store i8 %len, ptr %len.addr, align 1
  %len.reloaded.0 = load i8, ptr %len.addr, align 1
  %conv = sext i8 %len.reloaded.0 to i32
  store i32 %conv, ptr %wide_len, align 4
  %val.reloaded = load i32, ptr %wide_len, align 4
  call void @use_int32(i32 %val.reloaded)
  %len.reloaded.1 = load i32, ptr %val.addr, align 4
  %len.reloaded.2 = load i32, ptr %wide_len, align 4
  %shl = shl i32 %len.reloaded.1, %len.reloaded.2
  %wide_len.reloaded = load i32, ptr %wide_len, align 4
  %shr = ashr i32 %shl, %wide_len.reloaded
  ret i32 %shr
}
