; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; Test that the wcslen library call simplifier works correctly.
;
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

target datalayout = "e-m:o-i64:64-f80:128-n8:16:32:64-S128"

declare i64 @wcslen(ptr)

!0 = !{i32 1, !"wchar_size", i32 4}
!llvm.module.flags = !{!0}

@hello = constant [6 x i32] [i32 104, i32 101, i32 108, i32 108, i32 111, i32 0]
@longer = constant [7 x i32] [i32 108, i32 111, i32 110, i32 103, i32 101, i32 114, i32 0]
@null = constant [1 x i32] zeroinitializer
@null_hello = constant [7 x i32] [i32 0, i32 104, i32 101, i32 108, i32 108, i32 111, i32 0]
@nullstring = constant i32 0
@a = common global [32 x i32] zeroinitializer, align 1
@null_hello_mid = constant [13 x i32] [i32 104, i32 101, i32 108, i32 108, i32 111, i32 32, i32 119, i32 111, i32 114, i32 0, i32 108, i32 100, i32 0]

define i64 @test_simplify1() {
; CHECK-LABEL: @test_simplify1(
; CHECK-NEXT:    ret i64 5
;
  %hello_l = call i64 @wcslen(ptr @hello)
  ret i64 %hello_l
}

define i64 @test_simplify2() {
; CHECK-LABEL: @test_simplify2(
; CHECK-NEXT:    ret i64 0
;
  %null_l = call i64 @wcslen(ptr @null)
  ret i64 %null_l
}

define i64 @test_simplify3() {
; CHECK-LABEL: @test_simplify3(
; CHECK-NEXT:    ret i64 0
;
  %null_hello_l = call i64 @wcslen(ptr @null_hello)
  ret i64 %null_hello_l
}

define i64 @test_simplify4() {
; CHECK-LABEL: @test_simplify4(
; CHECK-NEXT:    ret i64 0
;
  %len = tail call i64 @wcslen(ptr @nullstring) nounwind
  ret i64 %len
}

; Check wcslen(x) == 0 --> *x == 0.

define i1 @test_simplify5() {
; CHECK-LABEL: @test_simplify5(
; CHECK-NEXT:    ret i1 false
;
  %hello_l = call i64 @wcslen(ptr @hello)
  %eq_hello = icmp eq i64 %hello_l, 0
  ret i1 %eq_hello
}

define i1 @test_simplify6(ptr %str_p) {
; CHECK-LABEL: @test_simplify6(
; CHECK-NEXT:    [[CHAR0:%.*]] = load i32, ptr [[STR_P:%.*]], align 4
; CHECK-NEXT:    [[EQ_NULL:%.*]] = icmp eq i32 [[CHAR0]], 0
; CHECK-NEXT:    ret i1 [[EQ_NULL]]
;
  %str_l = call i64 @wcslen(ptr %str_p)
  %eq_null = icmp eq i64 %str_l, 0
  ret i1 %eq_null
}

; Check wcslen(x) != 0 --> *x != 0.

define i1 @test_simplify7() {
; CHECK-LABEL: @test_simplify7(
; CHECK-NEXT:    ret i1 true
;
  %hello_l = call i64 @wcslen(ptr @hello)
  %ne_hello = icmp ne i64 %hello_l, 0
  ret i1 %ne_hello
}

define i1 @test_simplify8(ptr %str_p) {
; CHECK-LABEL: @test_simplify8(
; CHECK-NEXT:    [[CHAR0:%.*]] = load i32, ptr [[STR_P:%.*]], align 4
; CHECK-NEXT:    [[NE_NULL:%.*]] = icmp ne i32 [[CHAR0]], 0
; CHECK-NEXT:    ret i1 [[NE_NULL]]
;
  %str_l = call i64 @wcslen(ptr %str_p)
  %ne_null = icmp ne i64 %str_l, 0
  ret i1 %ne_null
}

define i64 @test_simplify9(i1 %x) {
; CHECK-LABEL: @test_simplify9(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[X:%.*]], i64 5, i64 6
; CHECK-NEXT:    ret i64 [[TMP1]]
;
  %s = select i1 %x, ptr @hello, ptr @longer
  %l = call i64 @wcslen(ptr %s)
  ret i64 %l
}

; Check the case that should be simplified to a sub instruction.
; wcslen(@hello + x) --> 5 - x

define i64 @test_simplify10(i32 %x) {
; CHECK-LABEL: @test_simplify10(
; CHECK-NEXT:    [[TMP1:%.*]] = sext i32 [[X:%.*]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = sub nsw i64 5, [[TMP1]]
; CHECK-NEXT:    ret i64 [[TMP2]]
;
  %hello_p = getelementptr inbounds [6 x i32], ptr @hello, i32 0, i32 %x
  %hello_l = call i64 @wcslen(ptr %hello_p)
  ret i64 %hello_l
}

; wcslen(@null_hello_mid + (x & 7)) --> 9 - (x & 7)

define i64 @test_simplify11(i32 %x) {
; CHECK-LABEL: @test_simplify11(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 7
; CHECK-NEXT:    [[NARROW:%.*]] = sub nuw nsw i32 9, [[AND]]
; CHECK-NEXT:    [[TMP1:%.*]] = zext i32 [[NARROW]] to i64
; CHECK-NEXT:    ret i64 [[TMP1]]
;
  %and = and i32 %x, 7
  %hello_p = getelementptr inbounds [13 x i32], ptr @null_hello_mid, i32 0, i32 %and
  %hello_l = call i64 @wcslen(ptr %hello_p)
  ret i64 %hello_l
}

; Check cases that shouldn't be simplified.

define i64 @test_no_simplify1() {
; CHECK-LABEL: @test_no_simplify1(
; CHECK-NEXT:    [[A_L:%.*]] = call i64 @wcslen(ptr nonnull @a)
; CHECK-NEXT:    ret i64 [[A_L]]
;
  %a_l = call i64 @wcslen(ptr @a)
  ret i64 %a_l
}

; wcslen(@null_hello + x) should not be simplified to a sub instruction.

define i64 @test_no_simplify2(i32 %x) {
; CHECK-LABEL: @test_no_simplify2(
; CHECK-NEXT:    [[TMP1:%.*]] = sext i32 [[X:%.*]] to i64
; CHECK-NEXT:    [[HELLO_P:%.*]] = getelementptr inbounds [7 x i32], ptr @null_hello, i64 0, i64 [[TMP1]]
; CHECK-NEXT:    [[HELLO_L:%.*]] = call i64 @wcslen(ptr nonnull [[HELLO_P]])
; CHECK-NEXT:    ret i64 [[HELLO_L]]
;
  %hello_p = getelementptr inbounds [7 x i32], ptr @null_hello, i32 0, i32 %x
  %hello_l = call i64 @wcslen(ptr %hello_p)
  ret i64 %hello_l
}

define i64 @test_no_simplify2_no_null_opt(i32 %x) #0 {
; CHECK-LABEL: @test_no_simplify2_no_null_opt(
; CHECK-NEXT:    [[TMP1:%.*]] = sext i32 [[X:%.*]] to i64
; CHECK-NEXT:    [[HELLO_P:%.*]] = getelementptr inbounds [7 x i32], ptr @null_hello, i64 0, i64 [[TMP1]]
; CHECK-NEXT:    [[HELLO_L:%.*]] = call i64 @wcslen(ptr [[HELLO_P]])
; CHECK-NEXT:    ret i64 [[HELLO_L]]
;
  %hello_p = getelementptr inbounds [7 x i32], ptr @null_hello, i32 0, i32 %x
  %hello_l = call i64 @wcslen(ptr %hello_p)
  ret i64 %hello_l
}

; wcslen(@null_hello_mid + (x & 15)) should not be simplified to a sub instruction.

define i64 @test_no_simplify3(i32 %x) {
; CHECK-LABEL: @test_no_simplify3(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[TMP1:%.*]] = zext i32 [[AND]] to i64
; CHECK-NEXT:    [[HELLO_P:%.*]] = getelementptr inbounds [13 x i32], ptr @null_hello_mid, i64 0, i64 [[TMP1]]
; CHECK-NEXT:    [[HELLO_L:%.*]] = call i64 @wcslen(ptr nonnull [[HELLO_P]])
; CHECK-NEXT:    ret i64 [[HELLO_L]]
;
  %and = and i32 %x, 15
  %hello_p = getelementptr inbounds [13 x i32], ptr @null_hello_mid, i32 0, i32 %and
  %hello_l = call i64 @wcslen(ptr %hello_p)
  ret i64 %hello_l
}

define i64 @test_no_simplify3_no_null_opt(i32 %x) #0 {
; CHECK-LABEL: @test_no_simplify3_no_null_opt(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 15
; CHECK-NEXT:    [[TMP1:%.*]] = zext i32 [[AND]] to i64
; CHECK-NEXT:    [[HELLO_P:%.*]] = getelementptr inbounds [13 x i32], ptr @null_hello_mid, i64 0, i64 [[TMP1]]
; CHECK-NEXT:    [[HELLO_L:%.*]] = call i64 @wcslen(ptr [[HELLO_P]])
; CHECK-NEXT:    ret i64 [[HELLO_L]]
;
  %and = and i32 %x, 15
  %hello_p = getelementptr inbounds [13 x i32], ptr @null_hello_mid, i32 0, i32 %and
  %hello_l = call i64 @wcslen(ptr %hello_p)
  ret i64 %hello_l
}

@str16 = constant [1 x i16] [i16 0]

; Fold the invalid call to zero.  This is safer than letting the undefined
; library call take place even though it prevents sanitizers from detecting
; it.

define i64 @test_simplify12() {
; CHECK-LABEL: @test_simplify12(
; CHECK-NEXT:    ret i64 0
;
  %l = call i64 @wcslen(ptr @str16)
  ret i64 %l
}

@ws = constant [10 x i32] [i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0]

; Fold wcslen(ws + 2) => 7.
define i64 @fold_wcslen_1() {
; CHECK-LABEL: @fold_wcslen_1(
; CHECK-NEXT:    ret i64 7
;
  %p = getelementptr inbounds [10 x i32], ptr @ws, i64 0, i64 2
  %len = tail call i64 @wcslen(ptr %p)
  ret i64 %len
}

; Should not crash on this, and no optimization expected (idea is to get into
; llvm::getConstantDataArrayInfo looking for an array with 32-bit elements but
; with an offset that isn't a multiple of the element size).
define i64 @no_fold_wcslen_1() {
; CHECK-LABEL: @no_fold_wcslen_1(
; CHECK-NEXT:    %len = tail call i64 @wcslen(ptr nonnull getelementptr inbounds ([15 x i8], ptr @ws, i64 0, i64 3))
; CHECK-NEXT:    ret i64 %len
;
  %p = getelementptr [15 x i8], ptr @ws, i64 0, i64 3
  %len = tail call i64 @wcslen(ptr %p)
  ret i64 %len
}

@s8 = constant [10 x i8] [i8 9, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0]

; Should not crash on this, and no optimization expected (idea is to get into
; llvm::getConstantDataArrayInfo looking for an array with 32-bit elements but
; with an offset that isn't a multiple of the element size).
define i64 @no_fold_wcslen_2() {
; CHECK-LABEL: @no_fold_wcslen_2(
; CHECK-NEXT:    %len = tail call i64 @wcslen(ptr nonnull getelementptr inbounds ([10 x i8], ptr @s8, i64 0, i64 3))
; CHECK-NEXT:    ret i64 %len
;
  %p = getelementptr [10 x i8], ptr @s8, i64 0, i64 3
  %len = tail call i64 @wcslen(ptr %p)
  ret i64 %len
}

attributes #0 = { null_pointer_is_valid }
