Relevant KLayout version: 0.25.2

# 1. Introduction
This directory "macbuild" contains different files required for building KLayout (http://www.klayout.de/) version 0.25 or later for different 64-bit Mac OSXs including:
* Yosemite    (10.10)
* El Capitan  (10.11)
* Sierra      (10.12)
* High Sierra (10.13)

By default, Qt framework is "Qt5" from MacPorts (https://www.macports.org/) which is usually located under:
```
/opt/local/libexec/qt5/
```

Alternatively, you can use "Qt5" from Homebrew (https://brew.sh/) which is usually located under:
```
/usr/local/opt/qt/
```
Please refer to Section # 5. of this document regarding use of Homebrew.

KLayout 0.25.2 was successfully built with "Qt 5.10.0" from MacPorts and "Qt 5.10.1" from Homebrew.

### IMPORTANT
```
* Please DO NOT USE "Qt 4.x" which is problematic in compilation.
```

Also by default, supported script languages, i.e, Ruby and Python, are those standard ones bundled with the OS.

# 2. Non-OS-standard script language support
You may want to use a non-OS-standard script language such as Python 3.6 from Anaconda2 (https://www.anaconda.com/download/#macos) in combination with KLayout.

Since Anaconda2 is a popular Python development environment, this is worth trying. Unfortunately, however, some dynamic linkage problems are observed as of today. 
On the other hand, Python 3.7 provided by MacPorts or Homebrew is usable.
Please try this (refer to 3B below or Section #5) if you feel it's useful.

# 3. Use-cases
### 3A. Debug build using the OS-standard script languages
1. Make a symbolic link (if it does not exist) from the parent directory (where 'build.sh' exists) to 'build4mac.py', that is,
```
  build4mac.py -> macbuild/build4mac.py
```
2. Invoke 'build4mac.py' with appropriate options ("-d" for debug build):
``` 
$ cd /where/'build.sh'/exists
$ ./build4mac.py -d
```
3. Confirm successful build (it will take about one hour).
4. Run 'build4mac.py' again with the same options used in 2. PLUS "-y" to deploy executables and libraries (including Qt's frameworks) under "klayout.app" bundle. The buddy command line tools (strm*) will also be deployed in this step.
```
$ ./build4mac.py -d -y
```
5. Copy/move generated bundles ("klayout.app" and "klayout.scripts/") to your "/Applications" directory for installation.

### 3B. Release build using the non-OS-standard Ruby 2.4 and Python 3.6 both from MacPorts
1. Make a symbolic link (if it does not exist) from the parent directory (where 'build.sh' exists) to 'build4mac.py', that is,
```
build4mac.py -> macbuild/build4mac.py
```
2. Invoke 'build4mac.py' with appropriate options:
```
$ cd /where/'build.sh'/exists
$ ./build4mac.py -r mp24 -p mp36
```
3. Confirm successful build (it will take about one hour).
4. Run 'build4mac.py' again with the same options used in 2. PLUS "-Y" to deploy executables and libraries under "klayout.app" bundle. The buddy command line tools (strm*) will also be deployed in this step.
```
$ ./build4mac.py -r mp24 -p mp36 -Y
```
* [-Y|--DEPLOY] option deploys KLayout's dylibs and executables only.
That is, paths to other modules (Ruby, Python, and Qt5 Frameworks) remain unchanged (absolute paths in your development environment).

5. Copy/move generated bundles ("klayout.app" and "klayout.scripts/") to your "/Applications" directory for installation.

----

# 4. Making a DMG installer
You can make a DMG installer using another Python script 'makeDMG4mac.py'.
This script requires a directory generated by 'build4mac.py' with [-y|-Y] option (refer to 3A.4 & 3B.4)

1. Make a symbolic link (if it does not exist) from the parent directory (where 'build.sh' exists) to 'makeDMG4mac.py', that is,
```
makeDMG4mac.py -> macbuild/makeDMG4mac.py
```
2. Invoke 'makeDMG4mac.py' with -p and -m options, for example,
```
$ cd /where/'build.sh'/exists
$ ./makeDMG4mac.py -p qt5.pkg.macos-HighSierra-release -m 
```


# 5. Alternative building options
### 5.1 Python 3.7 from Homebrew, Qt 5.10.1 from Homebrew

Homebrew's installation of python3 (`brew install python3`) places a `Python.framework` in `/usr/local/opt/python/Frameworks/Python.framework/`, which you can use to build KLayout from. Qt can also be downloaded from brew with `brew install qt`.

```
# Build step
./build4mac.py -p B37 -q Qt5Brew
# build with log
./build4mac.py -p B37 -q Qt5Brew 2>&1 | tee qt5.build.macos-HighSierra-release-version.log


# Deploy step
./build4mac.py -p B37 -q Qt5Brew -y  # normal deploy
./build4mac.py -p B37 -q Qt5Brew -y -v 3 2>&1 | tee qt5.pkg.macos-HighSierra-release.log  # deploy with debug options

# Packaging step
./makeDMG4mac.py -p qt5.pkg.macos-HighSierra-release -m -q Qt5101

```

#### Known issues

Because we link python to `/usr/local/opt/python/Frameworks/Python.framework/`, updating python from brew might break KLayout if the new version is incompatible. To fix this, it is better to link python directly to `/usr/local/Cellar/python/3.6.4_4/Frameworks/Python.framework`, but that might complicate release builds, because that assumes users have the exact version of python installed by brew.

[End of File] 
