/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import com.dsi.ant.plugins.antplus.pcc.defines.EventFlag;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.AntPlusLegacyCommonPcc;
import com.dsi.ant.plugins.antplus.pccbase.AsyncScanController;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.internal.compatibility.LegacyHeartRateCompat;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.math.BigDecimal;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPlusHeartRatePcc
extends AntPlusLegacyCommonPcc {
    private static final String TAG = AntPlusHeartRatePcc.class.getSimpleName();
    IHeartRateDataReceiver mHeartRateDataReceiver;
    IPage4AddtDataReceiver mPage4AddtDataReceiver;
    ICalculatedRrIntervalReceiver mCalculatedRrIntervalReceiver;
    LegacyHeartRateCompat mCompat;

    @Override
    protected int getRequiredServiceVersionForBind() {
        return 0;
    }

    public static PccReleaseHandle<AntPlusHeartRatePcc> requestAccess(Activity userActivity, Context bindToContext, boolean skipPreferredSearch, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusHeartRatePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusHeartRatePcc potentialRetObj = new AntPlusHeartRatePcc();
        return AntPlusHeartRatePcc.requestAccess_Helper_SearchActivity(userActivity, bindToContext, skipPreferredSearch, searchProximityThreshold, potentialRetObj, resultReceiver, stateReceiver);
    }

    public static PccReleaseHandle<AntPlusHeartRatePcc> requestAccess(Activity userActivity, Context bindToContext, AntPluginPcc.IPluginAccessResultReceiver<AntPlusHeartRatePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        return AntPlusHeartRatePcc.requestAccess(userActivity, bindToContext, false, -1, resultReceiver, stateReceiver);
    }

    public static PccReleaseHandle<AntPlusHeartRatePcc> requestAccess(Context bindToContext, int antDeviceNumber, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusHeartRatePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusHeartRatePcc potentialRetObj = new AntPlusHeartRatePcc();
        return AntPlusHeartRatePcc.requestAccess_Helper_AsyncSearchByDevNumber(bindToContext, antDeviceNumber, searchProximityThreshold, potentialRetObj, resultReceiver, stateReceiver);
    }

    public static AsyncScanController<AntPlusHeartRatePcc> requestAsyncScanController(Context bindToContext, int searchProximityThreshold, AsyncScanController.IAsyncScanResultReceiver scanResultReceiver) {
        AntPlusHeartRatePcc potentialRetObj = new AntPlusHeartRatePcc();
        return AntPlusHeartRatePcc.requestAccess_Helper_AsyncScanController(bindToContext, searchProximityThreshold, potentialRetObj, scanResultReceiver);
    }

    private AntPlusHeartRatePcc() {
    }

    @Override
    protected Intent getServiceBindIntent() {
        Intent it = new Intent();
        it.setComponent(new ComponentName("com.dsi.ant.plugins.antplus", "com.dsi.ant.plugins.antplus.heartrate.HeartRateService"));
        return it;
    }

    @Override
    protected String getPluginPrintableName() {
        return "ANT+ Plugin: Heart Rate";
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 201: {
                if (this.mHeartRateDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                int computedHeartRate = b.getInt("int_computedHeartRate");
                long heartBeatCounter = b.getLong("long_heartBeatCounter");
                BigDecimal heartBeatEventTime = (BigDecimal)b.getSerializable("decimal_timestampOfLastEvent");
                DataState dataState = b.containsKey("int_dataState") ? DataState.getValueFromInt(b.getInt("int_dataState")) : DataState.LIVE_DATA;
                this.mHeartRateDataReceiver.onNewHeartRateData(estTimestamp, eventFlags, computedHeartRate, heartBeatCounter, heartBeatEventTime, dataState);
                break;
            }
            case 202: {
                if (this.mCompat == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                BigDecimal heartBeatEventTime = (BigDecimal)b.getSerializable("decimal_timestampOfLastEvent");
                this.mCompat.onNewHeartRateDataTimestamp(estTimestamp, eventFlags, heartBeatEventTime);
                break;
            }
            case 203: {
                if (this.mPage4AddtDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                int manufacturerSpecificByte = b.getInt("int_manufacturerSpecificByte");
                BigDecimal previousHeartBeatEventTime = (BigDecimal)b.getSerializable("decimal_timestampOfPreviousToLastHeartBeatEvent");
                this.mPage4AddtDataReceiver.onNewPage4AddtData(estTimestamp, eventFlags, manufacturerSpecificByte, previousHeartBeatEventTime);
                break;
            }
            case 207: {
                if (this.mCalculatedRrIntervalReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                BigDecimal calculatedRrInterval = (BigDecimal)b.getSerializable("decimal_calculatedRrInterval");
                RrFlag rrFlag = RrFlag.getValueFromInt(b.getInt("int_rrFlag"));
                this.mCalculatedRrIntervalReceiver.onNewCalculatedRrInterval(estTimestamp, eventFlags, calculatedRrInterval, rrFlag);
                break;
            }
            default: {
                super.handlePluginEvent(eventMsg);
            }
        }
    }

    public void subscribeHeartRateDataEvent(IHeartRateDataReceiver HeartRateDataReceiver) {
        if (this.reportedServiceVersion < 20208) {
            if (HeartRateDataReceiver != null) {
                this.mCompat = new LegacyHeartRateCompat(HeartRateDataReceiver);
                this.subscribeToEvent(202);
            } else {
                this.mCompat = null;
                this.unsubscribeFromEvent(202);
            }
            HeartRateDataReceiver = this.mCompat;
        }
        this.mHeartRateDataReceiver = HeartRateDataReceiver;
        if (HeartRateDataReceiver != null) {
            this.subscribeToEvent(201);
        } else {
            this.unsubscribeFromEvent(201);
        }
    }

    public void subscribePage4AddtDataEvent(IPage4AddtDataReceiver Page4AddtDataReceiver) {
        this.mPage4AddtDataReceiver = Page4AddtDataReceiver;
        if (Page4AddtDataReceiver != null) {
            this.subscribeToEvent(203);
        } else {
            this.unsubscribeFromEvent(203);
        }
    }

    public boolean subscribeCalculatedRrIntervalEvent(ICalculatedRrIntervalReceiver CalculatedRrIntervalReceiver) {
        if (this.reportedServiceVersion < 20208) {
            LogAnt.w(TAG, "subscribeCalculatedRrIntervalEvent requires ANT+ Plugins Service >20208, installed: " + this.reportedServiceVersion);
            return false;
        }
        this.mCalculatedRrIntervalReceiver = CalculatedRrIntervalReceiver;
        if (CalculatedRrIntervalReceiver != null) {
            return this.subscribeToEvent(207);
        }
        this.unsubscribeFromEvent(207);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICalculatedRrIntervalReceiver {
        public void onNewCalculatedRrInterval(long var1, EnumSet<EventFlag> var3, BigDecimal var4, RrFlag var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RrFlag {
        DATA_SOURCE_PAGE_4(1),
        DATA_SOURCE_CACHED(2),
        DATA_SOURCE_AVERAGED(3),
        HEART_RATE_ZERO_DETECTED(4),
        UNRECOGNIZED(-1);

        private int intValue;

        private RrFlag(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static RrFlag getValueFromInt(int intValue) {
            for (RrFlag source : RrFlag.values()) {
                if (source.getIntValue() != intValue) continue;
                return source;
            }
            RrFlag unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IPage4AddtDataReceiver {
        public void onNewPage4AddtData(long var1, EnumSet<EventFlag> var3, int var4, BigDecimal var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IHeartRateDataReceiver {
        public void onNewHeartRateData(long var1, EnumSet<EventFlag> var3, int var4, long var5, BigDecimal var7, DataState var8);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataState {
        LIVE_DATA(1),
        INITIAL_VALUE(2),
        ZERO_DETECTED(3),
        UNRECOGNIZED(-1);

        private int intValue;

        private DataState(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static DataState getValueFromInt(int intValue) {
            for (DataState source : DataState.values()) {
                if (source.getIntValue() != intValue) continue;
                return source;
            }
            DataState unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    public class IpcDefines {
        public static final String PATH_ANTPLUS_HEARTRATEPLUGIN_PKG = "com.dsi.ant.plugins.antplus";
        public static final String PATH_ANTPLUS_HEARTRATEPLUGIN_SERVICE = "com.dsi.ant.plugins.antplus.heartrate.HeartRateService";
        public static final int MSG_EVENT_HEARTRATE_whatHEARTRATEDATA = 201;
        public static final String MSG_EVENT_HEARTRATE_HEARTRATEDATA_PARAM_intCOMPUTEDHEARTRATE = "int_computedHeartRate";
        public static final String MSG_EVENT_HEARTRATE_HEARTRATEDATA_PARAM_longHEARTBEATCOUNTER = "long_heartBeatCounter";
        public static final String MSG_EVENT_HEARTRATE_HEARTRATEDATA_PARAM_decimalHEARTBEATEVENTTIME = "decimal_timestampOfLastEvent";
        public static final String MSG_EVENT_HEARTRATE_HEARTRATEDATA_PARAM_intDATASTATE = "int_dataState";
        @Deprecated
        public static final int DEPRECATED_MSG_EVENT_HEARTRATE_whatHEARTBEATEVENTTIME = 202;
        @Deprecated
        public static final String DEPRECATED_MSG_EVENT_HEARTRATE_HEARTBEATEVENTTIME_PARAM_decimalHEARTBEATEVENTTIME = "decimal_timestampOfLastEvent";
        public static final int MSG_EVENT_HEARTRATE_whatPAGE4ADDTDATA = 203;
        public static final String MSG_EVENT_HEARTRATE_PAGE4ADDTDATA_PARAM_intMANUFACTURERSPECIFICBYTE = "int_manufacturerSpecificByte";
        public static final String MSG_EVENT_HEARTRATE_PAGE4ADDTDATA_PARAM_decimalPREVIOUSHEARTBEATEVENTTIME = "decimal_timestampOfPreviousToLastHeartBeatEvent";
        public static final int MSG_EVENT_HEARTRATE_whatCALCULATEDRRINTERVAL = 207;
        public static final String MSG_EVENT_HEARTRATE_RRINTERVAL_PARAM_decimalCALCULATEDRRINTERVAL = "decimal_calculatedRrInterval";
        public static final String MSG_EVENT_HEARTRATE_RRINTERVAL_PARAM_intRRFLAG = "int_rrFlag";
    }
}

