#ifndef ATL_cGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,160,400,800,880,960,1200,1360,1600
 * N : 25,160,400,800,880,960,1200,1360,1600
 * NB : 4,8,12,20,24,28,40,80,80
 */
#define ATL_cGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 92) (nb_) = 4; \
   else if ((n_) < 280) (nb_) = 8; \
   else if ((n_) < 600) (nb_) = 12; \
   else if ((n_) < 840) (nb_) = 20; \
   else if ((n_) < 920) (nb_) = 24; \
   else if ((n_) < 1080) (nb_) = 28; \
   else if ((n_) < 1280) (nb_) = 40; \
   else (nb_) = 80; \
}


#endif    /* end ifndef ATL_cGetNB_geqrf */
