/*
 * IceWM
 *
 * Copyright (C) 1997,1998 Marko Macek
 *
 * MailBox Status
 * !!! this should be external module (replacable for POP,IMAP,...)
 */

#include "icewm.h"

#ifdef CONFIG_MAILBOX

#define CHECK_DELAY (5*1000) // ms

MailBoxStatus::MailBoxStatus(const char *mailBox, const char *mailCommand, YWindow *aParent): YWindow(aParent) {
    char *mail = getenv("MAIL");

    // this seems too much, getenv("MAIL") should do the trick... ?
    if (mail) {
        fMailBox = strdup(mail);
    } else if ((mailBox == 0 || mailBox[0] == 0) && getenv("LOGNAME") != 0) {
        char buf[1024];

        strcpy(buf, MAIL_SPOOL);
        strcat(buf, getenv("LOGNAME"));
        fMailBox = strdup(buf);
    } else if (mailBox && mailBox[0] != 0 && mailBox[strlen(mailBox) - 1] == '/' && getenv("LOGNAME") != 0) {
        char buf[1024];
	
	strcpy(buf, mailBox);
        strcat(buf, getenv("LOGNAME"));
        fMailBox = strdup(buf);
    } else
	fMailBox = mailBox;

    if (fMailBox)
        MSG(("Using MailBox: '%s'\n", fMailBox));
    fMailCommand = mailCommand;
    fLastCheckTime = 0;
    fLastSize = 0;
    setSize(16, 16);
    fState = mbxNoMail;
    checkMail();
    fMailboxCheckTimer = new YTimer();
    if (fMailboxCheckTimer) {
        fMailboxCheckTimer->setInterval(CHECK_DELAY);
        fMailboxCheckTimer->setListener(this);
        fMailboxCheckTimer->startTimer();
    }
}

MailBoxStatus::~MailBoxStatus() {
}

void MailBoxStatus::paint(Graphics &g, int /*x*/, int /*y*/, unsigned int /*width*/, unsigned int /*height*/) {
    YPixmap *pixmap;
    switch (fState) {
    case mbxHasMail:
        pixmap = mailPixmap;
        break;
    case mbxHasNewMail:
        pixmap = newMailPixmap;
        break;
    case mbxHasUnreadMail:
        pixmap = unreadMailPixmap;
        break;
    default:
        pixmap = 0;
        break;
    }
    if (pixmap) 
        g.drawPixmap(pixmap, 0, 0);
    else {
        g.setColor(taskBarBg);
        g.fillRect(0, 0, width(), height());
    }
}

void MailBoxStatus::handleClick(const XButtonEvent &down, const XButtonEvent &up, int count) {
    if (down.button == 1 && up.button == 1) {
        if (count == 1) {
            fLastCheckTime = 0;
            checkMail();
        } else if (count == 2) {
            if (fMailCommand != 0)
                runCommand(fMailCommand);
        }
    }
}

void MailBoxStatus::checkMail() {
    struct stat st;
    MailBoxState fNewState = fState;

    if (fMailBox == 0)
        return ;

    if (stat(fMailBox, &st) == -1) {
        fNewState = mbxNoMail;
        fLastSize = 0;
    } else {
        if (st.st_size == 0)
            fNewState = mbxNoMail;
        else {
            fNewState = mbxHasMail;
            if ((unsigned long)st.st_size > fLastSize) {
                fNewState = mbxHasNewMail;
                newMailArrived();
            } else {
                if (st.st_mtime > st.st_atime) {
                    fNewState = mbxHasUnreadMail;
                }
            }
        }
        fLastSize = st.st_size;
    }

    if (fNewState != fState) {
        fState = fNewState;
        repaint();
    }
    fLastCheckTime = time(NULL);
    countMessages();
}

void MailBoxStatus::newMailArrived() {
    if (beepOnNewMail)
        XBell(app->display(), 100);
}


void MailBoxStatus::countMessages() {
    int fd = open(fMailBox, O_RDONLY);
    char buf[4096];
    const char *pat = "\nFrom ";
    int plen = strlen(pat);
    int pos = 1;
    int i, len;
    int mails = 0; 
     
    while ((len = read(fd, buf, sizeof(buf))) > 0) {
        for (i = 0; i < len;) {
            if (buf[i] != pat[pos])
                if (pos) 
                    pos = 0;
                else
                    i++;
            else {
                i++;
                if (++pos == plen) {
                    pos = 0;
                    mails++;
                }
            }
        }
    }
    close(fd);

    char s[128];
    sprintf(s, "%s has %d mail messages.", fMailBox, mails);

    setToolTip(s);
}

bool MailBoxStatus::handleTimer(YTimer *t) {
    assert(t == fMailboxCheckTimer);
    checkMail();
    return true;
}

#endif
