/*
 * IceWM
 *
 * Copyright (C) 1997,1998 Marko Macek
 */

#include "icewm.h"

YColor *YButton::normalButtonBg = 0;
YColor *YButton::normalButtonFg = 0;

YColor *YButton::activeButtonBg = 0;
YColor *YButton::activeButtonFg = 0;

YFont *YButton::normalButtonFont = 0;
YFont *YButton::activeButtonFont = 0;

YButton::YButton(YWindow *parent, WMCommand command, void *context): YWindow(parent) {
    if (normalButtonFont == 0)
        normalButtonFont = new YFont(normalButtonFontName);
    if (activeButtonFont == 0)
        activeButtonFont = new YFont(activeButtonFontName);
    if (normalButtonBg == 0)
        normalButtonBg = new YColor(clrNormalButton);
    if (normalButtonFg == 0)
        normalButtonFg = new YColor(clrNormalButtonText);
    if (activeButtonBg == 0)
        activeButtonBg = new YColor(clrActiveButton);
    if (activeButtonFg == 0)
        activeButtonFg = new YColor(clrActiveButtonText);

    selected = 0;
    isActive = 0;
    fPopup = 0;
    fCommand = command;
    fContext = context;
    wasPopupActive = 0;
    fPixmap = 0;
    fPressed = 0;
    fListener = 0;
    fHotCharPos = -1;
    fText = 0;
    hotKey = -1;
}

YButton::YButton(YWindow *parent, YPopupWindow *popup, CommandListener *command): YWindow(parent) {
    if (normalButtonFont == 0)
        normalButtonFont = new YFont(normalButtonFontName);
    if (activeButtonFont == 0)
        activeButtonFont = new YFont(activeButtonFontName);
    if (normalButtonBg == 0)
        normalButtonBg = new YColor(clrNormalButton);
    if (normalButtonFg == 0)
        normalButtonFg = new YColor(clrNormalButtonText);
    if (activeButtonBg == 0)
        activeButtonBg = new YColor(clrActiveButton);
    if (activeButtonFg == 0)
        activeButtonFg = new YColor(clrActiveButtonText);

    selected = 0;
    isActive = 0;
    fPopup = popup;
    fCommandListener = command;
    fCommand = cmdNone;
    wasPopupActive = 0;
    fPixmap = 0;
    fText = 0;
    fContext = 0;
    fPressed = 0;
    fListener = 0;
    fHotCharPos = -1;
    hotKey = -1;
}

YButton::~YButton() {
    if (hotKey != -1) {
        removeAccelerator(hotKey, 0, this);
        if (app->AltMask != 0)
            removeAccelerator(hotKey, app->AltMask, this);
    }
    if (isActive)
        popdown();
}

void YButton::paint(Graphics &g, int /*x*/, int /*y*/, unsigned int /*w*/, unsigned int /*h*/) {
#ifdef CONFIG_TASKBAR
    int d = (fPressed || isActive) ? 1 : 0;
    int x, y, w, h;

    if (fPressed)
        g.setColor(activeButtonBg);
    else
        g.setColor(normalButtonBg);

    x = 0;
    y = 0;
    w = width();
    h = height();
    
    if (wmLook == lookMetal) {
        d = 0;
        g.drawBorderM(x, y, w - 1, h - 1, d ? false : true);
        x += 2;
        y += 2;
        w -= 4;
        h -= 4;
    } else if (wmLook == lookGtk) {
        g.drawBorderG(x, y, w - 1, h - 1, d ? false : true);
        x += 1 + d;
        y += 1 + d;
        w -= 3;
        h -= 3;
    } else {
        g.drawBorderW(x, y, w - 1, h - 1, d ? false : true);
        x += 1 + d;
        y += 1 + d;
        w -= 3;
        h -= 3;
    }

    if (fPixmap) { // !!! fix drawing
        if (fPixmap->mask()) {
            g.fillRect(x, y, w, h);
            g.drawPixmap(fPixmap,
                         x + (w - fPixmap->width()) / 2,
                         y + (h - fPixmap->height()) / 2);
        } else {
            g.drawCenteredPixmap(x, y, w, h, fPixmap);
            //2 + d, 2 + d,
             //                    width() - 3 - d, height() - 3 - d,
             //                    fPixmap);
        }
    } else {
        g.fillRect(x, y, w, h);
        /*if (wmLook == lookMetal)
            g.fillRect(2 + d, 2 + d, width() - 3, height() - 3);
        else
            g.fillRect(1 + d, 1 + d, width() - 3, height() - 3);*/

        YFont *font;
        
        if (fPressed)
            font = activeButtonFont;
        else
            font = normalButtonFont;

        if (fText) {
            int w = font->textWidth(fText);
            int p = (width() - w) / 2;
            int yp =  (height() - 1 - font->height()) / 2
                + font->ascent() + d;

            if (fPressed)
                g.setColor(activeButtonFg);
            else
                g.setColor(normalButtonFg);
            g.setFont(font);
            g.drawChars(fText, 0, strlen(fText), d + p, yp);
            if (fHotCharPos != -1)
                g.drawCharUnderline(d + p, yp, fText, fHotCharPos);
        }
    }
    paintFocus(g, x, y, w, h);
#endif
}

void YButton::paintFocus(Graphics &g, int /*x*/, int /*y*/, unsigned int /*w*/, unsigned int /*h*/) {
#ifdef CONFIG_TASKBAR
    int d = (fPressed || isActive) ? 1 : 0;
    
    if (isFocused())
        g.setColor(black);
    else if (fPressed)
        g.setColor(activeButtonBg);
    else
        g.setColor(normalButtonBg);

    if (wmLook == lookMetal)
        g.drawBorderM(0, 0, width() - 1, height() - 1, d ? false : true);
    else
        g.drawRect(1 + d, 1 + d, width() - 4, height() - 4);
#endif
}

bool YButton::handleKey(const XKeyEvent &key) {
    KeySym k = XKeycodeToKeysym(app->display(), key.keycode, 0);
    unsigned int m = KEY_MODMASK(key.state);
    int uk = TOUPPER(k);
        
    if (key.type == KeyPress) {
        if (!selected) {
            if (((k == XK_Return || k == 32) && m == 0) ||
                (uk == hotKey && (m & ~app->AltMask) == 0))
            {
                selected = 2;
                requestFocus();
                if (fPopup) {
                    wasPopupActive = isActive;
                    if (!isActive)
                        popup();
                } else {
                }
                isActive = 1;
                repaint();
                return true;
            }
        }
    } else if (key.type == KeyRelease) {
        if (selected) {
            if (((k == XK_Return || k == 32) && m == 0) ||
                (uk == hotKey && (m & ~app->AltMask) == 0))
            {
                selected = 0;
                if (fPopup) {
                    if ((wasPopupActive) && isActive) {
                        popdown();
                        isActive = 0;
                        repaint();
                    }
                } else {
                    int wasActive = isActive;
                    if (isActive) {
                        isActive = 0;
                        repaint();
                    }
                    if (wasActive) {
                        if (fListener)
                            fListener->ButtonClick(this, key.state);
                        else // !!!
                            fprintf(stderr, "no button listener 1\n");
                    }
                }
                return true;
            }
        }
    }
    return YWindow::handleKey(key);
}

void YButton::popupMenu() {
    if (fPopup) {
        selected = 2;
        requestFocus();
        wasPopupActive = isActive;
        if (!isActive)
            fPopup->popup(this, fCommandListener, 0,
                          x() + parent()->x() - 2,
                          y() + parent()->y() + height(),
                          0,
                          height(),
                          YPopupWindow::pfCanFlipVertical);
        isActive = 1;
        repaint();
    }
}

void YButton::handleButton(const XButtonEvent &button) {
    if (button.type == ButtonPress && button.button == 1) {
        selected = 2;
        requestFocus();
        if (fPopup) {
            wasPopupActive = isActive;
            if (!isActive)
                popup();
        } else {
        }
        isActive = 1;
        repaint();
    } else if (button.type == ButtonRelease) {
        int inWindow = (button.x >= 0 &&
                        button.y >= 0 &&
                        button.x < int (width()) &&
                        button.y < int (height()));
        selected = 0;
        if (fPopup) {
            if ((!inWindow || wasPopupActive) && isActive) {
                popdown();
                isActive = 0;
                repaint();
            }
        } else {
            int wasActive = isActive;
            if (isActive) {
                isActive = 0;
                repaint();
            }
            if (inWindow && wasActive) {
                if (fListener)
                    fListener->ButtonClick(this, button.state);
                else // !!!
                    fprintf(stderr, "no button listener 2\n");
            }
        }
    }
    YWindow::handleButton(button);
}

void YButton::handleCrossing(const XCrossingEvent &crossing) {
    if (selected > 0) {
        if (crossing.type == EnterNotify) {
            selected = 2;
            if (!fPopup) { 
                isActive = 1;
                repaint();
            }
        } else if (crossing.type == LeaveNotify) {
            selected = 1;
            if (!fPopup) { 
                isActive = 0;
                repaint();
            }
        }
    }
    YWindow::handleCrossing(crossing);
}

void YButton::setCommand(WMCommand command, void *context) {
    fCommand = command;
    fContext = context;
}

void YButton::setPixmap(YPixmap *pixmap) {
    fPixmap = pixmap;
    if (pixmap) {
        setSize(pixmap->width() + 3 + 2 - ((wmLook == lookMetal) ? 1 : 0),
                pixmap->height() + 3 + 2 - ((wmLook == lookMetal) ? 1 : 0));
    }
}

void YButton::setPressed(int pressed) {
    if (fPressed != pressed) {
        fPressed = pressed;
        repaint();
    }
}

void YButton::setText(const char *str, int hotChar) {
    if (hotKey != -1) {
        removeAccelerator(hotKey, 0, this);
        if (app->AltMask != 0)
            removeAccelerator(hotKey, app->AltMask, this);
    }

    fText = str ? strdup(str) : 0;
#ifdef CONFIG_TASKBAR
    /// fix
    if (fText) {
        int w = activeButtonFont->textWidth(fText);
        int h = activeButtonFont->ascent();
        fHotCharPos = hotChar;

        hotKey = (fHotCharPos != -1) ? fText[fHotCharPos] : -1;
        hotKey = TOUPPER(hotKey);

        if (hotKey != -1) {
            installAccelerator(hotKey, 0, this);
            if (app->AltMask != 0)
                installAccelerator(hotKey, app->AltMask, this);
        }

        setSize(3 + w + 4 + 2, 3 + h + 4 + 2);
    } else
        hotKey = -1;
#endif
}

void YButton::setPopup(YPopupWindow *popup, CommandListener *command) {
    if (fPopup) {
        popdown();
        delete fPopup;
    }
    fPopup = popup;
    fCommandListener = command;
}

void YButton::donePopup(YPopupWindow *popup) {
    if (popup != fPopup) {
        MSG(("popup different?"));
        return ;
    }
    popdown();
    isActive = 0;
    selected = 0;
    repaint();
}

void YButton::popup() {
    if (fPopup) {
        int x = 0;
        int y = 0;
        mapToGlobal(x, y);
        fPopup->popup(this, fCommandListener, 0,
                      x - 2,
                      y + height(),
                      0,
                      height(),
                      YPopupWindow::pfCanFlipVertical | 
                      YPopupWindow::pfButtonDown);
    }
}

void YButton::popdown() {
    if (isActive && fPopup) {
        fPopup->popdown();
        isActive = 0;
    }
}

bool YButton::isFocusTraversable() {
    return true;
}
