/**
 *
 * $Id: IconGP.h,v 1.2 1997/10/30 03:09:49 rwscott Exp $
 * 
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/
#ifndef XM_ICONG_P_H
#define XM_ICONG_P_H

#include <Xm/IconG.h>
#include <Xm/GadgetP.h>
#include <Xm/ExtObjectP.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Gadget cache class and instance records
 */
typedef struct _XmIconGCacheObjClassPart {
    int foo;
} XmIconGCacheObjClassPart;

typedef struct _XmIconGCacheObjClassRec {
    ObjectClassPart object_class;
    XmExtClassPart ext_class;
    XmIconGCacheObjClassPart icon_class_cache;
} XmIconGCacheObjClassRec;

extern XmIconGCacheObjClassRec xmIconGCacheObjClassRec;

typedef struct _XmIconGCacheObjPart {
    Boolean fill_on_arm;
    Pixel arm_color;
    Pixmap arm_pixmap;
    Pixmap unarm_pixmap;
    unsigned char multiClick;
    Dimension default_button_shadow_thickness;

    GC normal_gc;
    GC background_gc;
    XtIntervalId timer;
} XmIconGCacheObjPart;

typedef struct _XmIconGCacheObjRec {
    ObjectPart object;
    XmExtPart ext;
    XmIconGCacheObjPart icon_cache;
} XmIconGCacheObjRec;


/*
 * icon gadget class and instance records
 */
/* Define class part structure */
typedef struct {
    XtPointer extension;
} XmIconGadgetClassPart;

/* Define the full class record */
typedef struct _XmIconGadgetClassRec {
    RectObjClassPart rect_class;
    XmGadgetClassPart gadget_class;
    XmIconGadgetClassPart icon_class;
} XmIconGadgetClassRec;

extern XmIconGadgetClassRec xmIconGadgetClassRec;

typedef struct {
    XmStringTable detail;
    Cardinal      detailCount;
    XmFontList    font;
    _XmString      labelString;
    Pixmap        largeIconMask;
    Pixmap        largeIconPixmap;
    Pixmap        smallIconMask;
    Pixmap        smallIconPixmap;
    XmRenderTable renderTable;
    unsigned char viewType;
    unsigned char visualEmphasis;

    XmIconGCacheObjPart *cache;
} XmIconGadgetPart;

/* Define the full instance record */
typedef struct _XmIconGadgetRec {
    ObjectPart object;
    RectObjPart rectangle;
    XmGadgetPart gadget;
    XmIconGadgetPart icon;
} XmIconGadgetRec;


#define IG_ViewType(w) \
    (((XmIconGadget)(w))->icon.viewType)

#define IG_Label(w) \
    (((XmIconGadget)(w))->icon.labelString)

#define IG_ActivateCallback(w) \
    (((XmIconGadget)(w))->icon.activate_callback)

#define IG_ArmCallback(w) \
    (((XmIconGadget)(w))->icon.arm_callback)

#define IG_DisarmCallback(w) \
    (((XmIconGadget)(w))->icon.disarm_callback)

#define IG_Armed(w) \
    (((XmIconGadget)(w))->icon.armed)

#define IG_ClickCount(w) \
    (((XmIconGadget)(w))->icon.click_count)

#define IG_Compatible(w) \
    (((XmIconGadget)(w))->icon.compatible)

#define IG_ShowAsDefault(w) \
    (((XmIconGadget)(w))->icon.show_as_default)

#define IG_FillOnArm(w) \
    (((XmIconGadget)(w))->icon.cache->fill_on_arm)

#define IG_ArmColor(w) \
    (((XmIconGadget)(w))->icon.cache->arm_color)

#define IG_NormalGC(w) \
    (((XmIconGadget)(w))->icon.cache->normal_gc)

#define IG_BackgroundGC(w) \
    (((XmIconGadget)(w))->icon.cache->background_gc)

#define IG_Timer(w) \
    (((XmIconGadget)(w))->icon.cache->timer)

#define IG_ArmPixmap(w) \
    (((XmIconGadget)(w))->icon.cache->arm_pixmap)

#define IG_UnarmPixmap(w) \
    (((XmIconGadget)(w))->icon.cache->unarm_pixmap)

#define IG_MultiClick(w) \
    (((XmIconGadget)(w))->icon.cache->multiClick)

#define IG_DefaultButtonShadowThickness(w) \
    (((XmIconGadget)(w))->icon.cache->default_button_shadow_thickness)

#define IG_Cache(w) \
    (((XmIconGadget)(w))->icon.cache)

#define IG_ClassCachePart(w) \
    (((XmIconGadgetClass)xmIconGadgetClass)->gadget_class.cache_part)

#define IG_Font(w) \
       (((XmIconGadget)(w))->icon.font)

#define IG_LargeIconMask(w) \
       (((XmIconGadget)(w))->icon.largeIconMask)

#define IG_LargeIconPixmap(w) \
       (((XmIconGadget)(w))->icon.largeIconPixmap)

#define IG_SmallIconMask(w) \
       (((XmIconGadget)(w))->icon.smallIconMask)

#define IG_SmallIconPixmap(w) \
       (((XmIconGadget)(w))->icon.smallIconPixmap)

#define IG_RenderTable(w) \
       (((XmIconGadget)(w))->icon.renderTable)

/* weird Motif backwards compatibility function.  I don't care if it ever
 * gets implemented or not */
extern void _XmClearBGCompatibility(Widget pbg);

extern int _XmIconCacheCompare(XtPointer A, XtPointer B);

#ifdef __cplusplus
}
#endif

#endif /* XM_ICON_P_H */
