
#include <ggi/ggi.h>
#include <ggi/gwt.h>
#include <stdio.h>

ggi_pixel white, black, red, green;

#define REDRAW \
	ggiSetGCForeground(vis, white); \
	gwtFillscreen(rootwin); \
	ggiSetGCForeground(vis, red); \
	gwtFillscreen(subwin); \
	ggiSetGCForeground(vis, green); \
	gwtFillscreen(subsubwin); \
	ggiFlush(vis)


int main(int argc, char ** argv)
{
	int key;
	int wx=0, wy=0;
	int finished=0;

	ggi_visual_t vis;
	ggi_mode tm;
	gwt_window_t rootwin, subwin, subsubwin;
	ggi_color col;

	ggiInit();
	gwtInit();
	vis=ggiOpen(NULL);
	gwtAttach(vis);
	
	ggiCheckGraphMode(vis, GT_AUTO, GT_AUTO, GT_AUTO, GT_AUTO, GT_AUTO, &tm);
	ggiSetMode(vis, &tm);

	col.r=col.g=col.b=0x0000;
	black=ggiMapColor(vis, &col);
	col.r=col.g=col.b=0xffff;
	white=ggiMapColor(vis, &col);
	col.g=col.b=0x0000;
	red=ggiMapColor(vis, &col);
	col.r=0x0000;
	col.g=0xffff;
	green=ggiMapColor(vis, &col);


	gwtCreateRootWindow(vis, &rootwin);
	gwtCreateWindow(rootwin, &subwin);
	gwtCreateWindow(subwin, &subsubwin);

	gwtResize(subwin, 320, 240);
	gwtResize(subsubwin, 160, 120);
	gwtShow(subwin);
	gwtShow(subsubwin);

do {
	REDRAW;
	
	do key = ggiGetc(vis);
	while ((key == GGI_KEY_VOID) || (GGI_KTYP(key) == GGI_KT_SHIFT));

	switch (key) {
	case 'q':		/* up*/
		wy-=16; break;
	case 'a':		/* down */
		wy+=16; break;
	case 'o':		/* left */
		wx-=16; break;
	case 'p':		/* right */
		wx+=16; break;
	case ' ':		/* finish */
		finished=1; break;

	}

	gwtMove(subwin, wx, wy);
} while (!finished);

	ggiFlush(vis);

	gwtDestroy(rootwin);	/* closes children first */
	gwtDetach(vis);
	ggiClose(vis);
	gwtExit();
	ggiExit();
	exit(0);
}

