/*
   A sample application demonstrating libgwt functions

   Copyright (C) 1998 Marcus Sundberg [marcus@ggi-project.org]

   You may do anything you want with this code, except claim
   that you wrote it...
*/

#include <stdio.h>
#include <ggi/ggi.h>
#include <ggi/gwt.h>


static void
err_exit(char *msg)
{
	printf(msg);
	/* gwtExit() will clean up everything after gwt */
	gwtExit();
	exit(1);
}


int
main(int argc, char *argv[])
{
	ggi_visual_t vis;
	ggi_mode     mode;
	int          r_w, r_h; /* Width and height of root-window */
	gwt_window_t root, nr1, nr2, nr3;

	/* Initialize the gwt subsystem.
	   gwtInit() will automatically call ggiInit() if needed */
	if (gwtInit()) {
		/* (It's safe to call gwtExit() even if gwt was
		   never initialized) */
		err_exit("Unable to init libgwt!\n");
	}
	
	/* Open a libggi visual */
	if ((vis = ggiOpen(NULL)) == NULL)
		err_exit("Unable to open libggi default visual!\n");

	/* Set the default mode of the visual */
	ggiCheckGraphMode(vis, GGI_AUTO, GGI_AUTO,
			  GGI_AUTO, GGI_AUTO, GT_AUTO, &mode, NULL);
	if (ggiSetMode(vis, &mode))
		err_exit("Unable to set a graphics mode!\n");

	r_w = mode.visible.x;
	r_h = mode.visible.y;

	/* Attach gwt to the newly opened visual */
	if (gwtAttach(vis))
		err_exit("Unable to attach gwt to visual!\n");
	
	/* Create the gwt root window */
	if (gwtCreateRootWindow(vis, &root))
		err_exit("Unable to create gwt root window!\n");

/*
 * You would expect to have to do these wouldn't you?
 * The truth is that they're implicit for the root window.
	gwtSetGeometry(root, 0, 0, r_w, r_h);
	gwtShow(root);
 */

	/* Now create some sub-windows */
	if (gwtCreateWindow(root, &nr1)
	    || gwtCreateWindow(root, &nr2)
	    || gwtCreateWindow(root, &nr3))
		err_exit("Unable to create sub-windows!\n");

	/* Set properties and make the windows visible */
	gwtSetGeometry(nr1, 0, 0, r_w/2, r_h/2);
	gwtSetGeometry(nr2, r_w/2, r_h/2, r_w/2, r_h/2);
	gwtSetGeometry(nr3, r_w/4, r_h/4, r_w/4, r_h/4);
	gwtShow(nr1);
	gwtShow(nr2);
	gwtShow(nr3);

	/* Do some drawing (the following stuff should be improved once	
	   libgwt actually supports drawing and events properly //Marcus) */
	ggiSetGCForeground(vis, 0xffffffff);

	gwtDrawRect(nr1);
	/* Wait for a keypress */
	ggiGetc(vis);

	gwtDrawFrame(nr2);
	ggiGetc(vis);

	gwtFillscreen(nr3);
	ggiGetc(vis);

	return 0;
}
