/* $Id: input.c,v 1.8 1998/10/26 11:45:48 ajapted Exp $
***************************************************************************

   Input-stdin: initialization

   Copyright (C) 1998 Andreas Beck      [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdlib.h>

#include <ggi/internal/gii-dl.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

gii_event_mask GII_stdin_poll(struct gii_input *inp)
{
	fd_set		readset;
	gii_event	ev;
	unsigned char	buf;
	struct timeval	t={0,0};
	
	FD_ZERO(&readset);
	FD_SET(0,&readset);

	DPRINT_MISC("input-stdin: poll(%p);\n",inp);
	
	/* FIXME !!! doesn't handle -EINTR */
	if (select(1,&readset,NULL,NULL,&t)>0)
	{
		read(0,&buf,sizeof(buf));
		_giiEventBlank(&ev);
		ev.key.size=sizeof(gii_key_event);
		ev.key.type=evKeyPress;
		ev.key.origin=inp->origin;
		ev.key.target=0;
		ev.key.effect=0;
		ev.key.sym=ev.key.label=ev.key.button=(uint32)buf;
		_giiEvQueueAdd(inp,&ev);
		ev.key.type=evKeyRelease;
		_giiEvQueueAdd(inp,&ev);
		return (emKeyPress | emKeyRelease);
	}
	return 0;
}

int GIIdlinit(gii_input *inp,const char *args)
{
	DPRINT_MISC("input-stdin starting.\n");

	/* We leave these on the default handlers
	 *	inp->GIIseteventmask=_GIIstdseteventmask;
	 *	inp->GIIgeteventmask=_GIIstdgeteventmask;
	 *	inp->GIIgetselectfdset=_GIIstdgetselectfd;
	 *	inp->GIIclose	 =GII_stdin_close;


	 */
	/* They are already set, so we can as well use them instead of
	 * accessing the curreventmask member directly.
	 */
	inp->targetcan=emKeyPress | emKeyRelease;
	inp->GIIseteventmask(inp,emKeyPress | emKeyRelease);

	FD_SET(0,&(inp->fdset));	/* Add stdin */
	inp->maxfd=1;			/* Show it */
	inp->GIIeventpoll=GII_stdin_poll;

	DPRINT_MISC("input-stdin fully up\n");

	return 0;
}
