/*
  !!! WARNING: This file is for libggi 1.4 compatibility
*/

/* 
 *  Library initialization
 *
 *  Copyright (C) 1998 Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "internal2d.h"

/*
 * Initalize the strutures for the library
 */
static int 	_ggi2dLibIsUp=0;

int ggi2dDebugState=0;

ggi_extid ggi2dID=-1;

static int changed(ggi_visual_t vis,int whatchanged)
{
	DPRINT("changed() called for libggi2d - vis=%p, %i \n",
		vis,whatchanged);

	switch(whatchanged) {
	case GGI_CHG_APILIST:	{
		int temp;
		ggi_dlhandle *lib;
		char api[256],args[256];
		
		DPRINT("changed() APILIST \n");
		for(temp=0;0==ggiGetAPI(vis,temp,api,args);temp++) {
			strcat(api,"-2d");
                	DPRINT("Trying #%d: %s(%s)\n",temp,api,args);
			lib=_ggiAddDL(vis,api,args,GGI_DLTYPE_EXTENSION);
                	DPRINT("Loaded #%d: %s(%s) : %p\n",temp,api,args,lib);
		}
		};
		break;
	}
                                
	return 0;
}

int ggi2dInit(void)
{
	char *str;
    
	_ggi2dLibIsUp++;
	if (_ggi2dLibIsUp!=1) return 0;	/* Initialize only at first call. */

	str=getenv("GGI2D_DEBUG");
	if (str!=NULL) {
		ggi2dDebugState=atoi(str);
		DPRINT("Debugging=%d\n",ggi2dDebugState);
	}

	ggi2dID=ggiExtensionRegister("GGI2D",sizeof(ggi2d_data),changed);
	DPRINT("Initialized libggi2d. ID: %i\n",ggi2dID);

	return ggi2dID >= 0 ? 0 : -1;
}

int ggi2dExit(void)
{
	int rc;
    
	if (!_ggi2dLibIsUp)
		return -1;

	if (_ggi2dLibIsUp > 1) {
		_ggi2dLibIsUp--;
		return 0;	/* Exit only at last call */
	}
	
	rc=ggiExtensionUnregister(ggi2dID);
	DPRINT("DeInitailized libggi2d. rc=%i\n", rc);

	_ggi2dLibIsUp = 0;
	return rc;
}

int ggi2dOpen(ggi_visual_t vis)
{
	int rc;
    
	rc=ggiExtensionAttach(vis,ggi2dID);
	DPRINT("Attached libggi2d to %p. rc=%i\n", vis, rc);

	if (rc==0) {	/* We are actually creating the primary instance. */
		memset(GGI2D_DATA(vis),0,sizeof(ggi2d_data));
                        
		/* Now fake an "API change" so the right libs get loaded */
		changed(vis,GGI_CHG_APILIST);
		GGI2DinitGC(vis);
        	GGI2Dupdate(vis, GGI2D_UPD_ALL);
	}

	return rc;
}

int ggi2dClose(ggi_visual_t vis)
{
	int rc;
	rc=ggiExtensionDetach(vis,ggi2dID);
	DPRINT("Detached libggi2d from %p. rc=%i\n", vis, rc);

	return rc;
}

/*----------------------------------------------------------------------*/
