/* 
 *  setup
 *
 *  Copyright (C) 1998 Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "lib.h"

/*----------------------------------------------------------------------*/

static void update(ggi_visual_t vis, ggi_uint change)
{
	ggi2d_funcs *func = GGI2D_FUNC(vis);
	int	dashed = GGI2D_GC_DASHSIZE(vis);
	int	textured = GGI2D_GC_TEXTURED(vis);
	ggi_uint op = GGI2D_GC_OP(vis);

	DPRINT("updating 2d " TARGETNAME "\n");
	func->putPixel = GGIEXP(putPixel)[op];
	func->drawPixel = GGIEXP(drawPixel)[op];
	if (!textured)
		func->fillPixel = GGIEXP(fillPixel);
	if (op == GGI2D_NOOP) {
		func->scanline = GGIEXP(drawHLine_NOOP);
		if (!dashed) func->hLine = GGIEXP(drawHLine_NOOP);
	} else if (op == GGI2D_INVERT) {
		func->scanline = GGIEXP(drawHLine_INVERT);
		if (!dashed) func->hLine = GGIEXP(drawHLine_INVERT);
	} else {
		func->scanline = GGIEXP(scanline);
		if (!dashed) func->hLine = GGIEXP(hLine);
	}
	if (!textured && op == GGI2D_SET)
		func->fillRect = GGIEXP(fillRect_SET);
}

int GGILIB_INIT(ggi_visual_t visual, const char *version)
{
	DPRINT("initializing 2d " TARGETNAME "\n");
	GGI2DregisterUpdateFunc(visual, update, 
		GGI2D_UPD_LINEMODE + 
		GGI2D_UPD_APPENDMODE + 
		GGI2D_UPD_TEXTUREMODE + 
		GGI2D_UPD_OPERATOR);
	return 0;
}

int GGILIB_CLEANUP(ggi_visual_t visual)
{
	return 0;
}
		
/*----------------------------------------------------------------------*/
