/* $Id: patchlib.c,v 1.2 1998/09/20 15:37:26 emarty Exp $
***************************************************************************

   Alter the path to the config file in binary libggi

   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]
  
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h> 
#include <sys/stat.h>

void print_usage(char *fname)
{
        fprintf(stderr, "Usage : %s libggi.so-filename [new_path_to_patch_in]\n", fname);
        fprintf(stderr, "        Output will be located in libggi.so.patched\n");
}

static char tag[]="TaG1";
static char *newname = "libggi.so.patched";

int main(int argc, char *argv[])
{
        int size;
        int fd;
        struct stat st;
        char *solib;
        char *path;
        int   offset=0;;
        
        if (argc<2) {
                print_usage(argv[0]);
                exit(0);
        }
        fd=open(argv[1], O_RDWR);
        if ((fd=open(argv[1], O_RDWR)) < 0 ||
            fstat(fd, &st) != 0 ||
            (solib=malloc(size=st.st_size)) == NULL ||
            read(fd, solib, size) < size) {
                perror(argv[1]);
                exit(1);
        }
        close(fd);
        path=solib;
        while ((path=memchr(path, tag[0], size-offset)) != NULL) {
                if (memcmp(path, tag, strlen(tag)) == 0) {
                        path += 4;
                        offset = path-solib;
                        break;
                }
                path++;
                offset = path-solib;
        }
        printf("Currently compiled in path (at %d) is :\n%s\n", offset, path);

        if (argc == 2) {
                fprintf(stderr, "No new path given. No new file generated.\n");
                exit(1);
        }
        strncpy(path, argv[2], 256);
        
        if ((fd=creat(newname, st.st_mode)) < 0 ||
             write(fd, solib, size) < size) {
                perror(newname);
                exit(1);
        }
        printf("New path (at %d) in libggi.so.patched is :\n%s\n", offset, argv[2]);
        return 0;
}
