/* 
   Graphics library for GGI.

   Copyright (C) 1998 Steve Cheng <steve@ggi-project.org>

   If you do any modifications, I would like you to send diffs to me
   to allow for collecting a more and more complete set of drivers and
   to improve existing ones.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <ggi/internal/ggi-dl.h>
#include "misc_int.h"
#include "vgavisual.h"
#include "svgamisc.h"

#if defined(__linux__) && defined (WANT_DANGEROUS_SPLITLINE)
#include <asm/io.h>
#endif

int GGIdlinit(ggi_visual *vis,const char *args,void *ptr)
{
	LIBGGI_MISCEXT(vis)->private
		= _ggi_malloc(sizeof(struct svgamisc_priv));
#if defined(__linux__) && defined (WANT_DANGEROUS_SPLITLINE)
	{
#define	MISCr	0x03CC
#define	MISCw	0x03C2
#define	CRTIm	0x03B4
#define CRTIc	0x03D4
#define CRTDm	0x03B5
#define	CRTDc	0x03D5
#define	MISC_COLOR_IO	0x01
	int tmp = inb(MISCr);
	outb(tmp, MISCw);
	if (tmp & MISC_COLOR_IO) { 
		SVGAMISC_PRIV(vis)->CRTI = CRTIc;
		SVGAMISC_PRIV(vis)->CRTD = CRTDc; 
	} else {
		SVGAMISC_PRIV(vis)->CRTI = CRTIm;
		SVGAMISC_PRIV(vis)->CRTD = CRTDm;
	}
	}
	LIBGGI_MISCEXT(vis)->setsplitline=GGIsetsplitline;
#endif
	LIBGGI_MISCEXT(vis)->waitraypos=GGIwaitraypos;

	return GGI_DL_EXTENSION;
}

int GGIdlcleanup(ggi_visual *vis)
{
	free(LIBGGI_MISCEXT(vis)->private);
	return 0;
}

#include <ggi/internal/ggidlinit.h>
