/* $Id: vline.c,v 1.9 1998/09/25 21:33:20 becka Exp $
***************************************************************************

   SVGAlib target vgagl helper: vertical lines

   Copyright (C) 1998 Marcus Sundberg   [marcus@ggi-project.org]
   Copyright (C) 1997 Jason McMullan    [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck      [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include "vgaglvis.h"

/********************************/
/* draw a vertical line */
/********************************/

int GGI_vgagl_drawvline(ggi_visual *vis,int x,int y,int height)
{
	/* Clipping */
	if (x< (LIBGGI_GC(vis)->cliptl.x) ||
	    x>=(LIBGGI_GC(vis)->clipbr.x)) return 0;
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		height-=diff;
	}
	if (y+height>(LIBGGI_GC(vis)->clipbr.y)) {
		height=(LIBGGI_GC(vis)->clipbr.y)-y;
	}
	if (height<1)
		return 0;
	
	gl_line(x,y,x,y+height-1,LIBGGI_GC_FGCOLOR(vis));
	return 0;
}

int GGI_vgagl_drawvline_nc(ggi_visual *vis,int x,int y,int height)
{
	gl_line(x,y,x,y+height-1,LIBGGI_GC_FGCOLOR(vis));	
	return 0;
}

int GGI_vgagl_putvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{
        /* Clipping */
	if (x< (LIBGGI_GC(vis)->cliptl.x) ||
		x>=(LIBGGI_GC(vis)->clipbr.x)) return 0;
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		height-=diff;
		buffer =((char *)buffer)+diff;
	}
	if (y+height>(LIBGGI_GC(vis)->clipbr.y)) {
		height=(LIBGGI_GC(vis)->clipbr.y)-y;
	}
	
	if (height>0) {
        gl_putbox(x, y, 1, height, buffer);
	}
	return 0;
}

int GGI_vgagl_getvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{
	gl_getbox(x, y, 1, height, buffer);

	return 0;
}
