/* $Id: mode.c,v 1.2 1998/10/28 01:55:15 ajapted Exp $
***************************************************************************

   Display-VCSA: mode management

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <dlfcn.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <ggi/internal/ggi-dl.h>

#include "../common/ggi-auto.inc"

#include "vcsahook.h"


int GGI_vcsa_getapi(ggi_visual *vis, int num, char *apiname, char *arguments)
{
	strcpy(arguments, "");

	switch(num) {
		case 0: strcpy(apiname, "display-vcsa");
			return 0;

		case 1: strcpy(apiname, "generic-stubs");
			return 0;
	}

	return -1;
}

int GGI_vcsa_setmode(ggi_visual *vis, ggi_mode *mode)
{ 
	char libname[256], libargs[256];

	int err, id;


        if ((err = ggiCheckMode(vis, mode)) != 0) {
		return err;
	}

	DPRINT_MODE("display-vcsa: setmode %dx%d#%dx%dF%d[0x%02x]\n",
			mode->visible.x, mode->visible.y,
			mode->virt.x, mode->virt.y, 
			mode->frames, mode->graphtype);

	memcpy(LIBGGI_MODE(vis), mode, sizeof(ggi_mode));

	_ggiZapMode(vis, ~GGI_DL_OPDISPLAY);

	
	/* load API libraries */

	for(id=1; GGI_vcsa_getapi(vis, id, libname, libargs) == 0; id++) {

		if (_ggiOpenDL(vis, libname, libargs, NULL) == NULL) {

			fprintf(stderr,"display-vcsa: Error opening the "
				"%s (%s) library.\n", libname, libargs);
			return -1;
		}

		DPRINT_LIBS("Success in loading %s (%s)\n", libname, libargs);
	}

	/* setup drawing primitives */

	vis->opdraw->putpixel_nc = GGI_vcsa_putpixel_nc;
	vis->opdraw->getpixel    = GGI_vcsa_getpixel;
	vis->opdraw->putc        = GGI_vcsa_putc;
	vis->opdraw->getcharsize = GGI_vcsa_getcharsize;

	vis->opcolor->mapcolor   = GGI_vcsa_mapcolor;
	vis->opcolor->unmappixel = GGI_vcsa_unmappixel;


	/* indicate API change */

	ggiIndicateChange(vis, GGI_CHG_APILIST);

	DPRINT_MODE("display-vcsa: setmode Success.\n");

	return 0;
}

int GGI_vcsa_resetmode(ggi_visual *vis)
{
	/* Nothing to do .. */

	return 0;
}
	
int GGI_vcsa_checkmode(ggi_visual *vis, ggi_mode *mode)
{
	VcsaHook *vv = VCSA_HOOK(vis);

	int err;

	
	DPRINT_MODE("display-vcsa: checkmode %dx%d#%dx%dF%d[0x%02x]\n",
			mode->visible.x, mode->visible.y,
			mode->virt.x, mode->virt.y, 
			mode->frames, mode->graphtype);


	/* handle GT_AUTO in graphtype */

	if (GT_SCHEME(mode->graphtype) == GT_AUTO) {
		GT_SETSCHEME(mode->graphtype, GT_TEXT);
	}
	if (GT_DEPTH(mode->graphtype) == GT_AUTO) {
		GT_SETDEPTH(mode->graphtype, 4);
	}
	if (GT_SIZE(mode->graphtype) == GT_AUTO) {
		GT_SETSIZE(mode->graphtype, 16);
	}


	/* handle GGI_AUTO in ggi_mode */

	if (mode->dpp.x == GGI_AUTO) {
		mode->dpp.x = 1;
	}
	if (mode->dpp.y == GGI_AUTO) {
		mode->dpp.y = 1;
	}

	_GGIhandle_ggiauto(mode, vv->width, vv->height);


	/* now check stuff */

	err = 0;

	if (GT_SCHEME(mode->graphtype) != GT_TEXT) {
		GT_SETSCHEME(mode->graphtype, GT_TEXT);
		err--;
	}
	if (GT_DEPTH(mode->graphtype) != 4) {
		GT_SETDEPTH(mode->graphtype, 4);
		err--;
	}
	if (GT_SIZE(mode->graphtype) != 16) {
		GT_SETSIZE(mode->graphtype, 16);
		err--;
	}

	if (mode->visible.x != vv->width) {
		mode->visible.x = vv->width;
		err--;
	}
	if (mode->visible.y != vv->height) {
		mode->visible.y = vv->height;
		err--;
	}
	if (mode->virt.x != vv->width) {
		mode->virt.x = vv->width;
		err--;
	}
	if (mode->virt.y != vv->height) {
		mode->virt.y = vv->height;
		err--;
	}

	if (mode->frames != 1) {
		mode->frames = 1;
		err--;
	}
		
	DPRINT_MODE("display-vcsa: result %d %dx%d#%dx%dF%d[0x%02x]\n",
			err, mode->visible.x, mode->visible.y,
			mode->virt.x, mode->virt.y, 
			mode->frames, mode->graphtype);
	return err;
}

int GGI_vcsa_getmode(ggi_visual *vis, ggi_mode *mode)
{
	DPRINT_MODE("display-vcsa: getmode\n");
	
	memcpy(mode, LIBGGI_MODE(vis), sizeof(ggi_mode));

	return 0;
}

int GGI_vcsa_setflags(ggi_visual *vis, ggi_flags flags)
{
	LIBGGI_FLAGS(vis) = flags;

	return 0;
}
