/* $Id: genblit.c,v 1.4 1998/10/10 13:21:32 ajapted Exp $
***************************************************************************

   Display-trueemu : genblit

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/


/**************************************************
 ***
 ***  Generic blit functions
 ***
 ***  (this file is #included by others)
 ***
 **************************************************/


#define HICOL_DITHER(dn)  \
	th->R[src[R_OFF]][dn] | th->G[src[G_OFF]][dn] |  \
	th->B[src[B_OFF]][dn]

#define PAL_DITHER(dn,off)  \
	th->T[(((int) src[R_OFF+(off)] & 0xf8) << 7) |  \
	      (((int) src[G_OFF+(off)] & 0xf8) << 2) |  \
	      (((int) src[B_OFF+(off)] & 0xf8) >> 3)] [dn]


/* NOTE:
 *	We guarantee that these blitting routines always start on an
 *	even pixel column.
 *
 * NOMENCLATURE:
 *	b32 (for example) refers to 32 bits per pixel.
 *	d4  (for example) refers to four pixel dithering.
 *	od == odd and ev == even (the dither row).
 */


/* ==== 32 bit ==== */

static BLITFUNC(_ggi_trueemu_blit_b32_d0)
{
	uint8 *dest = dest_raw;

	for (; width > 0; width--) {
		*dest++ = src[B_OFF];  /* blue */
		*dest++ = src[G_OFF];  /* green */
		*dest++ = src[R_OFF];  /* red */
		*dest++ = 0;
		src += SRC_STEP;
	}
}


/* ==== 24 bit ==== */

static BLITFUNC(_ggi_trueemu_blit_b24_d0)
{
	uint8 *dest = dest_raw;

	for (; width > 0; width--) {
		*dest++ = src[B_OFF];  /* blue */
		*dest++ = src[G_OFF];  /* green */
		*dest++ = src[R_OFF];  /* red */
		src += SRC_STEP;
	}
}


/* ==== 16 bit ==== */

static BLITFUNC(_ggi_trueemu_blit_b16_d0)
{
	uint16 *dest = dest_raw;

	for (; width > 0; width--) {
		*dest++ = HICOL_DITHER(0); src += SRC_STEP;
	}
}

static BLITFUNC(_ggi_trueemu_blit_b16_d2_ev)
{
	uint16 *dest = dest_raw;

	for (; width > 1; width -= 2) {
		*dest++ = HICOL_DITHER(0); src += SRC_STEP;
		*dest++ = HICOL_DITHER(1); src += SRC_STEP;
	}

	if (width == 1) {
		*dest = HICOL_DITHER(0); src += SRC_STEP;
	}
}

static BLITFUNC(_ggi_trueemu_blit_b16_d2_od)
{
	uint16 *dest = dest_raw;

	for (; width > 1; width -= 2) {
		*dest++ = HICOL_DITHER(1); src += SRC_STEP;
		*dest++ = HICOL_DITHER(0); src += SRC_STEP;
	}

	if (width == 1) {
		*dest = HICOL_DITHER(1); src += SRC_STEP;
	}
}

static BLITFUNC(_ggi_trueemu_blit_b16_d4_ev)
{
	uint16 *dest = dest_raw;

	for (; width > 1; width -= 2) {
		*dest++ = HICOL_DITHER(0); src += SRC_STEP;
		*dest++ = HICOL_DITHER(2); src += SRC_STEP;
	}

	if (width == 1) {
		*dest = HICOL_DITHER(0); src += SRC_STEP;
	}
}

static BLITFUNC(_ggi_trueemu_blit_b16_d4_od)
{
	uint16 *dest = dest_raw;

	for (; width > 1; width -= 2) {
		*dest++ = HICOL_DITHER(3); src += SRC_STEP;
		*dest++ = HICOL_DITHER(1); src += SRC_STEP;
	}

	if (width == 1) {
		*dest = HICOL_DITHER(3); src += SRC_STEP;
	}
}


/* ==== 8 bit ==== */

static BLITFUNC(_ggi_trueemu_blit_b8_d0)
{
	uint8 *dest = dest_raw;

	for (; width > 0; width--) {
		*dest++ = PAL_DITHER(0, 0); src += SRC_STEP;
	}
}

static BLITFUNC(_ggi_trueemu_blit_b8_d2_ev)
{
	uint8 *dest = dest_raw;

	for (; width > 1; width -= 2) {
		*dest++ = PAL_DITHER(0, 0); src += SRC_STEP;
		*dest++ = PAL_DITHER(1, 0); src += SRC_STEP;
	}

	if (width == 1) {
		*dest = PAL_DITHER(0, 0); src += SRC_STEP;
	}
}

static BLITFUNC(_ggi_trueemu_blit_b8_d2_od)
{
	uint8 *dest = dest_raw;

	for (; width > 1; width -= 2) {
		*dest++ = PAL_DITHER(1, 0); src += SRC_STEP;
		*dest++ = PAL_DITHER(0, 0); src += SRC_STEP;
	}

	if (width == 1) {
		*dest = PAL_DITHER(1, 0); src += SRC_STEP;
	}
}

static BLITFUNC(_ggi_trueemu_blit_b8_d4_ev)
{
	uint8 *dest = dest_raw;

	for (; width > 1; width -= 2) {
		*dest++ = PAL_DITHER(0, 0); src += SRC_STEP;
		*dest++ = PAL_DITHER(2, 0); src += SRC_STEP;
	}

	if (width == 1) {
		*dest = PAL_DITHER(0, 0); src += SRC_STEP;
	}
}

static BLITFUNC(_ggi_trueemu_blit_b8_d4_od)
{
	uint8 *dest = dest_raw;

	for (; width > 1; width -= 2) {
		*dest++ = PAL_DITHER(3, 0); src += SRC_STEP;
		*dest++ = PAL_DITHER(1, 0); src += SRC_STEP;
	}

	if (width == 1) {
		*dest = PAL_DITHER(3, 0); src += SRC_STEP;
	}
}


/* ==== 4 bit ==== */

static BLITFUNC(_ggi_trueemu_blit_b4_d0)
{
	uint8 *dest = dest_raw;

	for (; width > 1; width -= 2) {
		*dest++ = (PAL_DITHER(0, 0)) | 
			  (PAL_DITHER(0, SRC_STEP) << 4);
		src += SRC_STEP*2;
	}

	if (width == 1) {
		*dest = PAL_DITHER(0, 0);
	}
}

static BLITFUNC(_ggi_trueemu_blit_b4_d2_ev)
{
	uint8 *dest = dest_raw;

	for (; width > 1; width -= 2) {
		*dest++ = (PAL_DITHER(0, 0)) | 
			  (PAL_DITHER(1, SRC_STEP) << 4);
		src += SRC_STEP*2;
	}

	if (width == 1) {
		*dest = PAL_DITHER(0, 0);
	}
}

static BLITFUNC(_ggi_trueemu_blit_b4_d2_od)
{
	uint8 *dest = dest_raw;

	for (; width > 1; width -= 2) {
		*dest++ = (PAL_DITHER(1, 0)) | 
			  (PAL_DITHER(0, SRC_STEP) << 4);
		src += SRC_STEP*2;
	}

	if (width == 1) {
		*dest = PAL_DITHER(1, 0);
	}
}

static BLITFUNC(_ggi_trueemu_blit_b4_d4_ev)
{
	uint8 *dest = dest_raw;

	for (; width > 1; width -= 2) {
		*dest++ = (PAL_DITHER(0, 0)) | 
			  (PAL_DITHER(2, SRC_STEP) << 4);
		src += SRC_STEP*2;
	}

	if (width == 1) {
		*dest = PAL_DITHER(0, 0);
	}
}

static BLITFUNC(_ggi_trueemu_blit_b4_d4_od)
{
	uint8 *dest = dest_raw;

	for (; width > 1; width -= 2) {
		*dest++ = (PAL_DITHER(3, 0)) | 
			  (PAL_DITHER(1, SRC_STEP) << 4);
		src += SRC_STEP*2;
	}

	if (width == 1) {
		*dest = PAL_DITHER(3, 0);
	}
}
