/* $Id: frames.c,v 1.1 1998/10/10 13:21:29 ajapted Exp $
***************************************************************************

   Display-trueemu: frame handling

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "trueemu.h"


int GGI_trueemu_setreadframe(ggi_visual *vis, int num)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	
	return th->mem_opdraw->setreadframe(vis, num);
}

int GGI_trueemu_setwriteframe(ggi_visual *vis, int num)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);

	/* !!! probably some stuff needed WRT the dirty region */

	return th->mem_opdraw->setwriteframe(vis, num);
}

int GGI_trueemu_setdisplayframe(ggi_visual *vis, int num)
{
	/* TrueemuHook *th = TRUEEMU_PRIV(vis); */

        ggi_directbuffer *db = _ggi_db_find_frame(vis, num);

        if (db == NULL) {
                return -1;
        }

        vis->d_frame_num = num;

	_ggi_trueemu_Transfer(vis, 0, 0, LIBGGI_VIRTX(vis), LIBGGI_VIRTY(vis));

	/* !!! probably some stuff needed WRT the dirty region */

	return 0;
}
