/* $Id: events.c,v 1.18 1998/10/30 05:13:41 ajapted Exp $
***************************************************************************

   Display-trueemu : events

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <string.h>
#include <stdlib.h>

#include <ggi/internal/ggi-dl.h>

#include "trueemu.h"


static void cycle_dither(ggi_visual *vis)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	
	int old_dith = th->flags & TE_DITHER_MASK;

	th->flags &= ~TE_DITHER_MASK;

	switch (old_dith)
	{
		case TRUEEMU_F_DITHER_0:
			th->flags |= TRUEEMU_F_DITHER_2;
			break;

		case TRUEEMU_F_DITHER_2:
			th->flags |= TRUEEMU_F_DITHER_4;
			break;

		default:
			th->flags |= TRUEEMU_F_DITHER_0;
			break;
	}

	_ggi_trueemu_NewMode(vis);
}

static void cycle_palette(ggi_visual *vis)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	
	int old_pal = th->flags & TE_PALETTE_MASK;

	th->flags &= ~TE_PALETTE_MASK;

	switch (old_pal)
	{
		case TRUEEMU_F_RGB:
			th->flags |= TRUEEMU_F_CUBE;
			break;

		case TRUEEMU_F_CUBE:
			th->flags |= TRUEEMU_F_PASTEL;
			break;

		default:
			th->flags |= TRUEEMU_F_RGB;
			break;
	}

	_ggi_trueemu_NewMode(vis);
}


static int handle_special_events(ggi_visual *vis, ggi_event *ev)
{
	/* returns: 1 if swallows event, 0 otherwise */

	if (ev->any.type == evExpose) {
		_ggi_trueemu_NewMode(vis);
		return 1;
	}

	/* handle hot-keys */
	
	if ((ev->any.type == evKeyPress) &&
	    ((ev->key.effect & GII_KM_CTRL) != 0) &&
	    ((ev->key.effect & GII_KM_ALT)  != 0)) {

		switch (ev->key.label) {
			
			case 'D':
				cycle_dither(vis);
				return 1;
			
			case 'P':
				cycle_palette(vis);
				return 1;
		}
	}

	return 0;
}


/* ---------------------------------------------------------------------- */


#include "../common/evqueue.inc"

ggi_event_mask GGI_trueemu_eventpoll(ggi_visual_t vis, ggi_event_mask mask,
			    struct timeval *t)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);

	ggi_event_mask evmask;


	DPRINT("display-trueemu: eventpoll mask=0x%08x ", mask);

	if (t == NULL) {
		DPRINT("timeout=NULL\n");
	} else {
		DPRINT("timeout=(%d,%d)\n", t->tv_sec, t->tv_usec);
	}


	for (evmask = _ggiEvQueueSeen(vis, mask);
	     evmask == 0;
	     evmask = _ggiEvQueueSeen(vis, mask)) {

		ggi_event ev;

		ggi_event_mask par_mask;

		par_mask = ggiEventPoll(th->parent,
					mask | emKeyPress | emExpose, t);

		/* handle event */

		if (par_mask) {
			ggiEventRead(th->parent, &ev,
				     mask | emKeyPress | emExpose);
			if (!handle_special_events(vis, &ev)) {
				_ggiEvQueueAdd(vis, &ev);
			}
			if (!(par_mask & mask) 
			    && (t->tv_sec < 0
				|| (t->tv_usec <= 0 && t->tv_sec == 0))) {
				/* timeout */
				return 0;
			}
		} else {
			/* timeout */
			return 0;
		}
	}
	
	return evmask;
}

int GGI_trueemu_eventread(ggi_visual_t vis, ggi_event *ev, ggi_event_mask mask)
{
	/* Block if we don't have anything queued... */
	
	GGI_trueemu_eventpoll(vis, mask, NULL);

	return _ggiEvQueueRelease(vis, ev, mask);
}
