/* $Id: color.c,v 1.7 1998/09/23 21:35:05 marcus Exp $
***************************************************************************

   Tile target: color management

   Copyright (C) 1998 Steve Cheng    [steve@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "tilevisual.h"

ggi_pixel GGI_tile_mapcolor(ggi_visual *vis,ggi_color *col)
{
	return ggiMapColor(TILE_PRIV(vis)->vislist[0], col);
}

int GGI_tile_unmappixel(ggi_visual *vis,ggi_pixel pixel,ggi_color *col)
{
	return ggiUnmapPixel(TILE_PRIV(vis)->vislist[0], pixel, col);
}

int GGI_tile_setpalvec(ggi_visual *vis,int start,int len,ggi_color *colormap)
{
	struct TileHooks *tilehook = TILE_PRIV(vis);
	int i;
	for(i = 0; i<tilehook->numvis; i++)
		if(ggiSetPalette(tilehook->vislist[i], start, len, colormap))
			return -1;

	return 0;
}

int GGI_tile_getpalvec(ggi_visual *vis,int start,int len,ggi_color *colormap)
{
	return ggiGetPalette(TILE_PRIV(vis)->vislist[0], start, len, colormap);
}
