/* $Id: text.c,v 1.4 1998/09/25 21:33:00 becka Exp $
***************************************************************************

   TELE target.

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <dlfcn.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/mman.h>

#include <ggi/internal/ggi-dl.h>
#include <ggi/internal/font/8x8>

#include "libtele.h"
#include "telehook.h"


int GGI_tele_getcharsize(ggi_visual *vis, int *width, int *height)
{
	*width = *height = 8;
	return 0;
}

int GGI_tele_putc(ggi_visual *vis, int x, int y, char c)
{
	/* !!! use CMD_PUTSTR */

	uint8 pixbuf[8*8];

	int cx, cy;

	uint8 *ch_data = & font[((int) c & 0xff) << 3];

	for (cy=0; cy < 8; cy++)
	for (cx=0; cx < 8; cx++) {
		
		pixbuf[(cy << 3) + cx] = (ch_data[cy] & (1 << (7-cx))) ?
			LIBGGI_GC_FGCOLOR(vis) : LIBGGI_GC_BGCOLOR(vis);
	}

	return ggiPutBox(vis, x, y, 8, 8, pixbuf);
}

/* !!! Implement GGIputs() with CMD_PUTSTR */

