/* $Id: visual.c,v 1.17 1998/10/24 04:03:45 marcus Exp $
***************************************************************************

   Display-memory: mode management

   Copyright (C) 1995 Andreas Beck      [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan    [jmcc@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdlib.h>
#include <string.h>

#include "memvisual.h"

static gg_option memory_options[1] =
{
	{ "input", "" }
};

ggi_event_mask GII_memory_poll(gii_input_t inp)
{
	struct memhooks *hook=inp->priv;
	ggi_event *ev;
	int rc=0;
	
	while(hook->inputoffset!=hook->inputbuffer->writeoffset)
	{
		if (hook->inputbuffer->buffer[hook->inputoffset++]!=MEMINPMAGIC)
		{
			DPRINT_MISC("OUT OF SYNC in meminput !\n");
			hook->inputoffset=0;	/* Try to resync */
			return 0;
		}
		ev=(ggi_event *)&(hook->inputbuffer->buffer[hook->inputoffset]);
		_giiEvQueueAdd(inp,ev);
		hook->inputoffset+=ev->any.size;
		rc|=1<<ev->any.type;
		if (hook->inputoffset>=INPBUFSIZE-sizeof(ggi_event)-sizeof(hook->inputbuffer->writeoffset)-10)
			hook->inputoffset=0;
	}
	return rc;
}

int GII_memory_send(gii_input_t inp, ggi_event *event)
{
	struct memhooks *hook=inp->priv;
	int size;
	
	hook->inputbuffer->buffer[hook->inputbuffer->writeoffset++]=MEMINPMAGIC;
	memcpy(&(hook->inputbuffer->buffer[hook->inputbuffer->writeoffset]),
		event,size=event->any.size);
	hook->inputbuffer->writeoffset+=size;
	if (hook->inputbuffer->writeoffset>=INPBUFSIZE-sizeof(ggi_event)-sizeof(hook->inputbuffer->writeoffset)-10)
		hook->inputbuffer->writeoffset=0;
	hook->inputbuffer->buffer[hook->inputbuffer->writeoffset]=MEMINPMAGIC-1;	/* "break"-symbol */

	return 0;
}


int GGIdlinit(ggi_visual *vis,const char *args,void *argptr)
{
	LIBGGI_FD(vis)=-1;

	LIBGGI_GC(vis) = _ggi_malloc(sizeof(ggi_gc));

	DPRINT("display-memory coming up.\n");
	
	/* Allocate descriptor for screen memory */
	LIBGGI_PRIVATE(vis)=malloc(sizeof(struct memhooks));
	MEMLIB_PRIV(vis)->memtype=MT_MALLOC;	/* Default to mallocing. */
	MEMLIB_PRIV(vis)->inputbuffer=NULL;	/* Default to no input */
	MEMLIB_PRIV(vis)->inputoffset=0;	/* Setup offset. */

	if (args) {
		args = ggParseOptions((char *) args, memory_options, 1);
		if (args == NULL) {
			fprintf(stderr, "display-memory: error in "
				"arguments.\n");
		}
	}

	if (args && *args)	/* We have parameters. Analyze them. */
	{
		DPRINT("display-memory has args.\n");
#ifdef HAVE_SHM
		if (strncmp(args,"shmid:",6)==0)
		{
			sscanf(args+6,"%i",&(MEMLIB_PRIV(vis)->shmid));
			DPRINT("display-memory has shmid-arg:%d.\n",
				MEMLIB_PRIV(vis)->shmid);
			MEMLIB_PRIV(vis)->memptr=shmat(MEMLIB_PRIV(vis)->shmid,NULL,0);
			DPRINT("display-memory: shmat at %p.\n",
				MEMLIB_PRIV(vis)->memptr);
			if (MEMLIB_PRIV(vis)->memptr!=(void *)-1) 
			{
				MEMLIB_PRIV(vis)->memtype=MT_SHMID;
				if (memory_options[0].result[0])
				{
					MEMLIB_PRIV(vis)->inputbuffer=MEMLIB_PRIV(vis)->memptr;
					MEMLIB_PRIV(vis)->memptr=(char *)MEMLIB_PRIV(vis)->memptr+INPBUFSIZE;
					DPRINT("display-memory: moved mem to %p for input-buffer.\n",
						MEMLIB_PRIV(vis)->memptr);
				}
			}
		}
		else if (strncmp(args,"keyfile:",8)==0)
		{
			int size;
			char id;
			char filename[1024];

			sscanf(args+8,"%d:%c:%s",&size,&id,filename);
			DPRINT("display-memory has keyfile-arg:%d:%c:%s.\n",
				size,id,filename);

			MEMLIB_PRIV(vis)->shmid=shmget(ftok(filename,id), size, IPC_CREAT|0666);
			DPRINT("display-memory has shmid:%d.\n",
				MEMLIB_PRIV(vis)->shmid);

			MEMLIB_PRIV(vis)->memptr=shmat(MEMLIB_PRIV(vis)->shmid,NULL,0);
			DPRINT("display-memory: shmat at %p.\n",
				MEMLIB_PRIV(vis)->memptr);
			if (MEMLIB_PRIV(vis)->memptr!=(void *)-1) 
			{
				MEMLIB_PRIV(vis)->memtype=MT_SHMID;
				if (memory_options[0].result[0])
				{
					MEMLIB_PRIV(vis)->inputbuffer=MEMLIB_PRIV(vis)->memptr;
					MEMLIB_PRIV(vis)->memptr=(char *)MEMLIB_PRIV(vis)->memptr+INPBUFSIZE;
					DPRINT("display-memory: moved mem to %p for input-buffer.\n",
						MEMLIB_PRIV(vis)->memptr);
				}
			}
		}
#endif
		else if (strncmp(args,"pointer",7)==0)
		{
			MEMLIB_PRIV(vis)->memptr = argptr;
			if (MEMLIB_PRIV(vis)->memptr)
				MEMLIB_PRIV(vis)->memtype=MT_EXTERN;
		}
	}

	vis->opdisplay->getmode=GGI_memory_getmode;
	vis->opdisplay->setmode=GGI_memory_setmode;
	vis->opdisplay->getapi=GGI_memory_getapi;
	vis->opdisplay->checkmode=GGI_memory_checkmode;
	vis->opdisplay->setflags=GGI_memory_setflags;

	if (MEMLIB_PRIV(vis)->inputbuffer)
	{
		gii_input *inp;
		DPRINT_MISC("Adding gii to shmem-memtarget\n");

		/* First allocate a new gii_input descriptor. */

		if (NULL==(inp=_giiInputAlloc()))
		{
			DPRINT_MISC("giiInputAlloc failure.\n");
			goto out;
		}
		DPRINT_MISC("gii inp=%p\n",inp);

		/* Now fill in the blanks. */

		inp->priv=MEMLIB_PRIV(vis);	/* We need that in poll() */
		MEMLIB_PRIV(vis)->inputbuffer->writeoffset=0;	/* Not too good, but ... */
		inp->targetcan= emAll;
		inp->GIIseteventmask(inp,inp->targetcan);
		inp->maxfd=0;	/* This is polled. */

		inp->GIIeventpoll=GII_memory_poll;
		inp->GIIsendevent=GII_memory_send;

		/* Now join the new event source in. */
		vis->input=giiJoinInputs(vis->input,inp);
		out:
		{};
	}
	
	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	_GGI_memory_resetmode(vis);

	switch(MEMLIB_PRIV(vis)->memtype) {
	case MT_MALLOC:
	case MT_EXTERN:	/* Nothing to be done. */
	  	break;
#ifdef HAVE_SHM		
	case MT_SHMKEYFILE: /* FIXME ? Should we RMID the area ? */
	case MT_SHMID: 
	  	shmdt(MEMLIB_PRIV(vis)->memptr);
	  	break;
#endif	
	default:
		break;
	}

	free(LIBGGI_PRIVATE(vis));
	free(LIBGGI_GC(vis));

	return 0;
}

#include <ggi/internal/ggidlinit.h>
