/* $Id: line.c,v 1.4 1998/09/24 01:24:38 marcus Exp $
***************************************************************************

   LibGGI GLIDE target - Line functions

   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include "glidevisual.h"


int
GGI_glide_drawline(ggi_visual *vis,int x,int y,int xe,int ye)
{
	GrVertex end = GLIDE_PRIV(vis)->fgvertex;
	
	GLIDE_PRIV(vis)->fgvertex.x = x;
	GLIDE_PRIV(vis)->fgvertex.y = y;
	end.x = xe;
	end.y = ye;
	
	grDrawLine(&GLIDE_PRIV(vis)->fgvertex, &end);

	return 0;
}

int
GGI_glide_drawhline(ggi_visual *vis,int x,int y,int w)
{
	GrVertex end = GLIDE_PRIV(vis)->fgvertex;
	
	GLIDE_PRIV(vis)->fgvertex.x = x;
	GLIDE_PRIV(vis)->fgvertex.y = y;
	end.x = x+w;
	end.y = y;
	
	grDrawLine(&GLIDE_PRIV(vis)->fgvertex, &end);

	return 0;
}

int
GGI_glide_drawvline(ggi_visual *vis,int x,int y,int h)
{
	GrVertex end = GLIDE_PRIV(vis)->fgvertex;
	
	GLIDE_PRIV(vis)->fgvertex.x = x;
	GLIDE_PRIV(vis)->fgvertex.y = y;
	end.x = x;
	end.y = y+h;
	
	grDrawLine(&GLIDE_PRIV(vis)->fgvertex, &end);

	return 0;
}

int
GGI_glide_puthline(ggi_visual *vis, int x, int y, int w, void *data)
{
	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) {
		return 0;
	}
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		w-=diff;
		data=((uint8 *)data)+diff*GLIDE_PRIV(vis)->bytes_per_pixel;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (w<1) return 0;

	grLfbWriteRegion(GLIDE_PRIV(vis)->writebuf, x-1, y-1,
			 GLIDE_PRIV(vis)->src_format,
			 w, 1, GLIDE_PRIV(vis)->bytes_per_pixel*w, data);

	return 0;
}

int
GGI_glide_putvline(ggi_visual *vis, int x, int y, int h, void *data)
{
	/* Clipping */
	if (x<(LIBGGI_GC(vis)->cliptl.x) || x>=(LIBGGI_GC(vis)->clipbr.x)) {
		return 0;
	}
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y+=diff;
		h-=diff;
		data=((uint8 *)data)+diff*GLIDE_PRIV(vis)->bytes_per_pixel;
	}
	if (y+h>(LIBGGI_GC(vis)->clipbr.y)) {
		h=(LIBGGI_GC(vis)->clipbr.y)-y;
	}
	if (h<1) return 0;

	grLfbWriteRegion(GLIDE_PRIV(vis)->writebuf, x-1, y-1,
			 GLIDE_PRIV(vis)->src_format,
			 1, h, GLIDE_PRIV(vis)->bytes_per_pixel, data);

	return 0;
}

int
GGI_glide_gethline(ggi_visual *vis, int x, int y, int w, void *data)
{
	grLfbReadRegion(GLIDE_PRIV(vis)->readbuf, x-1, y-1,
			 w, 1, GLIDE_PRIV(vis)->bytes_per_pixel*w, data);
	return 0;
}

int
GGI_glide_getvline(ggi_visual *vis, int x, int y, int h, void *data)
{
	grLfbReadRegion(GLIDE_PRIV(vis)->readbuf, x-1, y-1,
			 1, h, GLIDE_PRIV(vis)->bytes_per_pixel, data);

	return 0;
}
