/* $Id: gtext.c,v 1.1 1998/10/03 02:03:52 marcus Exp $
***************************************************************************

   LibGGI GLIDE target - Text functions

   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "glidevisual.h"

#include <ggi/internal/font/8x8>

#define BUFSIZE		8*8*sizeof(ggi_pixel)

static uint8 buf[BUFSIZE];

#define BITMASK		0x01

int
GGI_glide16_putc(ggi_visual *vis, int x, int y, char ch)
{
	int xc, yc;
	int h = 8;
	int w = 8;
	uint16 *data = (uint16 *) (buf + BUFSIZE);
	uint8 *fontptr = font+((uint8)ch<<3)+8;
	
	if (y< LIBGGI_GC(vis)->cliptl.y) {
		int diff=LIBGGI_GC(vis)->cliptl.y-y;
		y+=diff;
		h-=diff;
	}
	if (y+h>LIBGGI_GC(vis)->clipbr.y) {
		h=LIBGGI_GC(vis)->clipbr.y-y;
	}
	if (h<1) return 0;

	if (x< LIBGGI_GC(vis)->cliptl.x) {
		int diff=LIBGGI_GC(vis)->cliptl.x-x;
		x+=diff;
		w-=diff;
	}
	if (x+w>LIBGGI_GC(vis)->clipbr.x) {
		w=LIBGGI_GC(vis)->clipbr.x-x;
	}
	if (w<1) return 0;

	for (yc = h; yc != 0; yc--) {
		uint8 fontrow = *(--fontptr);
		data -= w-8;
		for (xc = w; xc != 0; xc--) {
			*(--data) = (fontrow & BITMASK) ? LIBGGI_GC_FGCOLOR(vis)
				: LIBGGI_GC_BGCOLOR(vis);
			fontrow >>= 1;
		}
	}

	grLfbWriteRegion(GLIDE_PRIV(vis)->writebuf, x, y,
			 GLIDE_PRIV(vis)->src_format, w, h, 16, data);
	
	return 0;
}


int
GGI_glide32_putc(ggi_visual *vis, int x, int y, char ch)
{
	int xc, yc;
	int h = 8;
	int w = 8;
	uint32 *data = (uint32 *) (buf + BUFSIZE);
	uint8 *fontptr = font+((uint8)ch<<3)+8;
	
	if (y< LIBGGI_GC(vis)->cliptl.y) {
		int diff=LIBGGI_GC(vis)->cliptl.y-y;
		y+=diff;
		h-=diff;
	}
	if (y+h>LIBGGI_GC(vis)->clipbr.y) {
		h=LIBGGI_GC(vis)->clipbr.y-y;
	}
	if (h<1) return 0;

	if (x< LIBGGI_GC(vis)->cliptl.x) {
		int diff=LIBGGI_GC(vis)->cliptl.x-x;
		x+=diff;
		w-=diff;
	}
	if (x+w>LIBGGI_GC(vis)->clipbr.x) {
		w=LIBGGI_GC(vis)->clipbr.x-x;
	}
	if (w<1) return 0;

	for (yc = h; yc != 0; yc--) {
		uint8 fontrow = *(--fontptr);
		data -= w-8;
		for (xc = w; xc != 0; xc--) {
			*(--data) = (fontrow & BITMASK) ? LIBGGI_GC_FGCOLOR(vis)
				: LIBGGI_GC_BGCOLOR(vis);
			fontrow >>= 1;
		}
	}

	grLfbWriteRegion(GLIDE_PRIV(vis)->writebuf, x, y,
			 GLIDE_PRIV(vis)->src_format, w, h, 32, data);
	
	return 0;
}
