/* $Id: events.c,v 1.12 1998/10/26 12:09:28 marcus Exp $
***************************************************************************

   Graphics library for GGI.  Events for AA target.

   Copyright (C) 1997 Andreas Beck    [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdlib.h>
#include <string.h>

#include "aavisual.h"
#define WANT__NewEvent
#include "../common/evqueue.inc"

#define LATIN_KEY(x)    (x)

/************************** GGI Functions ***************************/
/* Event Handling */
ggi_event_mask GGI_aa_eventpoll(ggi_visual_t vis,ggi_event_mask mask,
			    struct timeval *t)
{

#define BUFFER_SIZE (sizeof(ggi_event)*4)
	unsigned int n;
	int x,y,b;
	ggi_event_mask evmask;
	ggi_event ggievent;
	struct AAhooks *aahook=LIBGGI_PRIVATE(vis);
	int lx = aahook->lx;
	int ly = aahook->ly;
	int lb = aahook->lb;
	unsigned int lastkey = aahook->lastkey;
	unsigned int lastkeyticks = aahook->lastkeyticks;


DPRINT("GGIeventpoll(%p,0x%.8x",vis,mask);
if (t==NULL) {
	DPRINT(",NULL)\n");
} else {
	DPRINT(",{%d,%d})\n",t->tv_sec,t->tv_usec);
}

	if (! aahook->context) return 0;
	evmask=_ggiEvQueueSeen(vis,mask);
	if (evmask!=0)  
		return evmask;

	do {
		__NewEvent(&ggievent);

		n=aa_getevent(aahook->context, 0);
		DPRINT("got event %x\n",n);

		if (n==AA_MOUSE)
		{
		  aa_getmouse(aahook->context, &x, &y, &b );
		  ggievent.any.type=evPtrRelative;
		  ggievent.pmove.x=x-lx;lx=x;
		  ggievent.pmove.y=y-lx;ly=y;
		  if (b!=lb)
		  {
		    if ( (b^lb) & b ) {
			  ggievent.any.type=evPtrButtonPress;
			  ggievent.pbutton.state=b;
			  ggievent.pbutton.button=b^lb;
			  lb=b;
		    } else {
			  ggievent.any.type=evPtrButtonRelease;
			  ggievent.pbutton.state=b;
			  ggievent.pbutton.button=b^lb;
			  lb=b;
		    }
		  }
		}
		else if ( n==AA_NONE ) 
		{
			/* ok, if there was a key down, it's now up */
			if (lastkey)
			{
				if(lastkeyticks > 3) /* lastkeyticks - kludge */
				{
	/* fprintf(stderr, "Implied release event %x %c %d, %x %c %d\n", n,n,n,
			lastkey, lastkey, lastkey); */

					ggievent.any.type=evKeyRelease;
					ggievent.key.sym =lastkey;
					ggievent.key.button=lastkey;
					lastkey = 0;
					lastkeyticks = 0;
				} else
				{
					lastkeyticks++;
				}
			}
			else
			{
				/* do nothing */
			}
		} 
		else if ( n==AA_RESIZE || n==AA_UNKNOWN )
		{
		  /* Do nothing - not implemented. */
		}
		else if (n>=1&&n<=AA_RELEASE)
		{
			/* ok, check lastkey */
			if(lastkey == 0)
			{
				/* fprintf(stderr, "Press event %x %c %d\n", n,n,n);*/
				ggievent.any.type=evKeyPress;
				ggievent.key.sym=n;
				ggievent.key.button=n;
				lastkey = n;
				lastkeyticks = 0;
			}
			else if(lastkey == n)
			{
				/* do nothing - key still down*/
				lastkeyticks++;
			}
			else
			{
				/* whoops!  different key!  We send a release,
				   then we catch the keypress next time around.
				   ** KLUDGE ** */
				/* fprintf(stderr, "Forced release event %x %c %d, %x %c %d\n", n,n,n,
						lastkey,lastkey,lastkey);*/

				ggievent.any.type=evKeyRelease;
				ggievent.key.sym =lastkey;
				ggievent.key.button=lastkey;
				lastkey = 0;
				lastkeyticks = 0;
			}
		} 
		else if (n>AA_RELEASE)
		{
			/* AAlib apparently doesn't send release events, just
			 * press events.  As long as the key is down, it returns
			 * a keypress.  When you let it up, it returns nothing.
			 * so, we store the event in lastkey and return *nothing*
			 * if the key is still down. See above */
			/* fprintf(stderr, "Release event: %x %c %d\n", n,n,n); */

			n &= ~AA_RELEASE;
			ggievent.any.type=evKeyRelease;
			ggievent.key.sym =n;
			ggievent.key.button=n;
		} 

		if (ggievent.any.type==evKeyPress || 
		    ggievent.any.type==evKeyRelease) {
			switch(ggievent.key.button)
			{ 
			  case AA_UP:
			  	ggievent.key.sym=GIIK_Up;break;
			  case AA_DOWN:
			  	ggievent.key.sym=GIIK_Down;break;
			  case AA_LEFT:
			  	ggievent.key.sym=GIIK_Left;break;
			  case AA_RIGHT:
			  	ggievent.key.sym=GIIK_Right;break;
			  case AA_BACKSPACE:
			  	ggievent.key.sym=GIIUC_BackSpace;break;
			  case AA_ESC:
			  	ggievent.key.sym=GIIUC_Escape;break;
			}
		}
		
		switch(ggievent.any.type) {
			case evKeyPress:
			case evKeyRelease:
				ggievent.any.size=sizeof(ggi_key_event);
				ggievent.key.effect=0;
				ggievent.key.label=ggievent.key.sym;
				break;
			case evPtrRelative:
				ggievent.any.size=sizeof(ggi_pmove_event);
				break;
			case evPtrButtonPress:
			case evPtrButtonRelease:
				ggievent.any.size=sizeof(ggi_pbutton_event);
				break;
		}
		EV_TIMESTAMP(&ggievent);

		if (ggievent.any.type) _ggiEvQueueAdd(vis,&ggievent);
		evmask = _ggiEvQueueSeen(vis,mask);

	} while (evmask==0 && t==NULL);

	return evmask;
}

int GGI_aa_eventread(ggi_visual_t vis,ggi_event *ev,ggi_event_mask mask)
{
	/* Block if we don't have anything queued... */
	GGI_aa_eventpoll(vis,mask,NULL);
	return _ggiEvQueueRelease(vis,ev,mask);
}
