/* $Id: visual.c,v 1.19 1998/10/24 04:03:40 marcus Exp $
***************************************************************************

   Display-Xlib initialization.

   Copyright (C) 1995 Andreas Beck      [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan    [jmcc@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdlib.h>

#include <ggi/internal/ggi-dl.h>
#include "Xvisual.h"

#include "../X_common/giievents.inc"

int GGIdlinit(ggi_visual *vis,const char *args,void *argptr)
{
	struct Xhooks *xinfo;

	LIBGGI_GC(vis) = _ggi_malloc(sizeof(ggi_gc));

	DPRINT("X-lib starting.\n");
	LIBGGI_PRIVATE(vis)=xinfo=_ggi_malloc(sizeof(struct Xhooks));
	
	xinfo->display=NULL;
	xinfo->cmap=0;
	xinfo->cmap_first=256;
	xinfo->cmap_last=0;
	xinfo->window=0;
	xinfo->gc=0;
	xinfo->tempgc=0;
	xinfo->viswidth=0;
	xinfo->visheight=0;
	xinfo->relptr=0;
	xinfo->relptr_keymask = RELPTR_KEYINUSE;
 	
	/* We do not use the XLibLock here, as there is no concurrent thread yet. */
	_ggiLockInit(xinfo->XLibLock);
	
	DPRINT("X-lib wants display %s.\n",args);
	xinfo->display = XOpenDisplay(args);
	if (xinfo->display == NULL)
		return GGI_DL_ERROR;

	DPRINT("X-lib has display %s.\n",args);

	LIBGGI_SELECT_FD(vis)=LIBGGI_FD(vis)=ConnectionNumber(xinfo->display);

	xinfo->screen = DefaultScreen (xinfo->display);
	DPRINT("X-lib has screen.\n");
	DPRINT("X-lib fully up.\n");

	/* Has mode management */
	vis->opdisplay->flush=GGI_X_flush;
	vis->opdisplay->getmode=GGI_X_getmode;
	vis->opdisplay->setmode=GGI_X_setmode;
	vis->opdisplay->checkmode=GGI_X_checkmode;
	vis->opdisplay->getapi =GGI_X_getapi;
	vis->opdisplay->setflags=GGI_Xlib_setflags;

	{
		gii_input *inp;
		DPRINT_MISC("gii starting\n");

		/* First allocate a new gii_input descriptor. */

		if (NULL==(inp=_giiInputAlloc()))
		{
			DPRINT_MISC("giiInputAlloc failure.\n");
			goto out;
		}
		DPRINT_MISC("gii inp=%p\n",inp);

		/* Now fill in the blanks. */

		inp->priv=xinfo;	/* We need that in GII_X_poll() */

		/* What events _can_  we create at all ? 
		   Save useless polling time. */

		inp->targetcan= emKeyPress | emKeyRelease |
				emPtrButtonPress | emPtrButtonRelease |
				emPtrRelative    | emPtrAbsolute ;

		/* What events _do_ we generate by default ? */
		inp->GIIseteventmask(inp,inp->targetcan);

		/* Set up the select() mechanism */
		inp->maxfd=1+ConnectionNumber(xinfo->display);	/* Show it */
		FD_SET(inp->maxfd-1,&(inp->fdset));        	/* Add stdin */

		/* We only need the "poll" function. For all others, 
		   defaults are fine. */
		inp->GIIeventpoll=GII_X_poll;

		/* Now join the new event source in. */
		vis->input=giiJoinInputs(vis->input,inp);
        }

	out:
	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	struct Xhooks *xinfo;

	if ((xinfo=LIBGGI_PRIVATE(vis)) != NULL) {
		if (xinfo->cmap)
			XFreeColormap(xinfo->display,xinfo->cmap);
		if (xinfo->gc) {
			XFreeGC(xinfo->display,xinfo->gc);
			XFreeGC(xinfo->display,xinfo->tempgc);
		}
		if (xinfo->window) 
			XDestroyWindow(xinfo->display,xinfo->window);
		XSync(xinfo->display,0);
		if (xinfo->display)
			XCloseDisplay(xinfo->display);

		_ggiLockDestroy(xinfo->XLibLock);

		free(LIBGGI_PRIVATE(vis));
	}

	if(vis->palette)
		free(vis->palette);
	free(LIBGGI_GC(vis));

	return 0;
}

#include <ggi/internal/ggidlinit.h>
