/* $Id: pixel.c,v 1.10 1998/09/30 18:31:16 marcus Exp $
***************************************************************************

   Graphics library for GGI. Pixels for Xlib.

   Copyright (C) 1998 Marcus Sundberg [marcus@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <ggi/internal/ggi-dl.h>
#include "Xvisual.h"

/*******************************/
/* draw/get/put a single pixel */
/*******************************/

int GGI_Xlib_drawpixel(ggi_visual *vis,int x,int y)
{
	XDrawPoint(XLIB_PRIV(vis)->display,
			   XLIB_PRIV(vis)->window,
			   XLIB_PRIV(vis)->gc,
			   x, y); 

	XLIB_DOSYNC(vis);
	return 0;
}

int GGI_Xlib_putpixel(ggi_visual *vis,int x,int y,ggi_pixel col)
{ 
	XSetForeground(XLIB_PRIV(vis)->display,
				   XLIB_PRIV(vis)->tempgc,
				   col);
	XDrawPoint(XLIB_PRIV(vis)->display,
			   XLIB_PRIV(vis)->window,
			   XLIB_PRIV(vis)->tempgc,
			   x, y);

	XLIB_DOSYNC(vis);
	return 0;
}

/* Hack to fall back when shm is not working. */
static int	geterror = -1;

static int errorhandler (Display * disp, XErrorEvent * event)
{
	if (event->error_code == BadMatch)
		geterror = 1;
	return 0;
}

int GGI_Xlib_getpixel(ggi_visual *vis,int x,int y,ggi_uint *pixel)
{
	int ret = 0;
	XImage *ximg;
	int	(*olderrorhandler) (Display *, XErrorEvent *);
	
	XLIB_DOSYNC(vis);

	/* FIXME: This is a nasty hack to do global locking */
	while (geterror != -1) {
		_ggi_usleep(10000);
	}
	geterror = 0;
	olderrorhandler = XSetErrorHandler(errorhandler);
		/* This will cause a BadMatch error when the window is
		   iconified or on another virtual screen... */
	ximg = XGetImage(XLIB_PRIV(vis)->display, XLIB_PRIV(vis)->window, x, y,
			  1, 1, AllPlanes, ZPixmap);
	XSetErrorHandler(olderrorhandler);
	*pixel = 0;
	if (!geterror) {
		memcpy(pixel, ximg->data, LIBGGI_PIXFMT(vis)->size/8);
		XDestroyImage(ximg);
	} else {
		ret = -1;
	}
	geterror = -1;

	return ret;
}
