/* $Id: Xvisual.h,v 1.16 1998/10/06 20:00:30 steve Exp $
***************************************************************************

   Display-X: data

   Copyright (C) 1997 Andreas Beck      [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#ifdef HAVE_SYS_SHM_H
#define HAVE_SHM
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#endif

#if defined(__osf__)
extern int XShmQueryExtension(Display *);
#endif

#include <ggi/internal/ggi-dl.h>
#include "../mansync/mansync.h"

ggifunc_flush		GGI_X_flush;
ggifunc_getmode		GGI_X_getmode;
ggifunc_setmode		GGI_X_setmode;
ggifunc_checkmode	GGI_X_checkmode;
ggifunc_getapi 		GGI_X_getapi;
ggifunc_setflags	GGI_X_setflags;

ggifunc_eventpoll	GGI_X_eventpoll;
ggifunc_eventread	GGI_X_eventread;
ggifunc_seteventmask	GGIseteventmask;

ggifunc_setpalvec	GGI_X_setpalvec;

struct Xhooks { 
	Display *display;
	int     screen;
	Window  window;
	XImage *ximage;      /* Current frame */
	XImage *ximage_list[8]; /* List of frames */
	GC      gc;
	Colormap cmap;
	int     cmap_first,cmap_last;
	int     xoff,yoff;   /* We can pan, too */
	int     ysplit;      /* Emulating Splitline ;-) */

	int     nocols;      /* Number of colors in the colormap */
	int     viswidth, visheight;
	int     relptr;
	unsigned int relptr_keymask;
	sint32  oldmousex;
	sint32  oldmousey;
	short   red_shift;
	short   green_shift;
	short   blue_shift;
#ifdef HAVE_SHM
	XShmSegmentInfo shminfo[8];               /* Segment info.  */
	int     have_shm;
	int	shmerror;
	int	(*oldshmerrorhandler) (Display *, XErrorEvent *);
#endif
	ggi_mutex XLibLock;
	_ggi_opmansync *opmansync;
};

#define XLIB_PRIV(vis) ((struct Xhooks *)LIBGGI_PRIVATE(vis))

void _GGIfreedbs(ggi_visual *, struct Xhooks *);


#define MANSYNC_init(vis)   XLIB_PRIV(vis)->opmansync->init(vis)
#define MANSYNC_deinit(vis) XLIB_PRIV(vis)->opmansync->deinit(vis)
#define MANSYNC_start(vis)  XLIB_PRIV(vis)->opmansync->start(vis)
#define MANSYNC_stop(vis)   XLIB_PRIV(vis)->opmansync->stop(vis)
#define MANSYNC_ignore(vis) XLIB_PRIV(vis)->opmansync->ignore(vis)
#define MANSYNC_cont(vis)   XLIB_PRIV(vis)->opmansync->cont(vis)

#define RELPTR_KEYS { XK_Control_L, XK_Alt_L, 'm' }
#define RELPTR_KEYINUSE (1 | (1<<1) | (1<<2))
#define RELPTR_NUMKEYS  3
