/* stars.c		by Nathan Strong
 *
 * based on stars.bas, written by a friend of mine who goes by 'beek' in
 * the world of the internet :-) There is no copyright, no restrictions,
 * and most definitely no warranty on this software. I won't guarantee
 * that it will compile, or that it will not cause damage to your system
 * or your hardware. It's not like this is incredibly complicated code,
 * anyway, so it's your own fault for not checking the code first!
 *
 * You can do anything you want with this code. Use it in your next demo!
 * print it out and use it as wallpaper! Write me flamemail telling me how
 * much I suck at programming (my e-mail is gblues@gstis.net)!
 *
 * The only thing I ask is for credit, even if it's a "This portion
 * based on stars.c by Nathan Strong" buried deep in the source code
 * that nobody will ever see. I was nice enough to credit my friend beek
 * in the source, you can do the same for me :)
 *
 * You're still reading this? What's the matter with you? You must be
 * a lawyer or something :)
 */

/* Responsible for bad reformatting : <andreas.beck@ggi-project.org> */

/* Flame <andrew@ggi-project.org> for the command line arg silliness */

#include<stdlib.h>
#include<stdio.h>
#include<unistd.h>
#include<time.h>
#include<math.h>
#include<ggi/ggi.h>

static ggi_visual_t *vis;
static ggi_pixel lookup[256];
static ggi_mode mode;
static int xoff, yoff;

static double angle = 0.0;
static double speed = 0.5;
static double scale;

static int frames = 0;

static int stars[300][3];
static int starsr[300][3];
static int posx[300][60];
static int posy[300][60];

static int count=100;
static int head=1;
static int tail=0;

void InitGraphics(void);
void InitStars(void);
void CleanUp(void);
void Transform(int *ta, int *tb);

int main(int argc, char **argv) 
{
	int i;
	double fps = 0.0;
	int color;
	time_t st = time(NULL);
	
	if (argc > 1) {
		count = atoi(argv[1]) % 301;
	}
	if (argc > 2) {
		head = atoi(argv[2]) % 60;
	}
	if (argc > 3) {
		speed = atof(argv[3]);
	}

	InitGraphics();
	InitStars();

	do	{
		for (i = 0; i < count; i++)
		{
			starsr[i][0] = stars[i][0];
			starsr[i][1] = stars[i][1];
			starsr[i][2] = stars[i][2];
	
			Transform(&starsr[i][1], &starsr[i][2]);
			Transform(&starsr[i][0], &starsr[i][2]);
			Transform(&starsr[i][0], &starsr[i][1]);

			ggiPutPixel(vis, posx[i][tail], posy[i][tail], 
				    lookup[0]);

			posx[i][head] = xoff+(int) floor((256*starsr[i][0]) / 
				(double)(starsr[i][2]-1024) * scale);
			posy[i][head] = yoff+(int) floor((256*starsr[i][1]) / 
				(double)(starsr[i][2]-1024) * scale);
		
			color = (int) floor((starsr[i][2] + 721) / 5.5);

			ggiPutPixel(vis, posx[i][head], posy[i][head], 
				    lookup[color]);
		}
		usleep(10000);
		ggiFlush(vis);
		frames++;
		angle += speed;
		head=(head+1) % 60; 
		tail=(tail+1) % 60;
	} while(! ggiKbhit(vis));

	if ((time(NULL) - st) != 0)
		fps = frames / (time(NULL) - st);
	printf("%f frames per second\n", fps);
	printf("beek / lightspeed\nPorted to GGI by Nathan Strong\n");
	CleanUp();
	return 0;
}

void Transform(int *ta, int *tb)
{
	double y = 0.0, z = 0.0;
	y = (cos((angle / 20)) * *ta) - (sin((angle / 20)) * *tb);
	z = (sin((angle / 20)) * *ta) + (cos((angle / 20)) * *tb);
	*ta = (int) floor(y);
	*tb = (int) floor(z);
}

void CleanUp(void) 
{
	ggiClose(vis);
	ggiExit();
	exit(0);
}

void InitStars(void) 
{
	int i;
	srand(time(NULL));
	for (i = 0; i < count; i++)
	{
		stars[i][0] = ((rand() % 320)+1 - 160) * 3;
		stars[i][1] = ((rand() % 320)+1 - 160) * 3;
		stars[i][2] = ((rand() % 128)+1 -  64) * 5;
	}
}

void InitGraphics(void) 
{
	int i;

	if (ggiInit() != 0) {
		fprintf(stderr, "unable to initialize libggi, exiting.\n");
		exit(1);
	}
	if ((vis=ggiOpen(NULL)) == NULL) {
		ggiPanic("unable to open default visual, exiting.\n");
	}

	ggiSetFlags(vis, GGIFLAG_ASYNC);
	if (ggiSetGraphMode(vis, GGI_AUTO, GGI_AUTO, 
			    GGI_AUTO, GGI_AUTO , GT_AUTO) != 0) {
		ggiPanic("Cannot set default mode!\n");
	}

	ggiGetMode(vis, &mode);

	xoff = mode.visible.x/2;
	yoff = mode.visible.y/2;

	scale = (mode.visible.x / 200);

	if (GT_SCHEME(mode.graphtype) == GT_PALETTE) {

		int nocols = 1 << GT_DEPTH(mode.graphtype);

		ggi_color Palette[256];

		for (i = 0; i < nocols; i++) {
			Palette[i].r = i*0xffff/(nocols-1);
			Palette[i].g = i*0xffff/(nocols-1);
			Palette[i].b = i*0xffff/(nocols-1);
		}

		ggiSetPalette(vis, 0, nocols, Palette);
	}
	
	for (i = 0; i < 256; i++) {
	
		ggi_color col;

		col.r = col.g = col.b = i*0xffff/255;

		lookup[i] = ggiMapColor(vis, &col);
	}

	ggiSetGCForeground(vis, lookup[0]);
	ggiFillscreen(vis);
}
