/* $Id: vline.c,v 1.11 1998/09/26 03:21:06 marcus Exp $
***************************************************************************

   Generic vertical lines.

   Copyright (C) 1995 Andreas Beck	[becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan	[jmcc@ggi-project.org]
   Copyright (C) 1998 Andrew Apted	[andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "stublib.h"


int GGI_stubs_drawvline(ggi_visual *vis, int x, int y, int h)
{
	for (; h > 0; h--, y++) {
		ggiDrawPixel(vis, x, y);
	}
	
	return 0;
}

int GGI_stubs_drawvline_nc(ggi_visual *vis, int x, int y, int h)
{
	for (; h > 0; h--, y++) {
		_ggiDrawPixelNC(vis, x, y);
	}
	
	return 0;
}


/* ---------------------------------------------------------------------- */


int _GGI_stubs_L1_putvline(ggi_visual *vis, int x, int y, int w, void *buffer)
{
	uint8 *src = (uint8 *) buffer;

	for (; w > 0; w--, y++, src++) {
		ggiPutPixel(vis, x, y, *src);
	}

	return 0;
}

int _GGI_stubs_L2_putvline(ggi_visual *vis, int x, int y, int w, void *buffer)
{
	uint16 *src = (uint16 *) buffer;

	for (; w > 0; w--, y++, src++) {
		ggiPutPixel(vis, x, y, *src);
	}

	return 0;
}

int _GGI_stubs_L3_putvline(ggi_visual *vis, int x, int y, int w, void *buffer)
{
	uint8 *src = (uint8 *) buffer;

	for (; w > 0; w--, y++, src+=3) {
		
		ggi_pixel pix = src[0] | (src[1] << 8) | (src[2] << 16);

		ggiPutPixel(vis, x, y, pix);
	}

	return 0;
}

int _GGI_stubs_L4_putvline(ggi_visual *vis, int x, int y, int w, void *buffer)
{
	uint32 *src = (uint32 *) buffer;

	for (; w > 0; w--, y++, src++) {
		ggiPutPixel(vis, x, y, *src);
	}

	return 0;
}


/* ---------------------------------------------------------------------- */


int _GGI_stubs_L1_getvline(ggi_visual *vis, int x, int y, int h, void *buffer)
{
	uint8 *dest = (uint8 *) buffer;

	ggi_pixel pix;
		
	for (; h > 0; h--, y++) {
		
		ggiGetPixel(vis, x, y, &pix);

		*dest++ = (uint8) pix;
	}

	return 0;
}

int _GGI_stubs_L2_getvline(ggi_visual *vis, int x, int y, int h, void *buffer)
{
	uint16 *dest = (uint16 *) buffer;

	ggi_pixel pix;

	for (; h > 0; h--, y++) {
		
		ggiGetPixel(vis, x, y, &pix);

		*dest++ = (uint16) pix;
	}

	return 0;
}

int _GGI_stubs_L3_getvline(ggi_visual *vis, int x, int y, int h, void *buffer)
{
	uint8 *dest = (uint8 *) buffer;

	ggi_pixel pix;

	for (; h > 0; h--, y++) {
		
		ggiGetPixel(vis, x, y, &pix);

		*dest++ = (uint8) pix; pix >>= 8;
		*dest++ = (uint8) pix; pix >>= 8;
		*dest++ = (uint8) pix;
	}

	return 0;
}

int _GGI_stubs_L4_getvline(ggi_visual *vis, int x, int y, int h, void *buffer)
{
	uint32 *dest = (uint32 *) buffer;

	for (; h > 0; h--, y++) {

		ggi_pixel pix;
		
		ggiGetPixel(vis, x, y, &pix);

		*dest++ = (uint32) pix;
	}

	return 0;
}
