/* $Id: hline.c,v 1.10 1998/09/26 03:21:02 marcus Exp $
***************************************************************************

   Generic horizontal lines.

   Copyright (C) 1995 Andreas Beck  [becka@ggi-project.org]
   Copyright (C) 1998 Andrew Apted  [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "stublib.h"


int GGI_stubs_drawhline(ggi_visual *vis,int x,int y,int w)
{
	for (; w > 0; w--, x++) {
		ggiDrawPixel(vis, x, y);
	}

	return 0;
}

int GGI_stubs_drawhline_nc(ggi_visual *vis, int x, int y, int w)
{
	for (; w > 0; w--, x++) {
		_ggiDrawPixelNC(vis, x, y);
	}

	return 0;
}


/* ---------------------------------------------------------------------- */


int _GGI_stubs_L1_puthline(ggi_visual *vis, int x, int y, int w, void *buffer)
{
	uint8 *src = (uint8 *) buffer;

	for (; w > 0; w--, x++, src++) {
		ggiPutPixel(vis, x, y, *src);
	}

	return 0;
}

int _GGI_stubs_L2_puthline(ggi_visual *vis, int x, int y, int w, void *buffer)
{
	uint16 *src = (uint16 *) buffer;

	for (; w > 0; w--, x++, src++) {
		ggiPutPixel(vis, x, y, *src);
	}

	return 0;
}

int _GGI_stubs_L3_puthline(ggi_visual *vis, int x, int y, int w, void *buffer)
{
	uint8 *src = (uint8 *) buffer;

	for (; w > 0; w--, x++, src+=3) {
		
		ggi_pixel pix = src[0] | (src[1] << 8) | (src[2] << 16);

		ggiPutPixel(vis, x, y, pix);
	}

	return 0;
}

int _GGI_stubs_L4_puthline(ggi_visual *vis, int x, int y, int w, void *buffer)
{
	uint32 *src = (uint32 *) buffer;

	for (; w > 0; w--, x++, src++) {
		ggiPutPixel(vis, x, y, *src);
	}

	return 0;
}


/* ---------------------------------------------------------------------- */


int _GGI_stubs_L1_gethline(ggi_visual *vis, int x, int y, int w, void *buffer)
{
	uint8 *dest = (uint8 *) buffer;

	ggi_pixel pix;
		
	for (; w > 0; w--, x++) {
		
		ggiGetPixel(vis, x, y, &pix);

		*dest++ = (uint8) pix;
	}

	return 0;
}

int _GGI_stubs_L2_gethline(ggi_visual *vis, int x, int y, int w, void *buffer)
{
	uint16 *dest = (uint16 *) buffer;

	ggi_pixel pix;

	for (; w > 0; w--, x++) {
		
		ggiGetPixel(vis, x, y, &pix);

		*dest++ = (uint16) pix;
	}

	return 0;
}

int _GGI_stubs_L3_gethline(ggi_visual *vis, int x, int y, int w, void *buffer)
{
	uint8 *dest = (uint8 *) buffer;

	ggi_pixel pix;

	for (; w > 0; w--, x++) {
		
		ggiGetPixel(vis, x, y, &pix);

		*dest++ = (uint8) pix; pix >>= 8;
		*dest++ = (uint8) pix; pix >>= 8;
		*dest++ = (uint8) pix;
	}

	return 0;
}

int _GGI_stubs_L4_gethline(ggi_visual *vis, int x, int y, int w, void *buffer)
{
	uint32 *dest = (uint32 *) buffer;

	ggi_pixel pix;

	for (; w > 0; w--, x++) {

		ggiGetPixel(vis, x, y, &pix);

		*dest++ = (uint32) pix;
	}

	return 0;
}
