/* $Id: color.c,v 1.11 1998/09/20 21:23:14 marcus Exp $
***************************************************************************

   Graphics library for GGI.  Generic RAMDAC via IOCTL driver

   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1998 Andrew Apted     [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <math.h>
#include <sys/ioctl.h>

#ifdef _AIX
#include <sys/types.h>
#include <unistd.h>
#endif

#include <ggi/internal/ggi-dl.h>
#include <kgi/ioctl.h>


int GGIsetpalvec(ggi_visual *vis, int start, int len, ggi_color *colormap)
{
	int nocols = 256;

	if (start == GGI_PALETTE_DONTCARE) {
		start = 0;
	}

	if (GT_SCHEME(LIBGGI_GT(vis)) != GT_TRUECOLOR) {
		nocols = 1 << GT_DEPTH(LIBGGI_GT(vis));
	}
	
	if ((colormap==NULL) || (start < 0) || (start+len > nocols)) {
		return -1;
	}

	memcpy(vis->palette+start, colormap, len*sizeof(ggi_color));

	return _ggiSendKGICommand(vis, (int)RAMDAC_SETCLUT, vis->palette);
}

#if 0   /* we rely on generic-color's version */
int GGIgetpalvec(ggi_visual *vis,int start,int len,ggi_color *colormap)
{
	if (colormap==NULL || start+len > 256)
		return -1;

	memcpy(colormap, vis->palette+start, len*sizeof(ggi_color));

	return 0;
}
#endif

/* !!! FIXME: add GGIsetgammmap and GGIgetgammamap here
 * (calling RAMDAC_SETCLUT and RAMDAC_GETCLUT respectively)
 */
