/* $Id: vline.c,v 1.7 1998/09/20 21:23:11 marcus Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1998 Brian S. Julin   [bri@calyx.com]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]

   If you do any modifications, I would like you to send diffs to me
   to allow for collecting a more and more complete set of drivers and
   to improve existing ones.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include "linmm_banked.h"

/********************************/
/* draw/get/put a vertical line */
/********************************/
int GGIdrawvline(ggi_visual *vis,int x,int y,int h)
{
	uint8 *pixpt;
	unsigned int w=LIBGGI_FB_WIDTH(vis);
	ggi_pixel color = LIBGGI_GC_FGCOLOR(vis);

	/* Clipping */
	if (x< (LIBGGI_GC(vis)->cliptl.x) ||
	    x>=(LIBGGI_GC(vis)->clipbr.x)) return 0;
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		h-=diff;
	}
	if (y+h>(LIBGGI_GC(vis)->clipbr.y)) {
		h=(LIBGGI_GC(vis)->clipbr.y)-y;
	}  

	pixpt = BANKFB + ((y * LIBGGI_FB_WIDTH(vis) + x) << LOGBYTPP);
	
	/* Supports only 8, 16, 32 bit modes -- 
	   impossible to pixel nonaligned */ 
	
	for(;h--;pixpt+=w << LOGBYTPP) 
		memcpy(pixpt, &color, 1 << LOGBYTPP);
  
  return 0;
}

int GGIdrawvline_nc(ggi_visual *vis,int x,int y,int h)
{
	uint8 *pixpt;
	unsigned int w=LIBGGI_FB_WIDTH(vis);
	ggi_pixel color = LIBGGI_GC_FGCOLOR(vis);
	
	pixpt = BANKFB + ((y * LIBGGI_FB_WIDTH(vis) + x) << LOGBYTPP);
	
	/* Supports only 8, 16, 32 bit modes -- 
	   impossible to pixel nonaligned */ 
	
	for(;h--;pixpt+=w << LOGBYTPP) 
		memcpy(pixpt, &color, 1 << LOGBYTPP);
	
	return 0;
}



int GGIputvline(ggi_visual *vis,int x,int y,int h,void *buff)
{
  uint8 *pixpt, *buffer=(uint8 *)buff;
  unsigned int w=LIBGGI_FB_WIDTH(vis);


	/* Clipping */
	if (x< (LIBGGI_GC(vis)->cliptl.x) ||
	    x>=(LIBGGI_GC(vis)->clipbr.x)) return 0;
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		h-=diff;
	}
	if (y+h>(LIBGGI_GC(vis)->clipbr.y)) {
		h=(LIBGGI_GC(vis)->clipbr.y)-y;
	}  

  pixpt = BANKFB + ((y * LIBGGI_FB_WIDTH(vis) + x) << LOGBYTPP);
  
  /* Supports only 8, 16, 32 bit modes -- 
     impossible to pixel nonaligned */   
  for(;h--;pixpt+=w << LOGBYTPP) { 
    memcpy(pixpt, buffer, 1 << LOGBYTPP);
    buffer += (1 << LOGBYTPP);
  }
  
  return 0;
}


int GGIputvline_nc(ggi_visual *vis,int x,int y,int h,void *buff)
{
  uint8 *pixpt, *buffer=(uint8 *)buff;
  unsigned int w=LIBGGI_FB_WIDTH(vis);

  pixpt = BANKFB + ((y * LIBGGI_FB_WIDTH(vis) + x) << LOGBYTPP);
  
  /* Supports only 8, 16, 32 bit modes -- 
     impossible to pixel nonaligned */   
  for(;h--;pixpt+=w << LOGBYTPP) { 
    memcpy(pixpt, buffer, 1 << LOGBYTPP);
    buffer += (1 << LOGBYTPP);
  }
  
  return 0;
}

int GGIgetvline(ggi_visual *vis,int x,int y,int h,void *buff)
{
  uint8 *pixpt,*buffer=(uint8 *)buff;
  unsigned int w=LIBGGI_FB_WIDTH(vis);
  
  CHECKXYH(vis,x,y,h);
  
  pixpt = RBANKFB + ((y * LIBGGI_FB_WIDTH(vis) + x) << LOGBYTPP);
  
  /* Supports only 8, 16, 32 bit modes -- 
     impossible to pixel nonaligned */ 
  
  for(;h--;pixpt+=w << LOGBYTPP) { 
    memcpy(buffer, pixpt, 1 << LOGBYTPP);
    buffer += (1 << LOGBYTPP);
  }
  return 0;
}

