/* $Id: vline.c,v 1.9 1998/09/26 03:20:55 marcus Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "lin8lib.h"

/********************************/
/* draw/get/put a vertical line */
/********************************/
int GGI_lin8_drawvline(ggi_visual *vis,int x,int y,int height)
{
	uint8 *ptr;
	int w=LIBGGI_FB_W_STRIDE(vis);
	uint8 color=(LIBGGI_GC_FGCOLOR(vis) & 0xff);

	/* Clipping */
	if (x< (LIBGGI_GC(vis)->cliptl.x) ||
	    x>=(LIBGGI_GC(vis)->clipbr.x)) return 0;
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		height-=diff;
	}
	if (y+height>(LIBGGI_GC(vis)->clipbr.y)) {
		height=(LIBGGI_GC(vis)->clipbr.y)-y;
	}

	ptr=(uint8 *)LIBGGI_CURWRITE(vis)+y*w+x;

	for(;height>0;height--,ptr+=w) 
		*ptr=color; 
	
	return 0;
}

int GGI_lin8_drawvline_nc(ggi_visual *vis,int x,int y,int height)
{
	uint8 *ptr;
	int w=LIBGGI_FB_W_STRIDE(vis);
	uint8 color=(LIBGGI_GC_FGCOLOR(vis) & 0xff);

	ptr=(uint8 *)LIBGGI_CURWRITE(vis)+y*w+x;

	for(;height>0;height--,ptr+=w) 
		*ptr=color; 
	
	return 0;
}

int GGI_lin8_putvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{
	uint8 *ptr,*pixels=(uint8 *)buffer;
	int w=LIBGGI_FB_W_STRIDE(vis);

	/* Clipping */
	if (x< (LIBGGI_GC(vis)->cliptl.x) ||
	    x>=(LIBGGI_GC(vis)->clipbr.x)) return 0;
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		height-=diff;
		buffer =((char *)buffer)+diff;
	}
	if (y+height>(LIBGGI_GC(vis)->clipbr.y)) {
		height=(LIBGGI_GC(vis)->clipbr.y)-y;
	}

	ptr=(uint8 *)LIBGGI_CURWRITE(vis)+y*w+x;

	for(;height>0;height--,ptr+=w) 
		*ptr=*(pixels++); 
	
	return 0;
}

int GGI_lin8_getvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{
	uint8 *ptr,*pixels=(uint8 *)buffer;
	int w=LIBGGI_FB_R_STRIDE(vis);

	ptr=(uint8 *)LIBGGI_CURREAD(vis)+y*w+x;

	for(;height>0;height--,ptr+=w) 
		*(pixels++)=*ptr; 
	
	return 0;
}

