/* $Id: pixel.c,v 1.4 1998/09/20 21:22:36 marcus Exp $
***************************************************************************

   Linear 1 pixel drawing (high-bit-right)

   Copyright (C) 1995 Andreas Beck    [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1998 Andrew Apted   [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

#define PIXEL_RADDR(vis,x,y)  \
	((uint8 *)LIBGGI_CURREAD(vis)+y*LIBGGI_FB_R_STRIDE(vis)+(x>>3))

#define PIXEL_WADDR(vis,x,y)  \
	((uint8 *)LIBGGI_CURWRITE(vis)+y*LIBGGI_FB_W_STRIDE(vis)+(x>>3))


int GGIdrawpixel_nc(ggi_visual *vis, int x, int y)
{
	if (LIBGGI_GC_FGCOLOR(vis) & 1) {
		*PIXEL_WADDR(vis,x,y) |=  (0x01 << (x & 7));
	} else {
		*PIXEL_WADDR(vis,x,y) &= ~(0x01 << (x & 7));
	}
	
	return 0;
}

int GGIdrawpixel(ggi_visual *vis, int x, int y)
{
	CHECKXY(vis, x, y);
 
	if (LIBGGI_GC_FGCOLOR(vis) & 1) {
		*PIXEL_WADDR(vis,x,y) |=  (0x01 << (x & 7));
	} else {
		*PIXEL_WADDR(vis,x,y) &= ~(0x01 << (x & 7));
	}
	
	return 0;
}

int GGIputpixel_nc(ggi_visual *vis, int x, int y, ggi_pixel col)
{
	if (col & 1) {
		*PIXEL_WADDR(vis,x,y) |=  (0x01 << (x & 7));
	} else {
		*PIXEL_WADDR(vis,x,y) &= ~(0x01 << (x & 7));
	}
	
	return 0;
}

int GGIputpixel(ggi_visual *vis, int x, int y, ggi_pixel col)
{
	CHECKXY(vis, x, y);
 
	if (col & 1) {
		*PIXEL_WADDR(vis,x,y) |=  (0x01 << (x & 7));
	} else {
		*PIXEL_WADDR(vis,x,y) &= ~(0x01 << (x & 7));
	}
	
	return 0;
}

int GGIgetpixel(ggi_visual *vis, int x, int y, ggi_pixel *pixel)
{
	*pixel = !! (*PIXEL_RADDR(vis,x,y) & (0x01 << (x & 7)));

	return 0;
}
