/* 
   Linear 1 character drawing.

   Copyright (C) 1995 Andreas Beck    [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1998 Andrew Apted   [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <ggi/internal/ggi-dl.h>

#include <ggi/internal/font/8x8>


int GGIgetcharsize(ggi_visual *vis, int *width, int *height)
{
	*width = *height = 8;
	return 0;
}

int GGIputc(ggi_visual *vis, int x, int y, char c)
{
	int h=8, stride, rev;

	uint8 *src, *dest;
	uint8 mask, mask0, mask1;
	int shift0, shift1;

	if ((x   >= LIBGGI_GC(vis)->clipbr.x)  || 
	    (y   >= LIBGGI_GC(vis)->clipbr.y)  ||
	    (x+8 <= LIBGGI_GC(vis)->cliptl.x)  || 
	    (y+8 <= LIBGGI_GC(vis)->cliptl.y)) 
		return 0;

	if ((LIBGGI_GC_FGCOLOR(vis)&1) == (LIBGGI_GC_BGCOLOR(vis)&1)) {
		/* Just a solid box when fg == bg */
		return ggiDrawBox(vis, x, y, 8, 8);
	}

	src = font + ((int) (uint8) c << 3);
	rev = (LIBGGI_GC_BGCOLOR(vis) & 1);

	if (y < LIBGGI_GC(vis)->cliptl.y) {
		int diff = LIBGGI_GC(vis)->cliptl.y - y;
		h   -= diff;
		y   += diff;
		src += diff;

	} 
	if (y+h > LIBGGI_GC(vis)->clipbr.y) {
		h = LIBGGI_GC(vis)->clipbr.y - y;
	}

	stride = LIBGGI_FB_W_STRIDE(vis);
	dest = (uint8 *) LIBGGI_CURWRITE(vis) + y*stride + (x>>3);

	if ((x & 7) == 0) {

		/* aligned putc */

		mask = 0xff;

		if (x < LIBGGI_GC(vis)->cliptl.x) {
			mask &= 0xff >> (LIBGGI_GC(vis)->cliptl.x - x);
		}
		if (x+8 > LIBGGI_GC(vis)->clipbr.x) {
			mask &= 0xff << (x+8 - LIBGGI_GC(vis)->clipbr.x);
		}
		
		if ((mask == 0xff) && !rev) {

			for(; h > 0; h--, dest += stride, src++) {
				*dest = *src;
			}

		} else if ((mask == 0xff) && rev) {

			for(; h > 0; h--, dest += stride, src++) {
				*dest = ~*src;
			}

		} else if (!rev) {

			for(; h > 0; h--, dest += stride, src++) {
				*dest = (*src & mask) | (*dest & ~mask);
			}
		} else {
			for(; h > 0; h--, dest += stride, src++) {
				*dest = (~*src & mask) | (*dest & ~mask);
			}
		}

		return 0;
	}

	/* non-aligned putc */

	mask = 0xff;

	if (x < LIBGGI_GC(vis)->cliptl.x) {
		mask &= 0xff >> (LIBGGI_GC(vis)->cliptl.x - x);
	}
	if (x+8 > LIBGGI_GC(vis)->clipbr.x) {
		mask &= 0xff << (x+8 - LIBGGI_GC(vis)->clipbr.x);
	}
	
	shift0 = x & 7; 	   /* shift to the right */
	shift1 = (7 - (x & 7));    /* shift to the left */

	mask0 = mask >> shift0;
	mask1 = mask << shift1;
	
	if (!rev) {
		for(; h > 0; h--, dest += stride, src++) {
			dest[0]=((*src>>shift0)&mask0) | (dest[0]&~mask0);
			dest[1]=((*src<<shift1)&mask1) | (dest[1]&~mask1);
		}
	} else {
		for(; h > 0; h--, dest += stride, src++) {
			dest[0]=((~*src>>shift0)&mask0) | (dest[0]&~mask0);
			dest[1]=((~*src<<shift1)&mask1) | (dest[1]&~mask1);
		}
	}

	return 0;
}
