/* $Id: visual.c,v 1.8 1998/10/18 15:52:17 becka Exp $
***************************************************************************

   Generic color handling library

   Copyright (C) 1998 Andrew Apted  [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdlib.h>

#include "color.h"

static int _GGIcalctotal(ggi_pixel mask)
{
	int total;

	for (total=0; mask != 0; mask >>= 1, total++) {
	}

	return total;
}

static void do_setup_color_info(ggi_visual *vis)
{
	color_hook *hk = (color_hook *) vis->colorpriv;
	
	if (GT_SCHEME(LIBGGI_GT(vis)) != GT_TRUECOLOR)
		return;

	hk->red_total   = _GGIcalctotal(LIBGGI_PIXFMT(vis)->red_mask);
	hk->green_total = _GGIcalctotal(LIBGGI_PIXFMT(vis)->green_mask);
	hk->blue_total  = _GGIcalctotal(LIBGGI_PIXFMT(vis)->blue_mask);
}

int GGIdlinit(ggi_visual *vis, const char *version,void *argptr)
{
	vis->colorpriv = _ggi_malloc(sizeof(color_hook));

	do_setup_color_info(vis);
	
	/* Color mapping
	 */
	 
	switch (GT_SCHEME(LIBGGI_GT(vis))) {

		case GT_PALETTE:
			vis->opcolor->mapcolor=GGI_color_PAL_mapcolor;
			vis->opcolor->unmappixel=GGI_color_PAL_unmappixel;
			break;

		case GT_TRUECOLOR:
			vis->opcolor->mapcolor=GGI_color_TRUE_mapcolor;
			vis->opcolor->unmappixel=GGI_color_TRUE_unmappixel;
			break;

		case GT_GREYSCALE:
			vis->opcolor->mapcolor=GGI_color_GREY_mapcolor;
			vis->opcolor->unmappixel=GGI_color_GREY_unmappixel;
			break;
	}

	if (! (GT_SUBSCHEME(LIBGGI_GT(vis)) & GT_SUB_PACKED_GETPUT))

	switch ((GT_SIZE(LIBGGI_GT(vis)) + 7) / 8) {

		case 1: vis->opcolor->packcolors=GGI_color_L1_packcolors;
			vis->opcolor->unpackpixels=GGI_color_L1_unpackpixels;
			break;

		case 2: vis->opcolor->packcolors=GGI_color_L2_packcolors;
			vis->opcolor->unpackpixels=GGI_color_L2_unpackpixels;
			break;

		case 3: vis->opcolor->packcolors=GGI_color_L3_packcolors;
			vis->opcolor->unpackpixels=GGI_color_L3_unpackpixels;
			break;

		case 4: vis->opcolor->packcolors=GGI_color_L4_packcolors;
			vis->opcolor->unpackpixels=GGI_color_L4_unpackpixels;
			break;
	}

	/* Palette handling
	 */
	vis->opcolor->getpalvec=GGI_color_getpalvec;

	/* Gamma mapping 
	 */
	
	vis->opcolor->getgamma=GGI_color_getgamma;	
	vis->opcolor->setgamma=GGI_color_setgamma;	

	return GGI_DL_OPCOLOR;
}

int GGIdlcleanup(ggi_visual *vis)
{
	free(vis->colorpriv);

	return 0;
}
		
#include <ggi/internal/ggidlinit.h>
